/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected Table table;
    protected PropertyContainer propObj;
    boolean embedded = false;

    public FetchFieldManager(ObjectProvider op, PropertyContainer node, Table table) {
        super(op);
        this.table = table;
        this.propObj = node;
        if (this.ec.getOwnersForEmbeddedObjectProvider(op) != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, PropertyContainer node, AbstractClassMetaData cmd, Table table) {
        super(ec, cmd);
        this.table = table;
        this.propObj = node;
        if (node == null) {
            throw new NucleusException("Attempt to create FetchFieldManager for " + this.op + " with null Neo4j Node!" + " Generate a testcase that reproduces this and raise an issue");
        }
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName())).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName())).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.propObj.getProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName());
    }

    public String fetchStringField(int fieldNumber) {
        String propName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        return this.propObj.hasProperty(propName) ? (String)this.propObj.getProperty(propName) : null;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.op.provideField(fieldNumber);
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embcmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embOP, this.propObj, embMmds, this.table);
                embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                throw new NucleusUserException("Dont currently support embedded multivalued field : " + mmd.getFullFieldName());
            }
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        boolean optional = false;
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            optional = true;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship. Not yet supported");
            }
            Node node = (Node)this.propObj;
            Optional value = this.processSingleValuedRelationForNode(mmd, relationType, this.ec, clr, node);
            return optional ? (value != null ? Optional.of(value) : Optional.empty()) : value;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship but has field " + mmd.getFullFieldName() + " which is multi-valued. This is illegal");
            }
            Node node = (Node)this.propObj;
            return this.processMultiValuedRelationForNode(mmd, relationType, this.ec, clr, node);
        }
        String propName = mapping.getColumn(0).getName();
        if (!this.propObj.hasProperty(propName)) {
            return optional ? Optional.empty() : null;
        }
        Object value = this.propObj.getProperty(propName);
        if (mmd.isSerialized()) {
            if (value instanceof String) {
                TypeConverter conv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, String.class);
                return conv.toMemberType((Object)((String)value));
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a serialised value," + " but we only support String serialisation and is " + value.getClass().getName());
        }
        Object returnValue = null;
        if (mapping.getTypeConverter() != null) {
            TypeConverter conv = mapping.getTypeConverter();
            if (mapping.getNumberOfColumns() > 1) {
                boolean isNull = true;
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    String colName = mapping.getColumn(i).getName();
                    if (this.propObj.hasProperty(colName)) {
                        isNull = false;
                        Array.set(valuesArr, i, this.propObj.getProperty(colName));
                        continue;
                    }
                    Array.set(valuesArr, i, null);
                }
                if (isNull) {
                    return null;
                }
                Object memberValue = conv.toMemberType((Object)valuesArr);
                if (this.op != null && memberValue != null) {
                    memberValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)memberValue, (boolean)true);
                }
                return memberValue;
            }
            String colName = mapping.getColumn(0).getName();
            if (!this.propObj.hasProperty(colName)) {
                return null;
            }
            Object propVal = this.propObj.getProperty(colName);
            returnValue = conv.toMemberType(propVal);
            if (optional) {
                Object object = returnValue = returnValue != null ? Optional.of(returnValue) : Optional.empty();
            }
            if (this.op != null) {
                returnValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), returnValue, (boolean)true);
            }
            return returnValue;
        }
        Optional<Object> fieldValue = Neo4jUtils.getFieldValueFromStored(this.ec, mmd, value, FieldRole.ROLE_FIELD);
        if (optional) {
            fieldValue = fieldValue != null ? Optional.of(fieldValue) : Optional.empty();
        }
        return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), fieldValue, (boolean)true) : fieldValue;
    }

    protected Object processSingleValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        DNRelationshipType type = DNRelationshipType.SINGLE_VALUED;
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            type = DNRelationshipType.MULTI_VALUED;
        }
        AbstractClassMetaData relCmd = null;
        String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
        String propNameValue = mmd.getName();
        if (mmd.getMappedBy() != null) {
            AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
            propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            relCmd = relMmds[0].getAbstractClassMetaData();
        } else if (relationType == RelationType.MANY_TO_ONE_BI) {
            AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
            propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            relCmd = relMmds[0].getAbstractClassMetaData();
        } else {
            boolean optional = Optional.class.isAssignableFrom(mmd.getType());
            Class memberType = optional ? clr.classForName(mmd.getCollection().getElementType()) : mmd.getType();
            relCmd = ec.getMetaDataManager().getMetaDataForClass(memberType, clr);
        }
        Iterable rels = node.getRelationships(new RelationshipType[]{type});
        if (rels != null) {
            for (Relationship rel : rels) {
                String memberName = (String)rel.getProperty(propNameKey);
                if (memberName == null || !memberName.equals(propNameValue)) continue;
                Node relNode = rel.getOtherNode(node);
                return Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)relNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)relNode, ec, relCmd), ec, false);
            }
        }
        return null;
    }

    protected Object processMultiValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        if (mmd.hasCollection()) {
            Iterable rels;
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr, ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if ((rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED})) != null) {
                if (coll instanceof List) {
                    List newColl;
                    HashMap<Integer, Node> nodeByPos = new HashMap<Integer, Node>();
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        int pos = (Integer)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME);
                        Node elemNode = rel.getOtherNode(node);
                        nodeByPos.put(pos, elemNode);
                    }
                    Object[] array = new Object[nodeByPos.size()];
                    for (Map.Entry entry : nodeByPos.entrySet()) {
                        Object elemPC;
                        Integer pos = (Integer)entry.getKey();
                        Node elemNode = (Node)entry.getValue();
                        array[pos.intValue()] = elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                    }
                    for (int i = 0; i < array.length; ++i) {
                        coll.add(array[i]);
                    }
                    array = null;
                    if (coll instanceof List && mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK") && (newColl = QueryUtils.orderCandidates((List)((List)coll), (Class)clr.classForName(mmd.getCollection().getElementType()), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)ec, (ClassLoaderResolver)clr)).getClass() != coll.getClass()) {
                        coll.clear();
                        coll.addAll(newColl);
                    }
                } else {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node elemNode = rel.getOtherNode(node);
                        Object elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                        coll.add(elemPC);
                    }
                }
            }
            if (this.op != null) {
                return SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)false);
            }
            return coll;
        }
        if (mmd.hasArray()) {
            Iterable rels;
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr, ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Object array = null;
            int arraySize = 0;
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if ((rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED})) != null) {
                for (Relationship rel : rels) {
                    String relMemberName = (String)rel.getProperty(propNameKey);
                    if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                    ++arraySize;
                }
                int i = 0;
                array = Array.newInstance(mmd.getType().getComponentType(), arraySize);
                for (Relationship rel : rels) {
                    String relMemberName = (String)rel.getProperty(propNameKey);
                    if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                    int position = i;
                    if (rel.hasProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME)) {
                        position = (Integer)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME);
                    }
                    Node elemNode = rel.getOtherNode(node);
                    Object elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                    Array.set(array, position, elemPC);
                    ++i;
                }
            }
            return array;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if (!mmd.getMap().keyIsPersistent() && mmd.getMap().valueIsPersistent()) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                if (rels != null) {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node valNode = rel.getOtherNode(node);
                        Object val = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)valNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)valNode, ec, valCmd), ec, false);
                        Object key = null;
                        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getMappedBy() != null) {
                            ObjectProvider valOP = ec.findObjectProvider(val);
                            key = valOP.provideField(valCmd.getAbsolutePositionOfMember(mmd.getKeyMetaData().getMappedBy()));
                        } else {
                            key = Neo4jUtils.getFieldValueFromStored(ec, mmd, rel.getProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE), FieldRole.ROLE_MAP_KEY);
                        }
                        map.put(key, val);
                    }
                }
                return map;
            }
            if (mmd.getMap().keyIsPersistent() && !mmd.getMap().valueIsPersistent()) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                if (rels != null) {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node keyNode = rel.getOtherNode(node);
                        Object key = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)keyNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)keyNode, ec, keyCmd), ec, false);
                        Object val = null;
                        if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() != null) {
                            ObjectProvider keyOP = ec.findObjectProvider(key);
                            val = keyOP.provideField(keyCmd.getAbsolutePositionOfMember(mmd.getValueMetaData().getMappedBy()));
                        } else {
                            val = Neo4jUtils.getFieldValueFromStored(ec, mmd, rel.getProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE), FieldRole.ROLE_MAP_VALUE);
                        }
                        map.put(key, val);
                    }
                }
                return map;
            }
            throw new NucleusUserException("Don't currently support maps of persistable objects : " + mmd.getFullFieldName());
        }
        return null;
    }
}

