/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class FetchFieldManager
extends AbstractFieldManager {
    protected ExecutionContext ec;
    protected ObjectProvider op;
    protected PropertyContainer propObj;
    protected AbstractClassMetaData cmd;
    boolean embedded = false;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(ObjectProvider op, PropertyContainer node) {
        this(op.getExecutionContext(), node, op.getClassMetaData());
        this.op = op;
        if (op.getEmbeddedOwners() != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, PropertyContainer node, AbstractClassMetaData acmd) {
        this.ec = ec;
        this.propObj = node;
        this.cmd = acmd;
        if (node == null) {
            throw new NucleusException("Attempt to create FetchFieldManager for " + this.op + " with null Neo4j Node!" + " Generate a testcase that reproduces this and raise an issue");
        }
    }

    protected String getPropName(int fieldNumber) {
        return this.ec.getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.propObj.getProperty(this.getPropName(fieldNumber))).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.propObj.getProperty(this.getPropName(fieldNumber))).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.propObj.getProperty(this.getPropName(fieldNumber));
    }

    public String fetchStringField(int fieldNumber) {
        String propName = this.getPropName(fieldNumber);
        return this.propObj.hasProperty(propName) ? (String)this.propObj.getProperty(propName) : null;
    }

    public Object fetchObjectField(int fieldNumber) {
        TypeConverter conv;
        Node node;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.op.provideField(fieldNumber);
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
            embedded = true;
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                embedded = true;
            }
        }
        if (!embedded && this.ownerMmd != null && RelationType.isRelationSingleValued((RelationType)relationType)) {
            AbstractMemberMetaData[] embMmds;
            if (this.ownerMmd.hasCollection()) {
                AbstractMemberMetaData[] embMmds2;
                EmbeddedMetaData embmd = this.ownerMmd.getElementMetaData().getEmbeddedMetaData();
                if (embmd != null && (embMmds2 = embmd.getMemberMetaData()) != null) {
                    for (AbstractMemberMetaData embMmd : embMmds2) {
                        if (!embMmd.getName().equals(mmd.getName()) || !embMmd.isEmbedded() && embMmd.getEmbeddedMetaData() == null) continue;
                        embedded = true;
                        break;
                    }
                }
            } else if (this.ownerMmd.getEmbeddedMetaData() != null && (embMmds = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()) != null) {
                for (AbstractMemberMetaData embMmd : embMmds) {
                    if (!embMmd.getName().equals(mmd.getName())) continue;
                    embedded = true;
                    break;
                }
            }
        }
        if (embedded) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if (this.ownerMmd != null && (RelationType.isBidirectional((RelationType)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()))) {
                    ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                    return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                }
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                AbstractMemberMetaData embMmd = mmd;
                if (this.ownerMmd != null) {
                    embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
                }
                ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embcmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embOP, this.propObj, embMmd);
                embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                throw new NucleusUserException("Dont currently support embedded multivalued field : " + mmd.getFullFieldName());
            }
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship. Not yet supported");
            }
            node = (Node)this.propObj;
            return this.processSingleValuedRelationForNode(mmd, relationType, this.ec, clr, node);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship but has field " + mmd.getFullFieldName() + " which is multi-valued. This is illegal");
            }
            node = (Node)this.propObj;
            return this.processMultiValuedRelationForNode(mmd, relationType, this.ec, clr, node);
        }
        String fieldName = this.getPropName(fieldNumber);
        if (!this.propObj.hasProperty(fieldName)) {
            return null;
        }
        Object value = this.propObj.getProperty(fieldName);
        if (mmd.isSerialized()) {
            if (value instanceof String) {
                conv = this.ec.getTypeManager().getTypeConverterForType(Serializable.class, String.class);
                return conv.toMemberType((Object)((String)value));
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a serialised value," + " but we only support String serialisation and is " + value.getClass().getName());
        }
        if (mmd.getTypeConverterName() != null) {
            conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
            return conv.toMemberType(value);
        }
        Object fieldValue = Neo4jUtils.getFieldValueFromStored(this.ec, mmd, value, 2);
        if (this.op != null) {
            return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), fieldValue, false, false, true);
        }
        return fieldValue;
    }

    protected Object processSingleValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        AbstractMemberMetaData[] relMmds;
        DNRelationshipType type = DNRelationshipType.SINGLE_VALUED;
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            type = DNRelationshipType.MULTI_VALUED;
        }
        AbstractClassMetaData relCmd = null;
        String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
        String propNameValue = mmd.getName();
        if (mmd.getMappedBy() != null) {
            relMmds = mmd.getRelatedMemberMetaData(clr);
            propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            relCmd = relMmds[0].getAbstractClassMetaData();
        } else if (relationType == RelationType.MANY_TO_ONE_BI) {
            relMmds = mmd.getRelatedMemberMetaData(clr);
            propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            relCmd = relMmds[0].getAbstractClassMetaData();
        } else {
            relCmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
        }
        Iterable rels = node.getRelationships(new RelationshipType[]{type});
        if (rels != null) {
            for (Relationship rel : rels) {
                String memberName = (String)rel.getProperty(propNameKey);
                if (memberName == null || !memberName.equals(propNameValue)) continue;
                Node relNode = rel.getOtherNode(node);
                return Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)relNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)relNode, ec, relCmd), ec, false);
            }
        }
        return null;
    }

    protected Object processMultiValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        if (mmd.hasCollection()) {
            Iterable rels;
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 3, clr, ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if ((rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED})) != null) {
                if (coll instanceof List) {
                    HashMap<Integer, Node> nodeByPos = new HashMap<Integer, Node>();
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        int pos = (Integer)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME);
                        Node elemNode = rel.getOtherNode(node);
                        nodeByPos.put(pos, elemNode);
                    }
                    Object[] array = new Object[nodeByPos.size()];
                    for (Map.Entry entry : nodeByPos.entrySet()) {
                        Object elemPC;
                        Integer pos = (Integer)entry.getKey();
                        Node elemNode = (Node)entry.getValue();
                        array[pos.intValue()] = elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                    }
                    for (int i = 0; i < array.length; ++i) {
                        coll.add(array[i]);
                    }
                    if (mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK")) {
                        coll = QueryUtils.orderCandidates((List)((List)coll), (Class)mmd.getType(), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)ec, (ClassLoaderResolver)clr);
                    }
                    array = null;
                } else {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node elemNode = rel.getOtherNode(node);
                        Object elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                        coll.add(elemPC);
                    }
                }
            }
            if (this.op != null) {
                return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, false);
            }
            return coll;
        }
        if (mmd.hasArray()) {
            Iterable rels;
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 4, clr, ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Object array = null;
            int arraySize = 0;
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if ((rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED})) != null) {
                for (Relationship rel : rels) {
                    String relMemberName = (String)rel.getProperty(propNameKey);
                    if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                    ++arraySize;
                }
                int i = 0;
                array = Array.newInstance(mmd.getType().getComponentType(), arraySize);
                for (Relationship rel : rels) {
                    String relMemberName = (String)rel.getProperty(propNameKey);
                    if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                    int position = i;
                    if (rel.hasProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME)) {
                        position = (Integer)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME);
                    }
                    Node elemNode = rel.getOtherNode(node);
                    Object elemPC = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)elemNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)elemNode, ec, elemCmd), ec, false);
                    Array.set(array, position, elemPC);
                    ++i;
                }
            }
            return array;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
            AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
            String propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME;
            if (relationType == RelationType.MANY_TO_MANY_BI && mmd.getMappedBy() != null) {
                propNameKey = Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER;
            }
            if (!mmd.getMap().keyIsPersistent() && mmd.getMap().valueIsPersistent()) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                if (rels != null) {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node valNode = rel.getOtherNode(node);
                        Object val = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)valNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)valNode, ec, valCmd), ec, false);
                        Object key = null;
                        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getMappedBy() != null) {
                            ObjectProvider valOP = ec.findObjectProvider(val);
                            key = valOP.provideField(valCmd.getAbsolutePositionOfMember(mmd.getKeyMetaData().getMappedBy()));
                        } else {
                            key = Neo4jUtils.getFieldValueFromStored(ec, mmd, rel.getProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE), 5);
                        }
                        map.put(key, val);
                    }
                }
                return map;
            }
            if (mmd.getMap().keyIsPersistent() && !mmd.getMap().valueIsPersistent()) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                if (rels != null) {
                    for (Relationship rel : rels) {
                        String relMemberName = (String)rel.getProperty(propNameKey);
                        if (relMemberName == null || !relMemberName.equals(mmd.getName())) continue;
                        Node keyNode = rel.getOtherNode(node);
                        Object key = Neo4jUtils.getObjectForPropertyContainer((PropertyContainer)keyNode, Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)keyNode, ec, keyCmd), ec, false);
                        Object val = null;
                        if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() != null) {
                            ObjectProvider keyOP = ec.findObjectProvider(key);
                            val = keyOP.provideField(keyCmd.getAbsolutePositionOfMember(mmd.getValueMetaData().getMappedBy()));
                        } else {
                            val = Neo4jUtils.getFieldValueFromStored(ec, mmd, rel.getProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE), 6);
                        }
                        map.put(key, val);
                    }
                }
                return map;
            }
            throw new NucleusUserException("Don't currently support maps of persistable objects : " + mmd.getFullFieldName());
        }
        return null;
    }
}

