/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.neo4j.query.LazyLoadQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;

public class Neo4jUtils {
    public static PropertyContainer getPropertyContainerForObjectProvider(GraphDatabaseService graphDB, ObjectProvider op) {
        Object val = op.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER);
        if (val != null) {
            return (PropertyContainer)val;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectId(graphDB, ec, cmd, op.getInternalObjectId());
        if (propObj != null) {
            op.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
        }
        return propObj;
    }

    public static PropertyContainer getPropertyContainerForObjectId(GraphDatabaseService graphDB, ExecutionContext ec, AbstractClassMetaData cmd, Object id) {
        Iterator iter;
        StoreManager storeMgr = ec.getStoreManager();
        boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
        if (cmd.pkIsDatastoreAttributed(storeMgr)) {
            int[] pkFieldNumbers;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)id;
                Long key = (Long)oid.getKeyValue();
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving PropertyContainer for id=" + key));
                }
                return attributedRelation ? graphDB.getRelationshipById(key.longValue()) : graphDB.getNodeById(key.longValue());
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION && (pkFieldNumbers = cmd.getPKMemberPositions()).length == 1) {
                Long key = (Long)ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving PropertyContainer for id=" + key));
                }
                return attributedRelation ? graphDB.getRelationshipById(key.longValue()) : graphDB.getNodeById(key.longValue());
            }
        }
        if (attributedRelation ? !graphDB.index().existsForRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX) : !graphDB.index().existsForNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX)) {
            return null;
        }
        StringBuffer cypherString = new StringBuffer();
        cypherString.append("START pc=" + (attributedRelation ? "relationship:" : "node:") + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX + "(" + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY + "=\"" + cmd.getFullClassName() + "\")");
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            cypherString.append(" WHERE (");
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = null;
                value = cmd.usesSingleFieldIdentityClass() ? ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id) : IdentityUtils.getValueForMemberInId((Object)id, (AbstractMemberMetaData)pkMmd);
                cypherString.append("pc." + ec.getStoreManager().getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN));
                cypherString.append(" = ");
                Object storedValue = Neo4jUtils.getStoredValueForField(ec, pkMmd, value, 2);
                if (storedValue instanceof String) {
                    cypherString.append("\"" + storedValue + "\"");
                } else {
                    cypherString.append(storedValue);
                }
                if (i == pkPositions.length - 1) continue;
                cypherString.append(" and ");
            }
            cypherString.append(")");
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)id;
            if (oid == null && storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = oid.getKeyValue();
            String propName = ec.getStoreManager().getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            cypherString.append(" WHERE (pc.");
            cypherString.append(propName);
            cypherString.append(" = ");
            cypherString.append(Neo4jUtils.getStoredValueForField(ec, null, value, 2));
            cypherString.append(")");
        } else {
            throw new NucleusException("Impossible to retrieve Node/Relationship for nondurable identity");
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            String propName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            cypherString.append(" and (pc.").append(propName).append(" = \"").append((Object)discVal).append("\")");
        }
        cypherString.append(" RETURN pc");
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object using Cypher query : " + cypherString));
        }
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult result = engine.execute(cypherString.toString());
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        if (!(iter = result.iterator()).hasNext()) {
            return null;
        }
        Map map = (Map)iter.next();
        PropertyContainer propObj = (PropertyContainer)map.get("pc");
        if (iter.hasNext()) {
            throw new NucleusException("Query of Node/Relationship for object with id=" + id + " returned more than 1 result! : " + cypherString);
        }
        return propObj;
    }

    public static List executeCypherQuery(Query query, GraphDatabaseService db, String cypherText, AbstractClassMetaData candidateCmd) {
        int limitStart;
        int skipStart;
        int resultStart;
        String resultStr;
        int orderByStart;
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects of type " + candidateCmd.getFullClassName() + " using Cypher query : " + cypherText));
        }
        if ((orderByStart = (resultStr = cypherText.substring(resultStart = cypherText.indexOf("RETURN ") + 7)).indexOf(" ORDER BY")) > 0) {
            resultStr = resultStr.substring(0, orderByStart);
        }
        if ((skipStart = resultStr.indexOf(" SKIP")) > 0) {
            resultStr = resultStr.substring(0, skipStart);
        }
        if ((limitStart = resultStr.indexOf(" LIMIT")) > 0) {
            resultStr = resultStr.substring(0, limitStart);
        }
        if (resultStr.equals(query.getCompilation().getCandidateAlias())) {
            resultStr = null;
        }
        ExecutionEngine engine = new ExecutionEngine(db);
        ExecutionResult queryResult = engine.execute(cypherText);
        return new LazyLoadQueryResult(query, queryResult, resultStr);
    }

    public static String getCypherTextForQuery(ExecutionContext ec, AbstractClassMetaData cmd, String candidateAlias, boolean subclasses, String filterText, String resultText, String orderText, Long rangeFromIncl, Long rangeToExcl) {
        boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
        if (candidateAlias == null) {
            candidateAlias = attributedRelation ? "r" : "n";
        }
        StoreManager storeMgr = ec.getStoreManager();
        StringBuffer cypherString = new StringBuffer();
        String indexClassName = cmd.getFullClassName();
        if (!subclasses) {
            indexClassName = indexClassName + "-EXCLUSIVE";
        }
        cypherString.append("START " + candidateAlias + (attributedRelation ? "=relationship:" : "=node:") + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX + "(" + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY + "=\"" + indexClassName + "\")");
        boolean multiple = false;
        String multitenancyText = null;
        if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            String propName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            String value = storeMgr.getStringProperty("datanucleus.TenantID");
            multitenancyText = propName + " = \"" + value + "\"";
            if (filterText != null) {
                multiple = true;
            }
        }
        if (filterText != null || multitenancyText != null) {
            cypherString.append(" WHERE ");
            boolean started = false;
            if (filterText != null) {
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(filterText);
                if (multiple) {
                    cypherString.append(")");
                }
                started = true;
            }
            if (multitenancyText != null) {
                if (started) {
                    cypherString.append(" and");
                }
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(multitenancyText);
                if (multiple) {
                    cypherString.append(")");
                }
            }
        }
        if (resultText != null) {
            cypherString.append(" RETURN " + resultText);
        } else {
            cypherString.append(" RETURN " + candidateAlias);
        }
        if (orderText != null) {
            cypherString.append(" ORDER BY " + orderText);
        }
        if (rangeFromIncl != null || rangeToExcl != null) {
            long lower = 0L;
            if (rangeFromIncl != null) {
                lower = rangeFromIncl;
                cypherString.append(" SKIP " + rangeFromIncl);
            }
            if (rangeToExcl != null) {
                cypherString.append(" LIMIT " + (rangeToExcl - lower));
            }
        }
        return cypherString.toString();
    }

    public static AbstractClassMetaData getClassMetaDataForPropertyContainer(PropertyContainer propObj, ExecutionContext ec, AbstractClassMetaData cmd) {
        block6: {
            block5: {
                boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
                if (!attributedRelation) break block5;
                RelationshipIndex typesIdx = propObj.getGraphDatabase().index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX);
                String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false);
                if (subclassNames == null) break block6;
                for (int i = 0; i < subclassNames.length; ++i) {
                    AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], ec.getClassLoaderResolver());
                    IndexHits relsForSubclass = typesIdx.get(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)subcmd.getFullClassName());
                    if (relsForSubclass == null) continue;
                    for (Relationship subclassRel : relsForSubclass) {
                        if (!subclassRel.equals(propObj)) continue;
                        return Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)subclassRel, ec, subcmd);
                    }
                }
                break block6;
            }
            Index typesIdx = propObj.getGraphDatabase().index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX);
            String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false);
            if (subclassNames != null) {
                for (int i = 0; i < subclassNames.length; ++i) {
                    AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], ec.getClassLoaderResolver());
                    IndexHits nodesForSubclass = typesIdx.get(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)subcmd.getFullClassName());
                    if (nodesForSubclass == null) continue;
                    for (Node subclassNode : nodesForSubclass) {
                        if (!subclassNode.equals(propObj)) continue;
                        return Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)subclassNode, ec, subcmd);
                    }
                }
            }
        }
        return cmd;
    }

    public static Object getObjectForPropertyContainer(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache) {
        ec.getFetchPlan().manageFetchPlanForClass(cmd);
        int[] fpMembers = ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
        Object obj = null;
        obj = cmd.getIdentityType() == IdentityType.APPLICATION ? Neo4jUtils.getObjectUsingApplicationIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? Neo4jUtils.getObjectUsingDatastoreIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers) : Neo4jUtils.getObjectUsingNondurableIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers));
        return obj;
    }

    protected static Object getObjectUsingApplicationIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        FetchFieldManager fm = new FetchFieldManager(ec, propObj, cmd);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        StoreManager storeMgr = ec.getStoreManager();
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, false, false, type.getName());
        ObjectProvider op = ec.findObjectProvider(pc);
        if (op.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            op.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            op.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    version = op.provideField(verMmd.getAbsoluteFieldNumber());
                } else {
                    version = propObj.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
                }
                op.setVersion(version);
            }
        }
        return pc;
    }

    protected static Object getObjectUsingDatastoreIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Class type;
        StoreManager storeMgr = ec.getStoreManager();
        Object idKey = propObj.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
        OID id = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Object pc = ec.findObject((Object)id, false, false, (type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName())).getName());
        ObjectProvider op = ec.findObjectProvider(pc);
        if (op.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            op.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            FetchFieldManager fm = new FetchFieldManager(ec, propObj, cmd);
            op.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    version = op.provideField(verMmd.getAbsoluteFieldNumber());
                } else {
                    version = propObj.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
                }
                op.setVersion(version);
            }
        }
        return pc;
    }

    protected static Object getObjectUsingNondurableIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Class type;
        SCOID id = new SCOID(cmd.getFullClassName());
        Object pc = ec.findObject((Object)id, false, false, (type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName())).getName());
        ObjectProvider op = ec.findObjectProvider(pc);
        if (op.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            op.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            FetchFieldManager fm = new FetchFieldManager(ec, propObj, cmd);
            op.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                StoreManager storeMgr = ec.getStoreManager();
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    version = op.provideField(verMmd.getAbsoluteFieldNumber());
                } else {
                    version = propObj.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
                }
                op.setVersion(version);
            }
        }
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (mmd != null && mmd.hasCollection() && fieldRole == 2) {
            Collection rawColl = (Collection)value;
            if (rawColl.size() == 0) {
                return null;
            }
            Object[] objArray = new Object[rawColl.size()];
            int i = 0;
            for (Object elem : rawColl) {
                Object storeElem = Neo4jUtils.getStoredValueForField(ec, mmd, elem, 3);
                objArray[i++] = storeElem;
            }
            return Neo4jUtils.convertArrayToStorableArray(objArray, mmd);
        }
        if (mmd != null && mmd.hasArray() && fieldRole == 2) {
            if (Array.getLength(value) == 0) {
                return null;
            }
            if (type.getComponentType().isPrimitive()) {
                return value;
            }
            if (type.getComponentType() == String.class) {
                return value;
            }
            Object[] objArray = new Object[Array.getLength(value)];
            for (int i = 0; i < objArray.length; ++i) {
                Object storeElem;
                Object elem = Array.get(value, i);
                objArray[i] = storeElem = Neo4jUtils.getStoredValueForField(ec, mmd, elem, 4);
            }
            return Neo4jUtils.convertArrayToStorableArray(objArray, mmd);
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            boolean useNumeric;
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            return (useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    private static Object convertArrayToStorableArray(Object[] objArray, AbstractMemberMetaData mmd) {
        if (objArray == null || objArray.length == 0) {
            return null;
        }
        Object array = objArray;
        Class<?> cmptCls = objArray[0].getClass();
        if (ClassUtils.isPrimitiveWrapperType((String)cmptCls.getName())) {
            Class primType = ClassUtils.getPrimitiveTypeForType(cmptCls);
            array = Array.newInstance(primType, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                Array.set(array, i, objArray[i]);
            }
        } else if (cmptCls.isPrimitive() || cmptCls == String.class) {
            array = Array.newInstance(cmptCls, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                Array.set(array, i, objArray[i]);
            }
        } else {
            throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted to Neo4j since Neo4j doesn't natively support such a type (" + mmd.getType() + ")");
        }
        return array;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (mmd != null && mmd.hasCollection() && fieldRole == 2) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object elem = Array.get(value, i);
                Object storeElem = Neo4jUtils.getFieldValueFromStored(ec, mmd, elem, 3);
                coll.add(storeElem);
            }
            return coll;
        }
        if (mmd != null && mmd.hasArray() && fieldRole == 2) {
            Object array = Array.newInstance(mmd.getType().getComponentType(), Array.getLength(value));
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object elem = Array.get(value, i);
                Object storeElem = Neo4jUtils.getFieldValueFromStored(ec, mmd, elem, 4);
                Array.set(array, i++, storeElem);
            }
            return array;
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return type.getEnumConstants()[((Number)value).intValue()];
            }
            return Enum.valueOf(type, (String)value);
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static String getPropertyNameForEmbeddedField(AbstractMemberMetaData ownerMmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = ownerMmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdentity(Object id, AbstractClassMetaData rootCmd, ExecutionContext ec, ClassLoaderResolver clr) {
        StoreManager storeMgr = ec.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectId(db, ec, rootCmd, id);
            if (propObj instanceof Node) {
                AbstractClassMetaData cmd = Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)((Node)propObj), ec, rootCmd);
                String string = cmd.getFullClassName();
                return string;
            }
            String string = rootCmd.getFullClassName();
            return string;
        }
        finally {
            mconn.release();
        }
    }

    public static boolean classIsAttributedRelation(AbstractClassMetaData cmd) {
        return cmd.hasExtension(Neo4jStoreManager.METADATA_ATTRIBUTED_RELATION) && cmd.getValueForExtension(Neo4jStoreManager.METADATA_ATTRIBUTED_RELATION).equalsIgnoreCase("TRUE");
    }
}

