/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.query.Neo4jQueryCompilation;
import org.datanucleus.store.neo4j.query.QueryToCypherMapper;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.GraphDatabaseService;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    protected transient Neo4jQueryCompilation datastoreCompilation = null;

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(LOCALISER.msg("021009", (Object)this.candidateClassName));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        AbstractClassMetaData cmd = this.getCandidateClassMetaData();
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (Neo4jQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                return;
            }
        }
        Neo4jQueryCompilation neo4jQueryCompilation = this.datastoreCompilation = new Neo4jQueryCompilation();
        synchronized (neo4jQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    protected AbstractClassMetaData getCandidateClassMetaData() {
        String[] impls;
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        if (this.candidateClass.isInterface() && ((impls = this.ec.getMetaDataManager().getClassesImplementingInterface(this.candidateClass.getName(), this.clr)).length != 1 || !cmd.isImplementationOfPersistentDefinition()) && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.candidateClass, this.clr)) == null) {
            throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            String cypherText;
            AbstractClassMetaData cmd;
            boolean rangeInMemory;
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            List candidates = null;
            boolean filterInMemory = this.filter != null;
            boolean resultInMemory = this.result != null;
            boolean orderInMemory = this.ordering != null;
            boolean bl = rangeInMemory = this.range != null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else if (this.evaluateInMemory()) {
                if (!db.index().existsForNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX)) {
                    candidates = new ArrayList();
                } else {
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.ec.getClassLoaderResolver());
                    cypherText = Neo4jUtils.getCypherTextForQuery(this.ec, cmd, this.compilation.getCandidateAlias(), this.subclasses, null, null, null, null, null);
                    candidates = Neo4jUtils.executeCypherQuery((Query)this, db, cypherText, cmd);
                }
            } else {
                boolean bl2 = filterInMemory = !this.datastoreCompilation.isFilterComplete();
                if (!filterInMemory) {
                    resultInMemory = !this.datastoreCompilation.isResultComplete();
                    boolean bl3 = orderInMemory = !this.datastoreCompilation.isOrderComplete();
                    if (!orderInMemory) {
                        boolean bl4 = rangeInMemory = !this.datastoreCompilation.isRangeComplete();
                    }
                }
                if (!db.index().existsForNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX)) {
                    candidates = new ArrayList();
                } else {
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.ec.getClassLoaderResolver());
                    cypherText = this.datastoreCompilation.getCypherText();
                    candidates = Neo4jUtils.executeCypherQuery((Query)this, db, cypherText, cmd);
                }
            }
            Collection results = candidates;
            if (filterInMemory || resultInMemory || rangeInMemory || this.resultClass != null || orderInMemory) {
                if (results instanceof QueryResult) {
                    ((QueryResult)results).disconnect();
                }
                JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, results, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory, resultInMemory, true, rangeInMemory);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (results instanceof QueryResult) {
                final QueryResult qr1 = (QueryResult)results;
                final ManagedConnection mconn1 = mconn;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr1.disconnect();
                    }

                    public void managedConnectionPreClose() {
                        if (!JDOQLQuery.this.ec.getTransaction().isActive()) {
                            qr1.disconnect();
                        }
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                    }
                };
                mconn.addListener(listener);
                if (qr1 instanceof AbstractQueryResult) {
                    ((AbstractQueryResult)qr1).addConnectionListener(listener);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        QueryToCypherMapper mapper = new QueryToCypherMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile(this.datastoreCompilation);
        if (this.candidateCollection != null) {
            // empty if block
        }
        if (this.range == null || !this.datastoreCompilation.isFilterComplete() || this.datastoreCompilation.isOrderComplete()) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }
}

