/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.sql.SQLException;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.neo4j.Localisation", (ClassLoader)Neo4jStoreManager.class.getClassLoader());
    String dbName = "DataNucleus";
    GraphDatabaseFactory factory;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(6).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        if (remains.length() > 0) {
            this.dbName = remains;
        }
        this.factory = new GraphDatabaseFactory();
    }

    public void close() {
        super.close();
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        boolean releaseAfterUse;
        ManagedConnectionImpl mc = new ManagedConnectionImpl(transactionOptions);
        if (this.resourceType.equalsIgnoreCase("nontx") && !(releaseAfterUse = this.storeMgr.getBooleanProperty("datanucleus.connection.nontx.releaseAfterUse"))) {
            mc.setPooled();
        }
        return mc;
    }

    static class EmulatedXAResource
    implements XAResource {
        Transaction graphTx;

        EmulatedXAResource(Transaction graphTx) {
            this.graphTx = graphTx;
        }

        public void start(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting for transaction " + xid.toString() + " with flags " + flags));
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with onePhase=" + onePhase));
            this.graphTx.success();
            this.graphTx.finish();
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with onePhase=" + onePhase));
        }

        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            this.graphTx.failure();
            this.graphTx.finish();
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
        }

        public void end(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is ending for transaction " + xid.toString() + " with flags " + flags));
        }

        public void forget(Xid xid) throws XAException {
        }

        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int timeout) throws XAException {
            return false;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Map options;
        Transaction graphTx;
        boolean committed = false;

        public ManagedConnectionImpl(Map options) {
            this.options = options;
        }

        public Object getConnection() {
            if (this.conn == null) {
                GraphDatabaseService graphDB = ConnectionFactoryImpl.this.factory.newEmbeddedDatabase(ConnectionFactoryImpl.this.dbName);
                this.registerShutdownHook(graphDB);
                this.conn = graphDB;
                this.graphTx = graphDB.beginTx();
            }
            this.committed = false;
            return this.conn;
        }

        public void release() {
            if (this.commitOnRelease && this.conn != null) {
                this.graphTx.success();
                this.graphTx.finish();
                this.committed = true;
            }
            super.release();
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            if (!this.committed) {
                this.graphTx.success();
                this.graphTx.finish();
            }
            ((GraphDatabaseService)this.conn).shutdown();
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            this.conn = null;
            this.graphTx = null;
        }

        public XAResource getXAResource() {
            if (this.getConnection() instanceof GraphDatabaseService) {
                return new EmulatedXAResource(this.graphTx);
            }
            try {
                return ((XAConnection)this.getConnection()).getXAResource();
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }

        private void registerShutdownHook(final GraphDatabaseService graphDb) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    graphDb.shutdown();
                }
            });
        }
    }
}

