/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.sco.SCOUtils;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class FetchFieldManager
extends AbstractFieldManager {
    protected ExecutionContext ec;
    protected ObjectProvider op;
    protected Node node;
    protected AbstractClassMetaData cmd;
    boolean embedded = false;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(ObjectProvider op, Node node) {
        this(op.getExecutionContext(), node, op.getClassMetaData());
        this.op = op;
        if (op.getEmbeddedOwners() != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, Node node, AbstractClassMetaData acmd) {
        this.ec = ec;
        this.node = node;
        this.cmd = acmd;
        if (node == null) {
            throw new NucleusException("Attempt to create FetchFieldManager for " + this.op + " with null Neo4j Node!" + " Generate a testcase that reprocues this and raise an issue");
        }
    }

    protected String getPropName(int fieldNumber) {
        return this.ec.getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.node.getProperty(this.getPropName(fieldNumber))).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.node.getProperty(this.getPropName(fieldNumber))).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public String fetchStringField(int fieldNumber) {
        return (String)this.node.getProperty(this.getPropName(fieldNumber));
    }

    public Object fetchObjectField(int fieldNumber) {
        String fieldName;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.op.provideField(fieldNumber);
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (this.embedded || this.ownerMmd != null) {
            embedded = true;
        } else if (relationType != 0) {
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (Relation.isRelationSingleValued((int)relationType)) {
                AbstractClassMetaData embcmd;
                if (this.ownerMmd != null) {
                    if (Relation.isBidirectional((int)relationType)) {
                        if (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy())) {
                            ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                            return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                        }
                    } else if (this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())) {
                        ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                        return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                    }
                }
                if ((embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr)) == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                AbstractMemberMetaData embMmd = mmd;
                if (this.ownerMmd != null) {
                    embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
                }
                ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embOP, this.node, embMmd);
                embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embOP.getObject();
            }
            throw new NucleusUserException("Dont currently support embedded field : " + mmd.getFullFieldName());
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            AbstractMemberMetaData[] relMmds;
            DNRelationshipType type = DNRelationshipType.SINGLE_VALUED;
            if (relationType == 6) {
                type = DNRelationshipType.MULTI_VALUED;
            }
            AbstractClassMetaData relCmd = null;
            String requiredFieldName = mmd.getName();
            if (mmd.getMappedBy() != null) {
                relMmds = mmd.getRelatedMemberMetaData(clr);
                requiredFieldName = relMmds[0].getName();
                relCmd = relMmds[0].getAbstractClassMetaData();
            } else if (relationType == 6) {
                relMmds = mmd.getRelatedMemberMetaData(clr);
                requiredFieldName = relMmds[0].getName();
                relCmd = relMmds[0].getAbstractClassMetaData();
            } else {
                relCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            }
            Iterable rels = this.node.getRelationships(new RelationshipType[]{type});
            if (rels != null) {
                for (Relationship rel : rels) {
                    String fieldName2 = (String)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME);
                    if (fieldName2 == null || !fieldName2.equals(requiredFieldName)) continue;
                    Node otherNode = rel.getOtherNode(this.node);
                    return Neo4jUtils.getObjectForNode(otherNode, relCmd, this.ec, false, null);
                }
            }
            return null;
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                Iterable rels;
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                if (elemCmd == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 3, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length == 1) {
                        elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (elemCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                    }
                }
                if ((rels = this.node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED})) != null) {
                    for (Relationship rel : rels) {
                        String fieldName3 = (String)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME);
                        if (fieldName3 == null || !fieldName3.equals(mmd.getName())) continue;
                        if (rel.hasProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME)) {
                            // empty if block
                        }
                        Node elemNode = rel.getOtherNode(this.node);
                        Object elemPC = Neo4jUtils.getObjectForNode(elemNode, elemCmd, this.ec, false, null);
                        coll.add(elemPC);
                    }
                }
                return coll;
            }
            if (mmd.hasArray()) {
                AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                if (elemCmd == null) {
                    String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 4, clr, this.ec.getMetaDataManager());
                    if (implNames != null && implNames.length == 1) {
                        elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                    }
                    if (elemCmd == null) {
                        throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                    }
                }
                Object array = null;
                int arraySize = 0;
                Iterable rels = this.node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                if (rels != null) {
                    for (Relationship rel : rels) {
                        String fieldName4 = (String)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME);
                        if (fieldName4 == null || !fieldName4.equals(mmd.getName())) continue;
                        ++arraySize;
                    }
                    int i = 0;
                    array = Array.newInstance(mmd.getType().getComponentType(), arraySize);
                    for (Relationship rel : rels) {
                        String fieldName5 = (String)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME);
                        if (fieldName5 == null || !fieldName5.equals(mmd.getName())) continue;
                        int position = i;
                        if (rel.hasProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME)) {
                            position = (Integer)rel.getProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME);
                        }
                        Node elemNode = rel.getOtherNode(this.node);
                        Object elemPC = Neo4jUtils.getObjectForNode(elemNode, elemCmd, this.ec, false, null);
                        Array.set(array, position, elemPC);
                        ++i;
                    }
                }
                return array;
            }
            if (mmd.hasMap()) {
                throw new NucleusUserException("Don't currently support 1-N/M-N maps : " + mmd.getFullFieldName());
            }
        }
        if (!this.node.hasProperty(fieldName = this.getPropName(fieldNumber))) {
            return null;
        }
        Object value = this.node.getProperty(fieldName);
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Dont currently support serialised fields : " + mmd.getFullFieldName());
        }
        if (mmd.getTypeConverterName() != null) {
            TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
            return conv.toMemberType(value);
        }
        Object fieldValue = Neo4jUtils.getFieldValueFromStored(this.ec, mmd, value, 2);
        if (this.op != null) {
            return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), fieldValue, false, false, true);
        }
        return fieldValue;
    }
}

