/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jUtils {
    public static Node getNodeForObjectProvider(GraphDatabaseService graphDB, ObjectProvider op) {
        ExecutionContext ec;
        StoreManager storeMgr;
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.pkIsDatastoreAttributed(storeMgr = (ec = op.getExecutionContext()).getStoreManager())) {
            int[] pkFieldNumbers;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)op.getInternalObjectId();
                Long key = (Long)oid.getKeyValue();
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving Node for id=" + key));
                }
                return graphDB.getNodeById(key.longValue());
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION && (pkFieldNumbers = cmd.getPKMemberPositions()).length == 1) {
                Long key = (Long)ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(op.getInternalObjectId());
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving Node for id=" + key));
                }
                return graphDB.getNodeById(key.longValue());
            }
        }
        graphDB.index().forNodes(Neo4jStoreManager.NODE_TYPE_INDEX_NAME);
        StringBuffer cypherString = new StringBuffer();
        cypherString.append("START n=node:" + Neo4jStoreManager.NODE_TYPE_INDEX_NAME + "(class=\"" + cmd.getFullClassName() + "\")");
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            cypherString.append(" WHERE (");
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = op.provideField(pkPositions[i]);
                cypherString.append("n." + ec.getStoreManager().getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN));
                cypherString.append(" = ");
                Object storedValue = Neo4jUtils.getStoredValueForField(ec, pkMmd, value, 2);
                if (storedValue instanceof String) {
                    cypherString.append("\"" + storedValue + "\"");
                } else {
                    cypherString.append(storedValue);
                }
                if (i == pkPositions.length - 1) continue;
                cypherString.append(" and ");
            }
            cypherString.append(")");
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)op.getObjectId();
            if (oid == null && storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = oid.getKeyValue();
            String propName = ec.getStoreManager().getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            cypherString.append(" WHERE (n.");
            cypherString.append(propName);
            cypherString.append(" = ");
            cypherString.append(Neo4jUtils.getStoredValueForField(ec, null, value, 2));
            cypherString.append(")");
        }
        cypherString.append(" RETURN n");
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects using Cypher query : " + cypherString));
        }
        Node node = null;
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult result = engine.execute(cypherString.toString());
        Iterator iter = result.iterator();
        int size = 0;
        while (iter.hasNext()) {
            ++size;
            Map map = (Map)iter.next();
            if (map.size() <= 0) continue;
            node = (Node)map.get("n");
        }
        if (size > 1) {
            throw new NucleusException("Query of Node for " + op + " (id=" + op.getInternalObjectId() + ") returned " + size + " results! " + cypherString);
        }
        if (op.getExecutionContext().getStatistics() != null) {
            op.getExecutionContext().getStatistics().incrementNumReads();
        }
        return node;
    }

    public static List getObjectsOfCandidateType(ExecutionContext ec, GraphDatabaseService db, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fp, Map<String, Object> options, String candidateAliasName, String filterText, String orderText) {
        if (candidateAliasName == null) {
            candidateAliasName = "n";
        }
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, ec.getClassLoaderResolver());
        StringBuffer cypherString = new StringBuffer();
        cypherString.append("START " + candidateAliasName + "=node:" + Neo4jStoreManager.NODE_TYPE_INDEX_NAME + "(class=\"" + cmd.getFullClassName() + "\")");
        if (filterText != null) {
            cypherString.append(" WHERE " + filterText);
        }
        cypherString.append(" RETURN " + candidateAliasName);
        if (orderText != null) {
            cypherString.append(" ORDER BY " + orderText);
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects using Cypher query : " + cypherString));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ExecutionEngine engine = new ExecutionEngine(db);
        ExecutionResult queryResult = engine.execute(cypherString.toString());
        Iterator iter = queryResult.iterator();
        fp.manageFetchPlanForClass(cmd);
        int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            if (map.size() <= 0) continue;
            Node node = (Node)map.get(candidateAliasName);
            Object obj = Neo4jUtils.getObjectForNode(node, cmd, ec, ignoreCache, fpMembers);
            if (subclasses) {
                results.add(obj);
                continue;
            }
            if (subclasses || !obj.getClass().getName().equals(cmd.getFullClassName())) continue;
            results.add(obj);
        }
        return results;
    }

    public static Object getObjectForNode(Node node, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, int[] fpMembers) {
        if (fpMembers == null) {
            ec.getFetchPlan().manageFetchPlanForClass(cmd);
            fpMembers = ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
        }
        Object obj = null;
        obj = cmd.getIdentityType() == IdentityType.APPLICATION ? Neo4jUtils.getObjectUsingApplicationIdForDBObject(node, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? Neo4jUtils.getObjectUsingDatastoreIdForDBObject(node, cmd, ec, ignoreCache, fpMembers) : Neo4jUtils.getObjectUsingNondurableIdForDBObject(node, cmd, ec, ignoreCache, fpMembers));
        return obj;
    }

    public static Object getObjectUsingApplicationIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, node, cmd));
        StoreManager storeMgr = ec.getStoreManager();
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingDatastoreIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        StoreManager storeMgr = ec.getStoreManager();
        Object idKey = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
        OID oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingNondurableIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        SCOID oid = new SCOID(cmd.getFullClassName());
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            StoreManager storeMgr = ec.getStoreManager();
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            boolean useNumeric;
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            return (useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return type.getEnumConstants()[((Number)value).intValue()];
            }
            return Enum.valueOf(type, (String)value);
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static String getPropertyNameForEmbeddedField(AbstractMemberMetaData ownerMmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = ownerMmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        return columnName;
    }
}

