/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.NucleusLogger;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public FetchEmbeddedFieldManager(DNStateManager sm, DBObject dbObject, List<AbstractMemberMetaData> mmds, Table table) {
        super(sm, dbObject, table);
        this.ownerMmd = mmds != null ? mmds.get(mmds.size() - 1) : null;
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            DNStateManager[] ownerSMs = this.ec.getOwnersForEmbeddedStateManager(this.sm);
            return ownerSMs != null && ownerSMs.length > 0 ? ownerSMs[0].getObject() : null;
        }
        RelationType relationType = mmd.getRelationType(clr);
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(mmd);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                boolean nested = MongoDBUtils.isMemberNested(mmd);
                DBObject subObject = this.dbObject;
                if (nested) {
                    subObject = (DBObject)this.dbObject.get(mapping.getColumn(0).getName());
                    if (subObject == null) {
                        return null;
                    }
                } else if (embmd != null) {
                    AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                    boolean isNull = true;
                    for (int i = 0; i < embmmds.length; ++i) {
                        String embFieldName = MongoDBUtils.getFieldName(this.ownerMmd, i);
                        if (!this.dbObject.containsField(embFieldName)) continue;
                        isNull = false;
                        break;
                    }
                    if (isNull) {
                        return null;
                    }
                }
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embCmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embSM, subObject, embMmds, this.table);
                embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embSM.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                ColumnMetaData[] columnMetaData = mapping.getMemberMetaData().getElementMetaData().getColumnMetaData();
                if (columnMetaData.length == 0) {
                    return null;
                }
                String embeddedCollectionColumn = columnMetaData[0].getName();
                DBObject subObject = (DBObject)this.dbObject.get(embeddedCollectionColumn);
                if (subObject == null) {
                    return null;
                }
                if (mmd.hasCollection()) {
                    Collection coll;
                    AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection collValue = (Collection)subObject;
                    for (Object aCollValue : collValue) {
                        DBObject elementObj = (DBObject)aCollValue;
                        DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, elemCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)2);
                        FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, elementObj, embMmds, this.table);
                        ffm.ownerMmd = mmd;
                        embSM.replaceFields(elemCmd.getAllMemberPositions(), (FieldManager)ffm);
                        coll.add(embSM.getObject());
                    }
                    return coll;
                }
                if (mmd.hasArray()) {
                    NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported as embedded array into the owning embedded object"));
                }
                if (mmd.hasMap()) {
                    NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported as embedded map into the owning embedded object"));
                }
            }
            return null;
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }
}

