/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    public static final String OP_DB_OBJECT = "DB_OBJECT";

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertObjects(DNStateManager ... sms) {
        if (sms.length == 1) {
            this.insertObject(sms[0]);
            return;
        }
        for (DNStateManager sm : sms) {
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (!cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
            this.insertObject(sm);
        }
        ExecutionContext ec = sms[0].getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            HashMap<String, HashSet<DNStateManager>> smsByTable = new HashMap<String, HashSet<DNStateManager>>();
            for (DNStateManager sm : sms) {
                Table table;
                String tableName;
                HashSet<DNStateManager> smsForTable;
                AbstractClassMetaData cmd = sm.getClassMetaData();
                if (cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                if ((smsForTable = (HashSet<DNStateManager>)smsByTable.get(tableName = (table = sd.getTable()).getName())) == null) {
                    smsForTable = new HashSet<DNStateManager>();
                    smsByTable.put(tableName, smsForTable);
                }
                smsForTable.add(sm);
            }
            for (Map.Entry entry : smsByTable.entrySet()) {
                String tableName = (String)entry.getKey();
                Set smsForTable = (Set)entry.getValue();
                try {
                    long startTime = System.currentTimeMillis();
                    DBCollection collection = db.getCollection(tableName);
                    Object[] dbObjects = new DBObject[smsForTable.size()];
                    int i = 0;
                    for (DNStateManager sm : smsForTable) {
                        this.assertReadOnlyForUpdateOfObject(sm);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
                        }
                        dbObjects[i] = this.getDBObjectForStateManagerToInsert(sm, true);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersisted", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
                        }
                        ++i;
                    }
                    if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting objects using collection.insert(" + StringUtils.objectArrayToString((Object[])dbObjects) + ") into table " + tableName));
                    }
                    collection.insert((DBObject[])dbObjects, new WriteConcern(1));
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumWrites();
                        for (int j = 0; j < dbObjects.length; ++j) {
                            ec.getStatistics().incrementInsertCount();
                        }
                    }
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
                }
                catch (MongoException me) {
                    NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects", (Throwable)me);
                    throw new NucleusDataStoreException("Exception inserting objects", (Throwable)me);
                    return;
                }
            }
        }
        finally {
            mconn.release();
        }
    }

    public void insertObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            DBCollection collection = db.getCollection(table.getName());
            DBObject dbObject = this.getDBObjectForStateManagerToInsert(sm, !cmd.pkIsDatastoreAttributed(this.storeMgr));
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting object " + sm + " using collection.insert(" + dbObject + ") into table=" + table.getName()));
            collection.insert(dbObject, new WriteConcern(1));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
            }
            if (cmd.pkIsDatastoreAttributed(this.storeMgr)) {
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    ObjectId idKey = (ObjectId)dbObject.get("_id");
                    sm.setPostStoreNewObjectId((Object)idKey.toString());
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{sm.getObjectAsPrintable(), idKey}));
                    }
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        if (!this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) continue;
                        if (mmd.getType() != String.class) {
                            throw new NucleusUserException("Any field using IDENTITY value generation with MongoDB should be of type String");
                        }
                        ObjectId idKey = (ObjectId)dbObject.get("_id");
                        sm.replaceField(mmd.getAbsoluteFieldNumber(), (Object)idKey.toString());
                        sm.setPostStoreNewObjectId((Object)idKey);
                        if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{sm.getObjectAsPrintable(), idKey}));
                    }
                }
                StoreFieldManager fieldManager = new StoreFieldManager(sm, dbObject, true, table);
                int[] fieldNumbers = cmd.getRelationMemberPositions(ec.getClassLoaderResolver());
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    sm.provideFields(fieldNumbers, (FieldManager)fieldManager);
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Saving object " + sm + " as " + dbObject));
                    collection.save(dbObject);
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumWrites();
                    }
                }
            } else if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Insert.ObjectPersisted", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + sm), (Throwable)me);
            throw new NucleusDataStoreException("Exception inserting object for " + sm, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    private DBObject getDBObjectForStateManagerToInsert(DNStateManager sm, boolean includeRelationFields) {
        VersionMetaData vermd;
        Column softDeleteCol;
        String tenantId;
        Column multitenancyCol;
        BasicDBObject dbObject = new BasicDBObject();
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        ExecutionContext ec = sm.getExecutionContext();
        if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
            String fieldName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
            Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId());
            dbObject.put(fieldName, key);
        }
        if (cmd.hasDiscriminatorStrategy()) {
            dbObject.put(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName(), cmd.getDiscriminatorValue());
        }
        if ((multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY)) != null && (tenantId = ec.getTenantId()) != null) {
            dbObject.put(multitenancyCol.getName(), (Object)ec.getTenantId());
        }
        if ((softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE)) != null) {
            dbObject.put(softDeleteCol.getName(), (Object)Boolean.FALSE);
        }
        if ((vermd = cmd.getVersionMetaDataForClass()) != null) {
            Object versionValue = ec.getLockManager().getNextVersion(vermd, null);
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                Number verFieldValue = (long)((Long)versionValue);
                if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                    verFieldValue = ((Long)versionValue).intValue();
                }
                sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
            } else {
                String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                dbObject.put(fieldName, versionValue);
            }
            sm.setTransactionalVersion(versionValue);
        }
        StoreFieldManager fieldManager = new StoreFieldManager(sm, (DBObject)dbObject, true, table);
        int[] fieldNumbers = cmd.getAllMemberPositions();
        if (!includeRelationFields) {
            fieldNumbers = cmd.getNonRelationMemberPositions(ec.getClassLoaderResolver());
        }
        sm.provideFields(fieldNumbers, (FieldManager)fieldManager);
        return dbObject;
    }

    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Update.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId(), fieldStr.toString()}));
            }
            if ((dbObject = MongoDBUtils.getObjectForStateManager(collection = db.getCollection(table.getName()), sm, true, true)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + sm.getInternalObjectId() + " and version " + sm.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + sm.getInternalObjectId());
            }
            int[] updatedFieldNums = fieldNumbers;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd != null) {
                Object currentVersion = sm.getTransactionalVersion();
                Object nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                sm.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    sm.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                    dbObject.put(fieldName, nextVersion);
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(sm, dbObject, false, table);
            sm.provideFields(updatedFieldNums, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating object " + sm + " using collection.save(" + dbObject + ") into table=" + table.getName()));
            }
            collection.save(dbObject);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + sm), (Throwable)me);
            throw new NucleusDataStoreException("Exception updating object for " + sm, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(DNStateManager ... sms) {
        super.deleteObjects(sms);
    }

    public void deleteObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.Delete.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            if ((dbObject = MongoDBUtils.getObjectForStateManager(collection = db.getCollection(table.getName()), sm, true, false)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + sm.getInternalObjectId() + " and version " + sm.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + sm.getInternalObjectId());
            }
            sm.setAssociatedValue((Object)OP_DB_OBJECT, (Object)dbObject);
            sm.loadUnloadedFields();
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm, true));
            sm.removeAssociatedValue((Object)OP_DB_OBJECT);
            Column softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE);
            if (softDeleteCol != null) {
                String fieldName = softDeleteCol.getName();
                dbObject.put(fieldName, (Object)Boolean.TRUE);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating object " + sm + " using collection.save(" + dbObject + ") into table=" + table.getName()));
                }
                collection.save(dbObject);
            } else {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Removing object " + sm + " using collection.remove(" + dbObject + ") from table=" + table.getName()));
                }
                collection.remove(dbObject);
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + sm), (Throwable)me);
            throw new NucleusDataStoreException("Exception deleting object for " + sm, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(DNStateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DBCollection collection;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(sm.getObjectAsPrintable()).append("\" (id=");
                str.append(sm.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"MongoDB.Fetch.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            DBObject dbObject = (DBObject)sm.getAssociatedValue((Object)OP_DB_OBJECT);
            if (dbObject == null && (dbObject = MongoDBUtils.getObjectForStateManager(collection = db.getCollection(table.getName()), sm, false, false)) == null) {
                throw new NucleusObjectNotFoundException("Could not find object with id " + IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()));
            }
            HashSet<Integer> nonpersistableFields = null;
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                if (mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) continue;
                if (nonpersistableFields == null) {
                    nonpersistableFields = new HashSet<Integer>();
                }
                nonpersistableFields.add(fieldNumbers[i]);
            }
            if (nonpersistableFields != null) {
                for (Integer fieldNum : nonpersistableFields) {
                    sm.replaceField(fieldNum.intValue(), sm.provideField(fieldNum.intValue()));
                }
            }
            if (nonpersistableFields == null || nonpersistableFields.size() != fieldNumbers.length) {
                if (nonpersistableFields != null) {
                    int[] persistableFieldNums = new int[fieldNumbers.length - nonpersistableFields.size()];
                    int pos = 0;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (nonpersistableFields.contains(fieldNumbers[i])) continue;
                        persistableFieldNums[pos++] = fieldNumbers[i];
                    }
                    fieldNumbers = persistableFieldNums;
                }
                FetchFieldManager fieldManager = new FetchFieldManager(sm, dbObject, table);
                sm.replaceFields(fieldNumbers, (FieldManager)fieldManager);
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd != null && sm.getTransactionalVersion() == null) {
                    if (vermd.getFieldName() != null) {
                        Object datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                        sm.setVersion(datastoreVersion);
                    } else {
                        String fieldName = table.getSurrogateColumn(SurrogateColumnType.VERSION).getName();
                        Object datastoreVersion = dbObject.get(fieldName);
                        sm.setVersion(datastoreVersion);
                    }
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"MongoDB.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    public void locateObjects(DNStateManager[] sms) {
        super.locateObjects(sms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(DNStateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                Table table;
                DBCollection collection;
                DBObject dbObject;
                DB db = (DB)mconn.getConnection();
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    ((MongoDBStoreManager)this.storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                if ((dbObject = MongoDBUtils.getObjectForStateManager(collection = db.getCollection((table = sd.getTable()).getName()), sm, false, false)) == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

