/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public FetchEmbeddedFieldManager(ObjectProvider op, DBObject dbObject, List<AbstractMemberMetaData> mmds, Table table) {
        super(op, dbObject, table);
        this.ownerMmd = mmds != null ? mmds.get(mmds.size() - 1) : null;
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOps = this.ec.getOwnersForEmbeddedObjectProvider(this.op);
            return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
        }
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                boolean nested = MongoDBUtils.isMemberNested(mmd);
                DBObject subObject = this.dbObject;
                if (nested) {
                    subObject = (DBObject)this.dbObject.get(mapping.getColumn(0).getName());
                    if (subObject == null) {
                        return null;
                    }
                } else if (embmd != null) {
                    AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                    boolean isNull = true;
                    for (int i = 0; i < embmmds.length; ++i) {
                        String embFieldName = MongoDBUtils.getFieldName(this.ownerMmd, i);
                        if (!this.dbObject.containsField(embFieldName)) continue;
                        isNull = false;
                        break;
                    }
                    if (isNull) {
                        return null;
                    }
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
                embMmds.add(mmd);
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, subObject, embMmds, this.table);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported as embedded into the owning embedded object"));
            }
            return null;
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }
}

