/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query.expression;

import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Collection;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.mongodb.query.expression.MongoExpression;
import org.datanucleus.store.mongodb.query.expression.MongoFieldExpression;
import org.datanucleus.store.mongodb.query.expression.MongoLiteral;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;
import org.datanucleus.store.schema.table.MemberColumnMapping;

public class MongoBooleanExpression
extends MongoExpression {
    BasicDBObject dbObject = null;

    public MongoBooleanExpression(MongoFieldExpression fieldExpr, MongoLiteral lit, MongoOperator op) {
        String propName = fieldExpr.getPropertyName();
        ArrayList<Object> value = lit.getValue();
        MemberColumnMapping fieldMapping = fieldExpr.getMemberColumnMapping();
        if ((op == MongoOperator.OP_EQ || op == MongoOperator.OP_NOTEQ) && fieldMapping.getTypeConverter() != null) {
            value = fieldMapping.getTypeConverter().toDatastoreType((Object)value);
        } else if (value instanceof Enum) {
            value = this.asEnumValue(fieldExpr, (Enum)((Object)value));
        } else if (value instanceof Collection) {
            ArrayList<Object> collection = new ArrayList<Object>();
            for (Object obj : (Collection)value) {
                if (obj instanceof Enum) {
                    collection.add(this.asEnumValue(fieldExpr, (Enum)obj));
                    continue;
                }
                collection.add(obj);
            }
            value = collection;
        }
        if (op == MongoOperator.OP_EQ) {
            this.dbObject = new BasicDBObject(propName, (Object)value);
        } else if (op == MongoOperator.OP_NOTEQ || op == MongoOperator.OP_LT || op == MongoOperator.OP_LTEQ || op == MongoOperator.OP_GT || op == MongoOperator.OP_GTEQ || op == MongoOperator.REGEX || op == MongoOperator.IN) {
            BasicDBObject valObject = new BasicDBObject(op.getValue(), (Object)value);
            this.dbObject = new BasicDBObject(propName, (Object)valObject);
        } else {
            throw new NucleusException("Cannot create MongoBooleanExpression with operator of " + (Object)((Object)op) + " with this constructor");
        }
    }

    public MongoBooleanExpression(MongoBooleanExpression expr1, MongoBooleanExpression expr2, MongoOperator op) {
        if (op == MongoOperator.OP_AND) {
            BasicDBObject[] andOptions = new BasicDBObject[]{expr1.getDBObject(), expr2.getDBObject()};
            this.dbObject = new BasicDBObject(op.getValue(), (Object)andOptions);
        } else if (op == MongoOperator.OP_OR) {
            BasicDBObject[] orOptions = new BasicDBObject[]{expr1.getDBObject(), expr2.getDBObject()};
            this.dbObject = new BasicDBObject(op.getValue(), (Object)orOptions);
        } else {
            throw new NucleusException("Cannot create MongoBooleanExpression with operator of " + (Object)((Object)op) + " with this constructor");
        }
    }

    private Object asEnumValue(MongoFieldExpression fieldExpr, Enum<?> value) {
        AbstractMemberMetaData mmd = fieldExpr.getMemberMetaData();
        ColumnMetaData colmd = null;
        if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            colmd = mmd.getColumnMetaData()[0];
        }
        if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
            return value.ordinal();
        }
        return value.toString();
    }

    public BasicDBObject getDBObject() {
        return this.dbObject;
    }

    public String toString() {
        return this.dbObject.toString();
    }
}

