/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MongoDBSchemaHandler
extends AbstractStoreSchemaHandler {
    public MongoDBSchemaHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass(cmd, db);
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, DB db) {
        String collectionName = this.storeMgr.getNamingFactory().getTableName(cmd);
        DBCollection collection = null;
        if (this.isAutoCreateTables()) {
            if (cmd.hasExtension("mongodb.capped.size")) {
                Set collNames = db.getCollectionNames();
                if (!collNames.contains(collectionName)) {
                    BasicDBObject options = new BasicDBObject();
                    options.put("capped", (Object)"true");
                    Long size = Long.valueOf(cmd.getValueForExtension("mongodb.capped.size"));
                    options.put("size", (Object)size);
                    db.createCollection(collectionName, (DBObject)options);
                } else {
                    collection = db.getCollection(collectionName);
                }
            } else {
                collection = db.getCollection(collectionName);
            }
        }
        if (this.autoCreateConstraints) {
            BasicDBObject query;
            UniqueMetaData[] unimds;
            IndexMetaData[] idxmds;
            if (collection == null && !db.getCollectionNames().contains(collectionName)) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Cannot create constraints for " + cmd.getFullClassName() + " since collection of name " + collectionName + " doesn't exist (enable autoCreateTables?)"));
                return;
            }
            if (collection == null) {
                collection = db.getCollection(collectionName);
            }
            if ((idxmds = cmd.getIndexMetaData()) != null && idxmds.length > 0) {
                for (int i = 0; i < idxmds.length; ++i) {
                    DBObject idxObj = this.getDBObjectForIndex(cmd, idxmds[i]);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{idxmds[i].getName(), collectionName, idxObj}));
                    }
                    collection.ensureIndex(idxObj, idxmds[i].getName(), idxmds[i].isUnique());
                }
            }
            if ((unimds = cmd.getUniqueMetaData()) != null && unimds.length > 0) {
                for (int i = 0; i < unimds.length; ++i) {
                    DBObject uniObj = this.getDBObjectForUnique(cmd, unimds[i]);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{unimds[i].getName(), collectionName, uniObj}));
                    }
                    collection.ensureIndex(uniObj, unimds[i].getName(), true);
                }
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                query = new BasicDBObject();
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                boolean applyIndex = true;
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (this.storeMgr.isStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) {
                        applyIndex = false;
                        break;
                    }
                    query.append(this.storeMgr.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN), (Object)1);
                }
                if (applyIndex) {
                    String pkName;
                    String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{pkName, collectionName, query}));
                    }
                    collection.ensureIndex((DBObject)query, pkName, true);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                String pkName;
                query = new BasicDBObject();
                query.append(this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN), (Object)1);
                String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{pkName, collectionName, query}));
                }
                collection.ensureIndex((DBObject)query, pkName, true);
            }
            AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
            if (mmds != null && mmds.length > 0) {
                for (int i = 0; i < mmds.length; ++i) {
                    UniqueMetaData unimd;
                    String colName = this.storeMgr.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN);
                    IndexMetaData idxmd = mmds[i].getIndexMetaData();
                    if (idxmd != null) {
                        BasicDBObject query2 = new BasicDBObject();
                        query2.append(colName, (Object)1);
                        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{idxmd.getName(), collectionName, query2}));
                        }
                        collection.ensureIndex((DBObject)query2, idxmd.getName(), idxmd.isUnique());
                    }
                    if ((unimd = mmds[i].getUniqueMetaData()) == null) continue;
                    BasicDBObject query3 = new BasicDBObject();
                    query3.append(colName, (Object)1);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaCreate.Class.Index", (Object[])new Object[]{unimd.getName(), collectionName, query3}));
                    }
                    collection.ensureIndex((DBObject)query3, unimd.getName(), true);
                }
            }
        }
    }

    private DBObject getDBObjectForIndex(AbstractClassMetaData cmd, IndexMetaData idxmd) {
        BasicDBObject idxObj;
        block3: {
            block2: {
                idxObj = new BasicDBObject();
                if (idxmd.getNumberOfColumns() <= 0) break block2;
                String[] idxcolNames = idxmd.getColumnNames();
                for (int j = 0; j < idxcolNames.length; ++j) {
                    idxObj.append(idxcolNames[j], (Object)1);
                }
                break block3;
            }
            if (idxmd.getNumberOfMembers() <= 0) break block3;
            String[] idxMemberNames = idxmd.getMemberNames();
            for (int i = 0; i < idxMemberNames.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(idxMemberNames[i]);
                idxObj.append(this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), (Object)1);
            }
        }
        return idxObj;
    }

    private DBObject getDBObjectForUnique(AbstractClassMetaData cmd, UniqueMetaData unimd) {
        BasicDBObject uniObj;
        block3: {
            block2: {
                uniObj = new BasicDBObject();
                if (unimd.getNumberOfColumns() <= 0) break block2;
                String[] unicolNames = unimd.getColumnNames();
                for (int j = 0; j < unicolNames.length; ++j) {
                    uniObj.append(unicolNames[j], (Object)1);
                }
                break block3;
            }
            if (unimd.getMemberNames() == null) break block3;
            String[] uniMemberNames = unimd.getMemberNames();
            for (int i = 0; i < uniMemberNames.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(uniMemberNames[i]);
                uniObj.append(this.storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), (Object)1);
            }
        }
        return uniObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                DBCollection collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd));
                collection.dropIndexes();
                collection.drop();
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        boolean success = true;
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                AbstractMemberMetaData[] mmds;
                String msg;
                DBObject indexObj;
                UniqueMetaData[] unimds;
                String msg2;
                String className = classIter.next();
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                String tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
                if (!db.collectionExists(tableName)) {
                    success = false;
                    msg2 = "Table doesn't exist for " + cmd.getFullClassName() + " - should have name=" + tableName;
                    System.out.println(msg2);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg2);
                    continue;
                }
                msg2 = "Table for class=" + cmd.getFullClassName() + " with name=" + tableName + " validated";
                NucleusLogger.DATASTORE_SCHEMA.info((Object)msg2);
                DBCollection table = db.getCollection(tableName);
                ArrayList<DBObject> indices = new ArrayList<DBObject>(table.getIndexInfo());
                IndexMetaData[] idxmds = cmd.getIndexMetaData();
                if (idxmds != null && idxmds.length > 0) {
                    for (int i = 0; i < idxmds.length; ++i) {
                        String msg3;
                        DBObject idxObj = this.getDBObjectForIndex(cmd, idxmds[i]);
                        DBObject indexObj2 = this.getIndexObjectForIndex(indices, idxmds[i].getName(), idxObj, true);
                        if (indexObj2 != null) {
                            indices.remove(indexObj2);
                            msg3 = "Index for class=" + cmd.getFullClassName() + " with name=" + idxmds[i].getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg3);
                            continue;
                        }
                        success = false;
                        msg3 = "Index missing for class=" + cmd.getFullClassName() + " name=" + idxmds[i].getName() + " key=" + idxObj;
                        System.out.println(msg3);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg3);
                    }
                }
                if ((unimds = cmd.getUniqueMetaData()) != null && unimds.length > 0) {
                    for (int i = 0; i < unimds.length; ++i) {
                        DBObject uniObj = this.getDBObjectForUnique(cmd, unimds[i]);
                        indexObj = this.getIndexObjectForIndex(indices, unimds[i].getName(), uniObj, true);
                        if (indexObj != null) {
                            indices.remove(indexObj);
                            msg = "Unique index for class=" + cmd.getFullClassName() + " with name=" + unimds[i].getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                            continue;
                        }
                        success = false;
                        msg = "Unique index missing for class=" + cmd.getFullClassName() + " name=" + unimds[i].getName() + " key=" + uniObj;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    String msg4;
                    BasicDBObject query = new BasicDBObject();
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        query.append(this.storeMgr.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN), (Object)1);
                    }
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    DBObject indexObj3 = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj3 != null) {
                        indices.remove(indexObj3);
                        msg4 = "Index for application-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg4);
                    } else {
                        success = false;
                        msg4 = "Index missing for application id name=" + pkName + " key=" + query;
                        System.out.println(msg4);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg4);
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                    BasicDBObject query = new BasicDBObject();
                    query.append(this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN), (Object)1);
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    indexObj = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj != null) {
                        indices.remove(indexObj);
                        msg = "Index for datastore-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                    } else {
                        success = false;
                        msg = "Index missing for datastore id name=" + pkName + " key=" + query;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if ((mmds = cmd.getManagedMembers()) == null || mmds.length <= 0) continue;
                for (int i = 0; i < mmds.length; ++i) {
                    String msg5;
                    UniqueMetaData unimd;
                    IndexMetaData idxmd = mmds[i].getIndexMetaData();
                    if (idxmd != null) {
                        String msg6;
                        BasicDBObject query = new BasicDBObject();
                        query.append(this.storeMgr.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN), (Object)1);
                        DBObject indexObj4 = this.getIndexObjectForIndex(indices, idxmd.getName(), (DBObject)query, true);
                        if (indexObj4 != null) {
                            msg6 = "Index for field=" + mmds[i].getFullFieldName() + " with name=" + idxmd.getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg6);
                            indices.remove(indexObj4);
                        } else {
                            success = false;
                            msg6 = "Index missing for field=" + mmds[i].getFullFieldName() + " name=" + idxmd.getName() + " key=" + query;
                            System.out.println(msg6);
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg6);
                        }
                    }
                    if ((unimd = mmds[i].getUniqueMetaData()) == null) continue;
                    BasicDBObject query = new BasicDBObject();
                    query.append(this.storeMgr.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN), (Object)1);
                    DBObject indexObj5 = this.getIndexObjectForIndex(indices, unimd.getName(), (DBObject)query, true);
                    if (indexObj5 != null) {
                        msg5 = "Unique index for field=" + mmds[i].getFullFieldName() + " with name=" + unimd.getName() + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg5);
                        indices.remove(indexObj5);
                        continue;
                    }
                    success = false;
                    msg5 = "Unique index missing for field=" + mmds[i].getFullFieldName() + " name=" + unimd.getName() + " key=" + query;
                    System.out.println(msg5);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg5);
                }
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of MongoDB schema");
        }
    }

    private DBObject getIndexObjectForIndex(List<DBObject> indices, String idxName, DBObject idxObj, boolean unique) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        for (DBObject index : indices) {
            boolean flag;
            DBObject obj = null;
            String name = (String)index.get("name");
            if (!name.equals(idxName)) continue;
            obj = index;
            if (unique && !(flag = ((Boolean)index.get("unique")).booleanValue())) continue;
            boolean equal = true;
            DBObject key = (DBObject)index.get("key");
            if (key.toMap().size() != idxObj.toMap().size()) {
                equal = false;
            } else {
                for (String fieldKey : key.keySet()) {
                    Object fieldValue = key.get(fieldKey);
                    if (!idxObj.containsField(fieldKey)) {
                        equal = false;
                        continue;
                    }
                    Object idxObjValue = idxObj.get(fieldKey);
                    if (idxObjValue.equals(fieldValue)) continue;
                    equal = false;
                }
            }
            if (!equal) continue;
            return obj;
        }
        return null;
    }
}

