/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

public class LazyLoadQueryResult
extends AbstractQueryResult
implements Serializable {
    protected ExecutionContext ec;
    protected List<CandidateClassResult> candidateResults = new ArrayList<CandidateClassResult>();
    protected Iterator<DBObject> currentCursorIterator = null;
    protected Map<Integer, Object> itemsByIndex = null;
    boolean rangeProcessed = false;
    boolean orderProcessed = false;

    public LazyLoadQueryResult(Query q) {
        super(q);
        this.ec = q.getExecutionContext();
        String cacheType = this.query.getStringExtensionProperty("cacheType", "strong");
        this.itemsByIndex = cacheType != null ? (cacheType.equalsIgnoreCase("soft") ? new SoftValueMap() : (cacheType.equalsIgnoreCase("weak") ? new WeakValueMap() : (cacheType.equalsIgnoreCase("strong") ? new HashMap<Integer, Object>() : (cacheType.equalsIgnoreCase("none") ? null : new WeakValueMap())))) : new WeakValueMap();
    }

    public void addCandidateResult(AbstractClassMetaData cmd, DBCursor cursor, int[] fpMembers) {
        this.candidateResults.add(new CandidateClassResult(cmd, cursor, fpMembers));
    }

    public void setRangeProcessed(boolean processed) {
        this.rangeProcessed = processed;
    }

    public boolean getRangeProcessed() {
        return this.rangeProcessed;
    }

    public void setOrderProcessed(boolean processed) {
        this.orderProcessed = processed;
    }

    public boolean getOrderProcessed() {
        return this.orderProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen() && !this.candidateResults.isEmpty()) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            LazyLoadQueryResult lazyLoadQueryResult = this;
            synchronized (lazyLoadQueryResult) {
                if (this.currentCursorIterator != null) {
                    CandidateClassResult result = this.candidateResults.get(0);
                    while (this.currentCursorIterator.hasNext()) {
                        DBObject dbObject = this.currentCursorIterator.next();
                        Object pojo = MongoDBUtils.getPojoForDBObjectForCandidate(dbObject, this.ec, result.cmd, result.fpMembers, this.query.getIgnoreCache());
                        this.itemsByIndex.put(this.itemsByIndex.size(), pojo);
                    }
                    result.cursor.close();
                    this.candidateResults.remove(result);
                    this.currentCursorIterator = null;
                }
                Iterator<CandidateClassResult> candidateResultsIter = this.candidateResults.iterator();
                while (candidateResultsIter.hasNext()) {
                    CandidateClassResult result = candidateResultsIter.next();
                    for (DBObject dbObject : result.cursor) {
                        Object pojo = MongoDBUtils.getPojoForDBObjectForCandidate(dbObject, this.ec, result.cmd, result.fpMembers, this.query.getIgnoreCache());
                        this.itemsByIndex.put(this.itemsByIndex.size(), pojo);
                    }
                    result.cursor.close();
                    candidateResultsIter.remove();
                    this.currentCursorIterator = null;
                }
            }
        }
    }

    public synchronized void close() {
        this.itemsByIndex.clear();
        this.itemsByIndex = null;
        this.candidateResults = null;
        super.close();
    }

    protected void closeResults() {
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            do {
                this.getNextObject();
            } while (!this.candidateResults.isEmpty());
            this.size = this.itemsByIndex.size();
            return this.size;
        }
        return super.getSizeUsingMethod();
    }

    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be 0 or higher");
        }
        if (this.itemsByIndex != null && this.itemsByIndex.containsKey(index)) {
            return this.itemsByIndex.get(index);
        }
        do {
            Object nextPojo = this.getNextObject();
            if (this.itemsByIndex.size() != index + 1) continue;
            return nextPojo;
        } while (!this.candidateResults.isEmpty());
        throw new IndexOutOfBoundsException("Beyond size of the results (" + this.itemsByIndex.size() + ")");
    }

    protected Object getNextObject() {
        if (this.candidateResults.isEmpty()) {
            return null;
        }
        Object pojo = null;
        CandidateClassResult result = this.candidateResults.get(0);
        if (this.currentCursorIterator != null) {
            DBObject dbObject = this.currentCursorIterator.next();
            pojo = MongoDBUtils.getPojoForDBObjectForCandidate(dbObject, this.ec, result.cmd, result.fpMembers, this.query.getIgnoreCache());
            this.itemsByIndex.put(this.itemsByIndex.size(), pojo);
            if (!this.currentCursorIterator.hasNext()) {
                result.cursor.close();
                this.currentCursorIterator = null;
                this.candidateResults.remove(result);
            }
        } else {
            boolean noNextResult = true;
            while (noNextResult) {
                this.currentCursorIterator = result.cursor.iterator();
                if (this.currentCursorIterator.hasNext()) {
                    DBObject dbObject = this.currentCursorIterator.next();
                    pojo = MongoDBUtils.getPojoForDBObjectForCandidate(dbObject, this.ec, result.cmd, result.fpMembers, this.query.getIgnoreCache());
                    this.itemsByIndex.put(this.itemsByIndex.size(), pojo);
                    noNextResult = false;
                    if (this.currentCursorIterator.hasNext()) continue;
                    result.cursor.close();
                    this.currentCursorIterator = null;
                    this.candidateResults.remove(result);
                    continue;
                }
                result.cursor.close();
                this.currentCursorIterator = null;
                this.candidateResults.remove(result);
                if (this.candidateResults.isEmpty()) {
                    noNextResult = false;
                    pojo = null;
                    continue;
                }
                result = this.candidateResults.get(0);
            }
        }
        return pojo;
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LazyLoadQueryResult)) {
            return false;
        }
        LazyLoadQueryResult other = (LazyLoadQueryResult)o;
        if (this.candidateResults != null) {
            return other.candidateResults.equals(this.candidateResults);
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)other).equals(StringUtils.toJVMIDString((Object)this));
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.disconnect();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.itemsByIndex.size(); ++i) {
            list.add(this.itemsByIndex.get(i));
        }
        return list;
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int nextRowNum = 0;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            LazyLoadQueryResult lazyLoadQueryResult = LazyLoadQueryResult.this;
            synchronized (lazyLoadQueryResult) {
                if (!LazyLoadQueryResult.this.isOpen()) {
                    return false;
                }
                if (this.nextRowNum < LazyLoadQueryResult.this.itemsByIndex.size()) {
                    return true;
                }
                return !LazyLoadQueryResult.this.candidateResults.isEmpty();
            }
        }

        public Object next() {
            LazyLoadQueryResult lazyLoadQueryResult = LazyLoadQueryResult.this;
            synchronized (lazyLoadQueryResult) {
                if (!LazyLoadQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (this.nextRowNum < LazyLoadQueryResult.this.itemsByIndex.size()) {
                    Object pojo = LazyLoadQueryResult.this.itemsByIndex.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return pojo;
                }
                if (!LazyLoadQueryResult.this.candidateResults.isEmpty()) {
                    Object pojo = LazyLoadQueryResult.this.getNextObject();
                    ++this.nextRowNum;
                    return pojo;
                }
                throw new NoSuchElementException(LOCALISER.msg("052602"));
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private class CandidateClassResult {
        AbstractClassMetaData cmd;
        DBCursor cursor;
        int[] fpMembers;

        public CandidateClassResult(AbstractClassMetaData cmd, DBCursor curs, int[] fpMemberPositions) {
            this.cmd = cmd;
            this.cursor = curs;
            this.fpMembers = fpMemberPositions;
        }
    }
}

