/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    String dbName = "DataNucleus";
    Mongo mongo;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(7).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        try {
            ArrayList<ServerAddress> serverAddrs = new ArrayList<ServerAddress>();
            if (remains.length() == 0) {
                serverAddrs.add(new ServerAddress());
            } else {
                StringTokenizer tokeniser = new StringTokenizer(remains, ",");
                boolean firstServer = true;
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken();
                    String serverName = "localhost";
                    if (firstServer) {
                        int dbNameSepPos = token.indexOf("/");
                        if (dbNameSepPos >= 0) {
                            String dbNameStr;
                            if (dbNameSepPos < token.length() && (dbNameStr = token.substring(dbNameSepPos + 1)).length() > 0) {
                                this.dbName = dbNameStr;
                            }
                            if (dbNameSepPos > 0) {
                                serverName = token.substring(0, dbNameSepPos);
                            }
                        } else if (token.length() > 0) {
                            serverName = token;
                        }
                    } else {
                        serverName = token;
                    }
                    ServerAddress addr = null;
                    int portSeparatorPos = serverName.indexOf(58);
                    addr = portSeparatorPos > 0 ? new ServerAddress(serverName.substring(0, portSeparatorPos), Integer.valueOf(serverName.substring(portSeparatorPos + 1)).intValue()) : new ServerAddress(serverName);
                    serverAddrs.add(addr);
                    firstServer = false;
                }
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)LOCALISER.msg("MongoDB.ServerConnect", (Object)this.dbName, (Object)serverAddrs.size(), (Object)StringUtils.collectionToString(serverAddrs)));
            }
            this.mongo = serverAddrs.size() == 1 ? new Mongo((ServerAddress)serverAddrs.get(0), this.getMongodbOptions(storeMgr)) : new Mongo(serverAddrs, this.getMongodbOptions(storeMgr));
        }
        catch (UnknownHostException e) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)e);
        }
        catch (MongoException me) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)me);
        }
    }

    private MongoOptions getMongodbOptions(StoreManager storeManager) {
        Object connectionsPerHost = storeManager.getProperty("datanucleus.mongodb.connectionsPerHost");
        Object threadsAllowedToBlockForConnectionMultiplier = storeManager.getProperty("datanucleus.mongodb.threadsAllowedToBlockForConnectionMultiplier");
        MongoOptions mongoOptions = new MongoOptions();
        if (connectionsPerHost != null) {
            mongoOptions.connectionsPerHost = Integer.parseInt((String)connectionsPerHost);
        }
        if (threadsAllowedToBlockForConnectionMultiplier != null) {
            mongoOptions.threadsAllowedToBlockForConnectionMultiplier = Integer.parseInt((String)threadsAllowedToBlockForConnectionMultiplier);
        }
        return mongoOptions;
    }

    public void close() {
        this.mongo.close();
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map txnOptionsIgnored) {
        return new ManagedConnectionImpl();
    }

    static class EmulatedXAResource
    implements XAResource {
        ManagedConnectionImpl mconn;
        DB db;

        EmulatedXAResource(ManagedConnectionImpl mconn, DB db) {
            this.mconn = mconn;
            this.db = db;
        }

        public void start(Xid xid, int flags) throws XAException {
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with onePhase=" + onePhase));
            this.db.requestDone();
            this.mconn.startRequested = false;
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with onePhase=" + onePhase));
        }

        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            this.db.requestDone();
            this.mconn.startRequested = false;
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
        }

        public void end(Xid xid, int flags) throws XAException {
        }

        public void forget(Xid xid) throws XAException {
        }

        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int timeout) throws XAException {
            return false;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        boolean startRequested = false;
        XAResource xaRes = null;

        public boolean closeAfterTransactionEnd() {
            return false;
        }

        public Object getConnection() {
            if (this.conn == null || !this.startRequested) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                this.conn = ConnectionFactoryImpl.this.mongo.getDB(ConnectionFactoryImpl.this.dbName);
                String userName = ConnectionFactoryImpl.this.storeMgr.getConnectionUserName();
                String password = ConnectionFactoryImpl.this.storeMgr.getConnectionPassword();
                if (!StringUtils.isWhitespace((String)userName)) {
                    boolean authenticated = false;
                    if (!((DB)this.conn).isAuthenticated() && !(authenticated = ((DB)this.conn).authenticate(userName, password.toCharArray()))) {
                        throw new NucleusDataStoreException("Authentication of the connection failed for datastore " + ConnectionFactoryImpl.this.dbName + " with user " + userName);
                    }
                }
                if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore", false)) {
                    ((DB)this.conn).setReadOnly(Boolean.TRUE);
                }
            }
            if (!this.startRequested) {
                ((DB)this.conn).requestStart();
                this.startRequested = true;
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting"));
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing"));
                ((DB)this.conn).requestDone();
                this.startRequested = false;
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection"));
            }
            super.release();
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            if (this.startRequested) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing"));
                ((DB)this.conn).requestDone();
                this.startRequested = false;
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection"));
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this, (DB)this.conn);
            }
            return this.xaRes;
        }
    }
}

