/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.MongoDBResult;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.mongodb.query.expression.MongoExpression;
import org.datanucleus.store.mongodb.query.expression.MongoFieldExpression;
import org.datanucleus.store.mongodb.query.expression.MongoLiteral;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToMongoDBMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    MongoBooleanExpression filterExpr;
    BasicDBObject orderingObject;
    boolean resultComplete = true;
    MongoDBResult resultObject;
    boolean precompilable = true;
    Stack<MongoExpression> stack = new Stack();

    public QueryToMongoDBMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isResultComplete() {
        return this.resultComplete;
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public MongoBooleanExpression getFilterExpression() {
        return this.filterExpr;
    }

    public MongoDBResult getResultObject() {
        return this.resultObject;
    }

    public BasicDBObject getOrderingObject() {
        return this.orderingObject;
    }

    public void compile() {
        this.compileFrom();
        this.compileFilter();
        this.compileResult();
        this.compileGrouping();
        this.compileHaving();
        this.compileOrdering();
    }

    protected void compileFrom() {
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (int i = 0; i < fromExprs.length; ++i) {
            }
        }
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                MongoExpression mongoExpr = this.stack.pop();
                if (!(mongoExpr instanceof MongoBooleanExpression)) {
                    NucleusLogger.QUERY.error((Object)("Invalid compilation : filter compiled to " + mongoExpr));
                    this.filterComplete = false;
                } else {
                    this.filterExpr = (MongoBooleanExpression)mongoExpr;
                }
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprResult() != null) {
            Expression[] resultExprs;
            this.compileComponent = CompilationComponent.RESULT;
            this.resultObject = new MongoDBResult();
            for (Expression expr : resultExprs = this.compilation.getExprResult()) {
                if (!(expr instanceof InvokeExpression) || !"count".equalsIgnoreCase(((InvokeExpression)expr).getOperation()) || resultExprs.length != 1) continue;
                this.resultObject.setCountOnly(true);
            }
        }
        this.compileComponent = null;
    }

    protected void compileGrouping() {
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (int i = 0; i < groupExprs.length; ++i) {
            }
            this.compileComponent = null;
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            this.compilation.getExprHaving();
            this.compileComponent = null;
        }
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            this.orderingObject = new BasicDBObject();
            for (int i = 0; i < orderingExpr.length; ++i) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                MongoFieldExpression orderMongoExpr = (MongoFieldExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                String orderDir = orderExpr.getSortOrder();
                int direction = orderDir == null || orderDir.equals("ascending") ? 1 : -1;
                this.orderingObject.put(orderMongoExpr.getPropertyName(), (Object)direction);
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processOrExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_OR);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processGtExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processLtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processGteqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)right, (MongoLiteral)left, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression((MongoFieldExpression)left, (MongoLiteral)right, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        return super.processLteqExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            MongoFieldExpression fieldExpr = this.getFieldNameForPrimary(expr);
            if (fieldExpr == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                } else if (this.compileComponent == CompilationComponent.RESULT) {
                    this.resultComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameters != null && this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if (paramValueSet) {
            if (paramValue instanceof Number) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof String) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Character) {
                MongoLiteral lit = new MongoLiteral("" + paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Boolean) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Enum) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Time || paramValue instanceof Date) {
                Object storedVal = paramValue;
                Class<?> paramType = paramValue.getClass();
                if (paramValue instanceof SCO) {
                    paramType = ((SCO)paramValue).getValue().getClass();
                }
                TypeConverter strConv = this.ec.getTypeManager().getTypeConverterForType(paramType, String.class);
                TypeConverter longConv = this.ec.getTypeManager().getTypeConverterForType(paramType, Long.class);
                if (strConv != null) {
                    storedVal = strConv.toDatastoreType(paramValue);
                } else if (longConv != null) {
                    storedVal = longConv.toDatastoreType(paramValue);
                }
                MongoLiteral lit = new MongoLiteral(storedVal);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Calendar) {
                Object storedVal = MongoDBUtils.getStoredValueForField(this.ec, null, paramValue, 2);
                MongoLiteral lit = new MongoLiteral(storedVal);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof java.util.Date) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (this.ec.getApiAdapter().isPersistable(paramValue)) {
                MongoLiteral lit = new MongoLiteral(String.valueOf(this.ec.getApiAdapter().getIdForObject(paramValue)));
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue == null) {
                MongoLiteral lit = new MongoLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
        } else {
            this.precompilable = false;
            throw new NucleusException("Parameter " + expr + " is not currently set, so cannot complete the compilation");
        }
        NucleusLogger.QUERY.info((Object)("Dont currently support parameter values of type " + paramValue.getClass().getName()));
        return super.processParameterExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof BigDecimal) {
            MongoLiteral lit = new MongoLiteral(((BigDecimal)litValue).doubleValue());
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Number) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Boolean) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue == null) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        String operation = expr.getOperation();
        List args = expr.getArguments();
        if (invokedExpr == null) {
            // empty if block
        }
        NucleusLogger.QUERY.debug((Object)(">> Dont currently support any method invocation in MongoDB datastore queries : method=" + operation + " args=" + StringUtils.collectionToString((Collection)args)));
        return super.processInvokeExpression(expr);
    }

    protected MongoFieldExpression getFieldNameForPrimary(PrimaryExpression expr) {
        List tuples = expr.getTuples();
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        AbstractClassMetaData cmd = this.candidateCmd;
        AbstractMemberMetaData embMmd = null;
        boolean embeddedFlat = false;
        String embeddedNestedField = null;
        boolean firstTuple = true;
        Iterator iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (firstTuple && name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            if (relationType == RelationType.NONE) {
                if (iter.hasNext()) {
                    throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " yet " + name + " is a non-relation field!");
                }
                if (embMmd != null) {
                    if (embeddedFlat) {
                        return new MongoFieldExpression(MongoDBUtils.getFieldName(embMmd, mmd.getAbsoluteFieldNumber()), mmd);
                    }
                    return new MongoFieldExpression(embeddedNestedField + "." + this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), mmd);
                }
                return new MongoFieldExpression(this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), mmd);
            }
            boolean embedded = mmd.isEmbedded();
            if (!embedded) {
                AbstractMemberMetaData[] embmmds;
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                if (embmd == null && embMmd != null) {
                    embmd = embMmd.getEmbeddedMetaData();
                }
                if (embmd != null && (embmmds = embmd.getMemberMetaData()) != null) {
                    for (int i = 0; i < embmmds.length; ++i) {
                        if (!embmmds[i].getName().equals(mmd.getName())) continue;
                        embedded = true;
                        break;
                    }
                }
            }
            if (embedded) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    boolean nested = true;
                    String nestedStr = mmd.getValueForExtension("nested");
                    if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                        nested = false;
                    }
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
                    embMmd = mmd;
                    if (nested) {
                        embeddedNestedField = embeddedNestedField == null ? this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN) : embeddedNestedField + "." + this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                    } else if (!embeddedFlat) {
                        embeddedFlat = true;
                    }
                } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                    throw new NucleusUserException("Dont currently support querying of embedded collection fields at " + mmd.getFullFieldName());
                }
            } else {
                if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI || relationType == RelationType.MANY_TO_ONE_UNI || relationType == RelationType.MANY_TO_ONE_BI) {
                    if (mmd.getMappedBy() != null) {
                        throw new NucleusException("Querying of relationships from the non-owning side not currently supported (for name: " + name + " in " + StringUtils.collectionToString((Collection)tuples));
                    }
                    if (iter.hasNext()) {
                        throw new NucleusException("Querying of joined attributes not supported by data store (for name: " + name + " in " + StringUtils.collectionToString((Collection)tuples));
                    }
                    if (expr.getParent() != null && expr.getParent().getOperator() == Expression.OP_CAST) {
                        throw new NucleusException("Cast not supported (for name: " + name + " in " + StringUtils.collectionToString((Collection)tuples));
                    }
                    return new MongoFieldExpression(name, mmd);
                }
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                } else if (this.compileComponent == CompilationComponent.RESULT) {
                    this.resultComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this document, so unexecutable in the datastore"));
                return null;
            }
            firstTuple = false;
        }
        return null;
    }
}

