/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    private final AbstractMemberMetaData ownerMmd;

    public FetchEmbeddedFieldManager(ObjectProvider op, DBObject dbObject, AbstractMemberMetaData ownerMmd) {
        super(op, dbObject, null);
        this.ownerMmd = ownerMmd;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        RelationType relationType = embMmd.getRelationType(clr);
        if (RelationType.isRelationSingleValued((RelationType)relationType) && embMmd.isEmbedded()) {
            AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(embMmd.getType(), clr);
            if (embcmd == null) {
                throw new NucleusUserException("Field " + this.ownerMmd.getFullFieldName() + " marked as embedded but no such metadata");
            }
            if ((relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) && (this.ownerMmd.getMappedBy() != null && embMmd.getName().equals(this.ownerMmd.getMappedBy()) || embMmd.getMappedBy() != null && this.ownerMmd.getName().equals(embMmd.getMappedBy()))) {
                ObjectProvider[] ownerSms = this.op.getEmbeddedOwners();
                if (ownerSms == null) {
                    throw new NucleusException("Processing of " + embMmd.getFullFieldName() + " cannot set value to owner since owner ObjectProvider not set");
                }
                return ownerSms[0].getObject();
            }
            EmbeddedMetaData embmd = this.ownerMmd.getEmbeddedMetaData();
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            boolean isNull = true;
            for (int i = 0; i < embmmds.length; ++i) {
                String embFieldName = MongoDBUtils.getFieldName(this.ownerMmd, i);
                if (!this.dbObject.containsField(embFieldName)) continue;
                isNull = false;
                break;
            }
            if (isNull) {
                return null;
            }
            ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embcmd, this.op, fieldNumber);
            FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embOP, this.dbObject, embMmd);
            embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return embOP.getObject();
        }
        String fieldName = MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        if (embMmd.isSerialized()) {
            Object returnValue = MongoDBUtils.getFieldValueForJavaSerialisedField(embMmd, value);
            if (this.op != null) {
                returnValue = this.op.wrapSCOField(embMmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
            }
            return returnValue;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            return this.getValueForSingleRelationField(embMmd, value, clr);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            return this.getValueForContainerRelationField(embMmd, value, clr);
        }
        ColumnMetaData colmd = null;
        if (embMmd.getColumnMetaData() != null) {
            colmd = embMmd.getColumnMetaData()[0];
        }
        return this.getValueForContainerNonRelationField(embMmd, value, colmd);
    }
}

