/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.MongoDBCandidateList;
import org.datanucleus.store.mongodb.query.MongoDBQueryCompilation;
import org.datanucleus.store.mongodb.query.MongoDBResult;
import org.datanucleus.store.mongodb.query.QueryToMongoDBMapper;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    protected transient MongoDBQueryCompilation datastoreCompilation = null;

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(LOCALISER.msg("021009", (Object)this.candidateClassName));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        AbstractClassMetaData cmd = this.getCandidateClassMetaData();
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (MongoDBQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        MongoDBQueryCompilation mongoDBQueryCompilation = this.datastoreCompilation = new MongoDBQueryCompilation();
        synchronized (mongoDBQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    protected AbstractClassMetaData getCandidateClassMetaData() {
        String[] impls;
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        if (this.candidateClass.isInterface() && ((impls = this.ec.getMetaDataManager().getClassesImplementingInterface(this.candidateClass.getName(), this.clr)).length != 1 || !cmd.isImplementationOfPersistentDefinition()) && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.candidateClass, this.clr)) == null) {
            throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            boolean filterInMemory = true;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else {
                MongoDBResult resultObject;
                BasicDBObject filterObject = null;
                MongoBooleanExpression filterExpr = this.datastoreCompilation.getFilterExpression();
                if (filterExpr != null) {
                    filterObject = filterExpr.getDBObject();
                }
                if ((resultObject = this.datastoreCompilation.getResult()) != null && resultObject.isCountOnly() && this.datastoreCompilation.isFilterComplete() && this.grouping == null) {
                    List<Long> list = MongoDBUtils.performMongoCount(db, filterObject, this.candidateClass, this.subclasses, this.ec);
                    return list;
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (this.getBooleanExtensionProperty("slave-ok", false)) {
                    options.put("slave-ok", true);
                }
                candidates = this.ordering == null ? MongoDBUtils.getObjectsOfCandidateType(this.ec, db, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan(), filterObject, options, (int)this.fromInclNo - 1, (int)(this.toExclNo - this.fromInclNo)) : MongoDBUtils.getObjectsOfCandidateType(this.ec, db, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan(), filterObject, options);
                if (this.filter != null && this.datastoreCompilation.isFilterComplete()) {
                    filterInMemory = false;
                }
            }
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(filterInMemory, true, true, true, true);
            if (candidates instanceof MongoDBCandidateList) {
                ((MongoDBCandidateList)((Object)candidates)).close();
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        QueryToMongoDBMapper mapper = new QueryToMongoDBMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        this.datastoreCompilation.setFilterExpression(mapper.getFilterExpression());
        this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
        this.datastoreCompilation.setResult(mapper.getResultObject());
        this.datastoreCompilation.setPrecompilable(mapper.isPrecompilable());
        if (this.candidateCollection != null) {
            // empty if block
        }
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }
}

