/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    private final AbstractMemberMetaData ownerMmd;

    public StoreEmbeddedFieldManager(ObjectProvider sm, DBObject dbObject, AbstractMemberMetaData ownerMmd, boolean insert) {
        super(sm, dbObject, null, insert);
        this.ownerMmd = ownerMmd;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        if (!this.isStorable(embMmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = embMmd.getRelationType(clr);
        if (embMmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
            AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embMmd.getType(), clr);
            if (embcmd == null) {
                throw new NucleusUserException("Field " + embMmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + embMmd.getTypeName());
            }
            if (value == null) {
                return;
            }
            if ((relationType == 2 || relationType == 6) && (this.ownerMmd.getMappedBy() != null && embMmd.getName().equals(this.ownerMmd.getMappedBy()) || embMmd.getMappedBy() != null && this.ownerMmd.getName().equals(embMmd.getMappedBy()))) {
                return;
            }
            ObjectProvider embSM = ec.findObjectProviderForEmbedded(value, this.op, embMmd);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.dbObject, embMmd, this.insert);
            embSM.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        String fieldName = MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
        if (value == null) {
            if (this.dbObject.containsField(fieldName)) {
                this.dbObject.removeField(fieldName);
            }
            return;
        }
        if (embMmd.isSerialized()) {
            this.processSerialisedField(fieldName, value, this.dbObject);
        } else if (Relation.isRelationSingleValued((int)relationType)) {
            this.processSingleRelationField(value, ec, fieldName);
        } else if (Relation.isRelationMultiValued((int)relationType)) {
            this.processContainerRelationField(embMmd, value, ec, fieldName);
        } else {
            this.processContainerNonRelationField(fieldName, ec, value, this.dbObject);
        }
    }
}

