/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.types.ObjectStringConverter;

public class StoreFieldManager
extends AbstractFieldManager {
    private ObjectProvider sm;
    private DBObject dbObject;
    private AbstractClassMetaData acmd;

    public StoreFieldManager(ObjectProvider sm, DBObject dbObject, AbstractClassMetaData acmd) {
        this.sm = sm;
        this.dbObject = dbObject;
        this.acmd = acmd;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Boolean(value));
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Character(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Byte(value));
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Short(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Integer(value));
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Long(value));
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Float(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        this.dbObject.put(fieldName, (Object)new Double(value));
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        if (value == null) {
            this.dbObject.removeField(fieldName);
            return;
        }
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(mmd);
        if (value == null) {
            if (this.dbObject.containsField(fieldName)) {
                this.dbObject.removeField(fieldName);
            }
            return;
        }
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        if (relationType == 2 || relationType == 1 || relationType == 6 || relationType == 7) {
            Object valuePC = this.sm.getExecutionContext().persistObjectInternal(value, this.sm, fieldNumber, -1);
            Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
            this.dbObject.put(fieldName, valueId);
        } else if (relationType == 3 || relationType == 4 || relationType == 5) {
            if (mmd.hasCollection()) {
                ArrayList<Object> collIds = new ArrayList<Object>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.sm.getExecutionContext().persistObjectInternal(element, this.sm, fieldNumber, -1);
                    Object elementID = this.sm.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    collIds.add(elementID);
                }
                this.dbObject.put(fieldName, collIds);
            } else {
                if (mmd.hasMap()) {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        Object mapKey = entry.getKey();
                        Object mapValue = entry.getValue();
                        if (ec.getApiAdapter().isPersistable(mapKey)) {
                            ec.persistObjectInternal(mapKey, this.sm, fieldNumber, -1);
                        }
                        if (!ec.getApiAdapter().isPersistable(mapValue)) continue;
                        ec.persistObjectInternal(mapValue, this.sm, fieldNumber, -1);
                    }
                    throw new NucleusException("Dont currently support persistence of maps");
                }
                if (mmd.hasArray()) {
                    ArrayList<Object> arrIds = new ArrayList<Object>();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object element = Array.get(value, i);
                        Object elementPC = ec.persistObjectInternal(element, this.sm, fieldNumber, -1);
                        Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                        arrIds.add(elementID);
                    }
                    this.dbObject.put(fieldName, arrIds);
                }
            }
        } else {
            ObjectStringConverter strConv = ec.getNucleusContext().getTypeManager().getStringConverter(value.getClass());
            if (!mmd.isSerialized() && strConv != null) {
                String strValue = strConv.toString(value);
                this.dbObject.put(fieldName, (Object)strValue);
            } else {
                this.dbObject.put(fieldName, value);
            }
        }
    }
}

