/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;

public class MongoDBUtils {
    public static String getCollectionName(AbstractClassMetaData acmd) {
        if (acmd.getTable() != null) {
            return acmd.getTable();
        }
        return acmd.getName();
    }

    public static String getFieldName(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds != null && colmds.length > 1) {
            return colmds[0].getName();
        }
        return mmd.getName();
    }

    public static String getFieldName(IdentityMetaData idmd) {
        ColumnMetaData[] colmds = idmd.getColumnMetaData();
        if (colmds != null && colmds.length > 1) {
            return colmds[0].getName();
        }
        return "IDENTITY";
    }

    public static DBObject getObjectForObjectProvider(DBCollection dbCollection, ObjectProvider sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            BasicDBObject query = new BasicDBObject();
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = sm.provideField(pkPositions[i]);
                query.put(MongoDBUtils.getFieldName(pkMmd), value);
            }
            DBCursor curs = dbCollection.find((DBObject)query);
            if (!curs.hasNext()) {
                return null;
            }
            return curs.next();
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            BasicDBObject query = new BasicDBObject();
            OID oid = (OID)sm.getObjectId();
            Object value = oid.getKeyValue();
            query.put(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()), value);
            DBCursor curs = dbCollection.find((DBObject)query);
            if (!curs.hasNext()) {
                return null;
            }
            return curs.next();
        }
        return null;
    }

    public static List getObjectsOfCandidateType(final ExecutionContext ec, DB db, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fp) {
        ArrayList<Object> results;
        block3: {
            DBCursor curs;
            AbstractClassMetaData cmd;
            block2: {
                cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, ec.getClassLoaderResolver());
                BasicDBObject query = new BasicDBObject();
                DBCollection dbCollection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                curs = dbCollection.find((DBObject)query);
                results = new ArrayList<Object>();
                if (cmd.getIdentityType() != IdentityType.APPLICATION) break block2;
                while (curs.hasNext()) {
                    final DBObject dbObject = curs.next();
                    Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
                    results.add(ec.findObject(id, new FieldValues2(){

                        public void fetchFields(ObjectProvider sm) {
                            sm.replaceFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm) {
                            sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, ignoreCache));
                }
                break block3;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE) break block3;
            while (curs.hasNext()) {
                final DBObject dbObject = curs.next();
                Object idValue = dbObject.get(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()));
                OID oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idValue);
                results.add(ec.findObject((Object)oid, new FieldValues2(){

                    public void fetchFields(ObjectProvider sm) {
                        sm.replaceFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
                    }

                    public void fetchNonLoadedFields(ObjectProvider sm) {
                        sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, null, ignoreCache));
            }
        }
        return results;
    }
}

