/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    protected final MongoDBStoreManager storeMgr;

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MongoDBStoreManager)storeMgr;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(ObjectProvider sm) {
        AbstractClassMetaData cmd;
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (!this.storeMgr.managesClass(sm.getClassMetaData().getFullClassName())) {
            this.storeMgr.addClass(sm.getClassMetaData().getFullClassName(), sm.getExecutionContext().getClassLoaderResolver());
        }
        if ((cmd = sm.getClassMetaData()).getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("MongoDB.Insert.ObjectWithIdAlreadyExists", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
            BasicDBObject dbObject = new BasicDBObject();
            StoreFieldManager fieldManager = new StoreFieldManager(sm, (DBObject)dbObject, cmd);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
            collection.insert(new DBObject[]{dbObject});
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                String fieldName = MongoDBUtils.getFieldName(cmd.getIdentityMetaData());
                OID oid = (OID)sm.getInternalObjectId();
                Object key = oid.getKeyValue();
                dbObject.put(fieldName, key);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Update.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), sm)) == null) {
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            StoreFieldManager fieldManager = new StoreFieldManager(sm, dbObject, cmd);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
            collection.save(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData acmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Delete.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(acmd)), sm)) == null) {
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            collection.remove(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        AbstractClassMetaData acmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(sm.toPrintableID()).append("\" (id=");
                str.append(sm.getExecutionContext().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.PERSISTENCE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.Fetch.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(acmd)), sm)) == null) {
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            FetchFieldManager fieldManager = new FetchFieldManager(sm, dbObject, acmd);
            sm.replaceFields(fieldNumbers, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                DBObject dbObject = MongoDBUtils.getObjectForObjectProvider(collection, sm);
                if (dbObject == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

