/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.store.ldap.fieldmanager.MappingStrategyHelper;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.ldap.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LDAPPersistenceHandler
extends AbstractPersistenceHandler {
    public LDAPPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
            LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
            Object parentFieldValue = sm.provideField(parentFieldMmd.getAbsoluteFieldNumber());
            if (parentFieldValue != null) {
                sm.getExecutionContext().findStateManager(parentFieldValue, true);
            } else if (locationInfo.dn == null) {
                throw new NucleusUserException(Localiser.msg((String)"LDAP.Insert.MissingParentReference", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
        }
        if (cmd.getIdentityType() != IdentityType.APPLICATION && cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(Localiser.msg((String)"LDAP.DatastoreID"));
        }
        Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(sm.getClassMetaData());
        if (objectClasses == null) {
            throw new NucleusDataStoreException("Missing 'objectClass' extension or 'schema' attribute for class " + cmd.getName());
        }
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.Insert.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            List<AbstractMemberMetaData> nonEmbeddedMmds = LDAPUtils.getAllMemberMetaData(cmd);
            ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>();
            Iterator<AbstractMemberMetaData> it = nonEmbeddedMmds.iterator();
            while (it.hasNext()) {
                AbstractMemberMetaData mmd = it.next();
                if (!LDAPUtils.isEmbeddedField(mmd)) continue;
                embeddedMmds.add(mmd);
                it.remove();
            }
            int[] nonEmbeddedFieldNumbers = new int[nonEmbeddedMmds.size()];
            for (int i = 0; i < nonEmbeddedFieldNumbers.length; ++i) {
                nonEmbeddedFieldNumbers[i] = nonEmbeddedMmds.get(i).getAbsoluteFieldNumber();
            }
            int[] embeddedFieldNumbers = new int[embeddedMmds.size()];
            for (int i = 0; i < embeddedFieldNumbers.length; ++i) {
                embeddedFieldNumbers[i] = ((AbstractMemberMetaData)embeddedMmds.get(i)).getAbsoluteFieldNumber();
            }
            sm.provideFields(nonEmbeddedFieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, sm, attrs, true));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, false);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            for (String oc : objectClasses) {
                objectClass.add(oc);
            }
            attrs.put(objectClass);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.createSubcontext", (Object[])new Object[]{dn, attrs}));
            }
            ctx.bind(dn, null, (Attributes)attrs);
            attrs = new BasicAttributes();
            sm.provideFields(embeddedFieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, sm, attrs, true));
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{dn, "REPLACE", attrs}));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"LDAP.Insert.ObjectPersisted", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
        }
        catch (NameAlreadyBoundException e) {
            throw new NucleusUserException(Localiser.msg((String)"LDAP.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}), (Throwable)e);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.Update.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId(), fieldStr.toString()}));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
                LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
                AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                int absoluteFieldNumber = parentFieldMmd.getAbsoluteFieldNumber();
                for (int i : fieldNumbers) {
                    if (i != absoluteFieldNumber) continue;
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
                    sm.setAssociatedValue((Object)"dn", null);
                    LdapName newDn = null;
                    Object parentFieldValue = sm.provideField(absoluteFieldNumber);
                    if (parentFieldValue != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, false);
                    } else if (locationInfo.dn != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, false);
                    }
                    if (newDn == null || oldDn.equals(newDn)) break;
                    LDAPUtils.markForRename(this.storeMgr, sm.getObject(), ec, oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(sm.getObject(), ec);
                    break;
                }
            }
            BasicAttributes attrs = new BasicAttributes();
            sm.provideFields(fieldNumbers, (FieldManager)new StoreFieldManager(this.storeMgr, sm, attrs, false));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{dn, "REPLACE", attrs}));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        NucleusLogger.GENERAL.info((Object)(">> deleteObject for " + sm));
        sm.loadUnloadedFields();
        sm.provideFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
        this.deleteDnReferences(sm);
        this.deleteAttributeReferences(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        DirContext ctx = (DirContext)mconn.getConnection();
        long startTime = System.currentTimeMillis();
        try {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.Delete.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.destroySubcontext", (Object[])new Object[]{dn}));
            }
            ctx.unbind(dn);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
        }
        catch (ContextNotEmptyException cnee) {
            try {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.DeleteRecursive.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
                }
                LDAPUtils.deleteRecursive(LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true), ctx);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteDnReferences(DNStateManager sm) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = sm.getClassMetaData().getAllMemberPositions()) {
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByDnMetaData.isRelationByDn(mmd, sm.getExecutionContext().getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null) continue;
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getExecutionContext().getMetaDataManager());
            Class c = sm.getExecutionContext().getClassLoaderResolver().classForName(otherCmd.getFullClassName());
            if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            String name = elementMetaData.getColumnName() != null ? elementMetaData.getColumnName() : elementMetaData.getColumnMetaData()[0].getName();
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            this.deleteDnReference(otherCmd, name, sm, emptyValue);
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        MetaDataManager mdm = sm.getExecutionContext().getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = sm.getExecutionContext().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByDnMetaData.isRelationByDn(mmd, sm.getExecutionContext().getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getExecutionContext().getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? sm.getExecutionContext().getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != sm.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(sm.getClassMetaData().getFullClassName()))) continue;
                String name = LDAPUtils.getAttributeNameForField(mmd);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteDnReference(otherCmd, name, sm, emptyValue);
            }
        }
    }

    private void deleteDnReference(AbstractClassMetaData cmd, String name, DNStateManager sm, Object emptyValue) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
        ExecutionContext om = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getExecutionContext().getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + name + "=" + dn.toString() + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{name});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(name);
                if (attr == null || !(removed = attr.remove(dn.toString()))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.DeleteDnReference", (Object[])new Object[]{srName, dn}));
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{srName, "REPLACE", attrs}));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteAttributeReferences(DNStateManager sm) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = sm.getClassMetaData().getAllMemberPositions()) {
            RelationByAttributeMetaData mappingMetaData;
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, sm.getExecutionContext().getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null || (mappingMetaData = new RelationByAttributeMetaData(mmd, sm.getExecutionContext().getMetaDataManager())).getNonOwnerMMD() != mmd) continue;
            String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
            String joinAttributeName = mappingMetaData.getJoinAttributeName();
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, sm, joinAttributeName);
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getExecutionContext().getMetaDataManager());
            this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, sm, emptyValue);
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        MetaDataManager mdm = sm.getExecutionContext().getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = sm.getExecutionContext().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                RelationByAttributeMetaData mappingMetaData;
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, sm.getExecutionContext().getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getExecutionContext().getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? sm.getExecutionContext().getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != sm.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(sm.getClassMetaData().getFullClassName())) || (mappingMetaData = new RelationByAttributeMetaData(mmd, sm.getExecutionContext().getMetaDataManager())).getOwnerMMD() != mmd) continue;
                String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
                String joinAttributeName = mappingMetaData.getJoinAttributeName();
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, sm, joinAttributeName);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, sm, emptyValue);
            }
        }
    }

    private void deleteAttributeReference(AbstractClassMetaData cmd, String attributeName, Object attributeValue, DNStateManager sm, Object emptyValue) {
        ExecutionContext om = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getExecutionContext().getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + attributeName + "=" + attributeValue + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{attributeName});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(attributeName);
                if (attr == null || !(removed = attr.remove(attributeValue))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.DeleteAttributeReference", (Object[])new Object[]{attributeName, attributeValue, srName}));
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{srName, "REPLACE", attrs}));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(DNStateManager sm, int[] fieldNumbers) {
        if (sm.getLifecycleState().isDeleted()) {
            return;
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            StringBuilder str = new StringBuilder("Fetching object \"");
            str.append(sm.getObjectAsPrintable()).append("\" (id=");
            str.append(sm.getInternalObjectId()).append(")").append(" fields [");
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
        }
        ArrayList<String> attributeNameList = new ArrayList<String>();
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            RelationType relType = mmd.getRelationType(clr);
            if (relType == RelationType.NONE) {
                String attrName = LDAPUtils.getAttributeNameForField(mmd);
                attributeNameList.add(attrName);
                continue;
            }
            AbstractMappingStrategy ms = MappingStrategyHelper.findMappingStrategy(this.storeMgr, sm, mmd, new BasicAttributes());
            if (ms == null) continue;
            List<String> attributeNames = ms.getAttributeNames();
            attributeNameList.addAll(attributeNames);
        }
        String[] attributeNames = attributeNameList.toArray(new String[0]);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"LDAP.Fetch.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.getAttributes", (Object[])new Object[]{dn, attributeNameList, ""}));
            }
            Attributes result = ctx.getAttributes(dn, attributeNames);
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(this.storeMgr, sm, result));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
                ec.getStatistics().incrementFetchCount();
            }
        }
        catch (NameNotFoundException e) {
            throw new NucleusObjectNotFoundException("Object not found", sm.getInternalObjectId());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    public void locateObject(DNStateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                long startTime = System.currentTimeMillis();
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"LDAP.Locate.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
                }
                DirContext ctx = (DirContext)mconn.getConnection();
                LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)Localiser.msg((String)"LDAP.JNDI.getAttributes", (Object[])new Object[]{dn, "none", ""}));
                }
                ctx.getAttributes(dn, LDAPUtils.NO_ATTRIBUTES);
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"LDAP.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
                }
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumReads();
                }
                return;
            }
            catch (NameNotFoundException e) {
                throw new NucleusObjectNotFoundException("Object not found", sm.getInternalObjectId());
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(Localiser.msg((String)"LDAP.DatastoreID"));
        }
    }
}

