/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.HashSet;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.util.Localiser;

public class LDAPTransactionEventListener
implements TransactionEventListener {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    Set<Object> objectsToPersist = new HashSet<Object>();
    Set<Object> objectsToDelete = new HashSet<Object>();
    Set<Object> objectsNotToDelete = new HashSet<Object>();
    ExecutionContext ec;

    public LDAPTransactionEventListener(ExecutionContext ec) {
        this.ec = ec;
    }

    public void addObjectToDelete(Object pc) {
        if (!this.objectsNotToDelete.contains(pc)) {
            this.objectsToDelete.add(pc);
        }
    }

    public void removeObjectToDelete(Object pc) {
        this.objectsToDelete.remove(pc);
        this.objectsNotToDelete.add(pc);
    }

    public void addObjectToPersist(Object pc) {
        this.objectsToPersist.add(pc);
    }

    public void transactionStarted() {
    }

    public void transactionEnded() {
    }

    public void transactionPreFlush() {
    }

    public void transactionFlushed() {
    }

    public void transactionPreCommit() {
        while (!this.objectsToPersist.isEmpty()) {
            HashSet<Object> insert = new HashSet<Object>(this.objectsToPersist);
            for (Object pc : insert) {
                LDAPUtils.getObjectProviderForObject(pc, this.ec, true);
            }
            this.objectsToPersist.removeAll(insert);
        }
        this.ec.deleteObjects(this.objectsToDelete.toArray());
    }

    public void transactionCommitted() {
    }

    public void transactionPreRollBack() {
    }

    public void transactionRolledBack() {
    }
}

