/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationByHierarchyStrategy
extends AbstractMappingStrategy {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    protected int fieldNumber;
    protected ExecutionContext om;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected boolean isFieldHierarchicalMapped;
    protected boolean isFieldParentOfHierarchicalMapping;

    protected RelationByHierarchyStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.om = sm.getExecutionContext();
        this.storeMgr = storeMgr;
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getExecutionContext().getMetaDataManager());
        this.isFieldHierarchicalMapped = RelationByHierarchyStrategy.isChildOfHierarchicalMapping(mmd, sm.getExecutionContext().getMetaDataManager());
        this.isFieldParentOfHierarchicalMapping = RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mmd, sm.getExecutionContext().getMetaDataManager());
    }

    @Override
    public Object fetch() {
        if (this.isFieldHierarchicalMapped) {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    this.mmd.setDependent(true);
                    Object value = this.getHierarchicalMappedChild(this.mmd, this.op);
                    return value;
                }
                case 3: 
                case 4: {
                    if (!this.mmd.hasCollection()) break;
                    Collection<Object> coll = this.getHierarchicalMappedChildren(this.mmd.getCollection().getElementType(), this.mmd.getMappedBy(), this.mmd, this.op);
                    return this.op.wrapSCOField(this.fieldNumber, coll, false, false, true);
                }
            }
        }
        if (this.isFieldParentOfHierarchicalMapping) {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op, true);
            LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(this.op.getClassMetaData());
            LdapName parentDn = LDAPUtils.getParentDistingueshedName(dn, locationInfo.suffix);
            Object value = null;
            if (locationInfo.dn == null || !locationInfo.dn.equals(parentDn)) {
                value = LDAPUtils.getObjectByDN(this.storeMgr, this.om, this.type, parentDn.toString());
            }
            return value;
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Object getHierarchicalMappedChild(AbstractMemberMetaData mmd, ObjectProvider sm) {
        Collection<Object> coll = this.getHierarchicalMappedChildren(mmd.getTypeName(), mmd.getMappedBy(), null, sm);
        if (coll.iterator().hasNext()) {
            Object value = coll.iterator().next();
            return value;
        }
        return null;
    }

    private Collection<Object> getHierarchicalMappedChildren(String type, String mappedBy, AbstractMemberMetaData mmd, ObjectProvider sm) {
        Collection coll;
        Class collectionClass;
        if (mmd == null) {
            collectionClass = ArrayList.class;
        } else {
            collectionClass = mmd.getType();
            collectionClass = SCOUtils.getContainerInstanceType((Class)collectionClass, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        }
        try {
            coll = (Collection)collectionClass.newInstance();
            ExecutionContext om = sm.getExecutionContext();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            MetaDataManager metaDataMgr = sm.getExecutionContext().getMetaDataManager();
            AbstractClassMetaData childCmd = metaDataMgr.getMetaDataForClass(type, clr);
            LdapName base = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(this.storeMgr, om, childCmd, base, null, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    @Override
    public void insert(Object value) {
        block6: {
            block7: {
                if (value == null || this.isFieldParentOfHierarchicalMapping) break block6;
                if (!this.isFieldHierarchicalMapped) break block7;
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: {
                        LDAPUtils.markForPersisting(value, this.om);
                        break block6;
                    }
                    case 3: 
                    case 4: {
                        if (this.mmd.hasCollection()) {
                            Collection c = (Collection)value;
                            for (Object pc : c) {
                                LDAPUtils.markForPersisting(pc, this.om);
                            }
                        }
                        break block6;
                    }
                    default: {
                        throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                    }
                }
            }
            throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (this.isFieldParentOfHierarchicalMapping) {
            if (value != null) return;
            LDAPUtils.markForDeletion(this.op.getObject(), this.om);
            return;
        }
        if (!this.isFieldHierarchicalMapped) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
        if (value == null) return;
        String mappedBy = this.mmd.getMappedBy();
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: {
                ObjectProvider valueSM;
                ObjectProvider oldValueSM;
                Object oldValue = this.getHierarchicalMappedChild(this.mmd, this.op);
                if (oldValue != null && this.mustDelete(oldValueSM = LDAPUtils.getStateManagerForObject(oldValue, this.om, false))) {
                    LDAPUtils.markForDeletion(oldValue, this.om);
                }
                if ((valueSM = LDAPUtils.getStateManagerForObject(value, this.om, false)) != null) {
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, valueSM, true);
                    LdapName newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, valueSM);
                    LDAPUtils.markForRename(this.storeMgr, value, this.om, oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(value, this.om);
                }
            }
            case 2: {
                LDAPUtils.markForPersisting(value, this.om);
                LDAPUtils.unmarkForDeletion(value, this.om);
                return;
            }
            case 3: 
            case 4: {
                if (!this.mmd.hasCollection()) return;
                Collection coll = (Collection)value;
                Collection<Object> oldColl = this.getHierarchicalMappedChildren(this.mmd.getCollection().getElementType(), this.mmd.getMappedBy(), this.mmd, this.op);
                AbstractCollection toAdd = null;
                AbstractCollection toRemove = null;
                Class instanceType = this.mmd.getType();
                if (List.class.isAssignableFrom(instanceType)) {
                    toAdd = new ArrayList(coll);
                    toRemove = new ArrayList<Object>(oldColl);
                } else {
                    toAdd = new HashSet(coll);
                    toRemove = new HashSet<Object>(oldColl);
                }
                toAdd.removeAll(oldColl);
                for (Object pc : toAdd) {
                    LDAPUtils.markForPersisting(pc, this.om);
                    LDAPUtils.unmarkForDeletion(pc, this.om);
                }
                if (this.mmd.getRelationType(this.clr) == 3) {
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        ObjectProvider pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, false);
                        if (!this.mustDelete(pcSM)) continue;
                        LDAPUtils.markForDeletion(pc, this.om);
                    }
                    return;
                } else {
                    if (mappedBy == null) return;
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        ObjectProvider pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, false);
                        if (!this.mustDelete(pcSM, mappedBy)) continue;
                        LDAPUtils.markForDeletion(pc, this.om);
                    }
                }
                return;
            }
            default: {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
            }
        }
    }

    private boolean mustDelete(ObjectProvider pcSM) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op, true);
        LdapName pcDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, pcSM, true);
        boolean b = pcDn.startsWith(dn);
        return b;
    }

    private boolean mustDelete(ObjectProvider pcSM, String mappedBy) {
        try {
            Object pc = pcSM.getObject();
            Class<?> clazz = pc.getClass();
            String methodName = ClassUtils.getJavaBeanGetterName((String)mappedBy, (boolean)false);
            Method method = ClassUtils.getMethodForClass(clazz, (String)methodName, null);
            Object fieldPC = method.invoke(pc, new Object[0]);
            Object myPC = this.op.getObject();
            if (fieldPC == null || fieldPC == myPC) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isChildOfHierarchicalMapping(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData targetCmd;
        AbstractMemberMetaData mappedByMmd;
        String mappedBy = mmd.getMappedBy();
        if (mappedBy != null && (mappedByMmd = (targetCmd = LDAPUtils.getEffectiveClassMetaData(mmd, mmgr)).getMetaDataForMember(mappedBy)) != null) {
            boolean isMappedByParent = RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mappedByMmd, mmgr);
            return isMappedByParent;
        }
        return false;
    }

    public static boolean isParentOfHierarchicalMapping(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData cmd = mmd.getAbstractClassMetaData();
        LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        if (locationInfo.parentFieldName != null) {
            return mmd.getName().equals(locationInfo.parentFieldName);
        }
        return false;
    }

    @Override
    public List<String> getAttributeNames() {
        return Collections.EMPTY_LIST;
    }
}

