/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.EmbeddedMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByHierarchyStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleArrayMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleCollectionMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleMappingStrategy;
import org.datanucleus.store.types.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingStrategy {
    protected ObjectProvider sm;
    protected Attributes attributes;
    protected Attribute attr;
    protected AbstractMemberMetaData mmd;
    protected Class type;
    protected String name;

    protected AbstractMappingStrategy(ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        this.sm = sm;
        this.mmd = mmd;
        this.attributes = attributes;
        this.type = this.mmd.getType();
        this.name = LDAPUtils.getAttributeNameForField(this.mmd);
        this.attr = attributes.get(this.name);
    }

    public abstract void insert(Object var1);

    public abstract void update(Object var1);

    public abstract Object fetch();

    public abstract List<String> getAttributeNames();

    public static AbstractMappingStrategy findMappingStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        MetaDataManager mmgr = sm.getExecutionContext().getMetaDataManager();
        AbstractClassMetaData effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, mmgr);
        if (effectiveClassMetaData == null) {
            Class type = mmd.getType();
            boolean isArray = type.isArray();
            boolean isCollection = mmd.hasCollection();
            if (isArray) {
                type = type.getComponentType();
            } else if (isCollection) {
                type = sm.getExecutionContext().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            }
            if (type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || type.isEnum()) {
                if (isArray) {
                    return new SimpleArrayMappingStrategy(sm, mmd, attributes);
                }
                if (isCollection) {
                    return new SimpleCollectionMappingStrategy(sm, mmd, attributes);
                }
                return new SimpleMappingStrategy(sm, mmd, attributes);
            }
            TypeConverter converter = sm.getExecutionContext().getTypeManager().getTypeConverterForType(type, String.class);
            if (converter != null) {
                if (isArray) {
                    return new SimpleArrayMappingStrategy(sm, mmd, attributes);
                }
                if (isCollection) {
                    return new SimpleCollectionMappingStrategy(sm, mmd, attributes);
                }
                return new SimpleMappingStrategy(sm, mmd, attributes);
            }
            return null;
        }
        if (LDAPUtils.isEmbeddedField(mmd)) {
            return new EmbeddedMappingStrategy(storeMgr, sm, mmd, attributes);
        }
        boolean isRelationByAttribute = RelationByAttributeMetaData.isRelationByAttribute(mmd, mmgr);
        if (isRelationByAttribute) {
            return new RelationByAttributeStrategy(storeMgr, sm, mmd, attributes);
        }
        boolean isFieldHierarchicalMapped = RelationByHierarchyStrategy.isChildOfHierarchicalMapping(mmd, mmgr);
        boolean isFieldParentOfHierarchicalMapping = RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mmd, mmgr);
        if (isFieldHierarchicalMapped || isFieldParentOfHierarchicalMapping) {
            return new RelationByHierarchyStrategy(storeMgr, sm, mmd, attributes);
        }
        boolean isRelationByDn = RelationByDnMetaData.isRelationByDn(mmd, mmgr);
        if (isRelationByDn) {
            return new RelationByDnStrategy(storeMgr, sm, mmd, attributes);
        }
        return null;
    }
}

