/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.HashSet;
import java.util.Set;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.util.Localiser;

public class LDAPTransactionEventListener
implements TransactionEventListener {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    Set<Object> objectsToPersist = new HashSet<Object>();
    Set<Object> objectsToDelete = new HashSet<Object>();
    Set<Object> objectsNotToDelete = new HashSet<Object>();
    ExecutionContext om;

    public LDAPTransactionEventListener(ExecutionContext om) {
        this.om = om;
    }

    public void addObjectToDelete(Object pc) {
        if (!this.objectsNotToDelete.contains(pc)) {
            this.objectsToDelete.add(pc);
        }
    }

    public void removeObjectToDelete(Object pc) {
        this.objectsToDelete.remove(pc);
        this.objectsNotToDelete.add(pc);
    }

    public void addObjectToPersist(Object pc) {
        this.objectsToPersist.add(pc);
    }

    public void transactionCommitted() {
    }

    public void transactionEnded() {
    }

    public void transactionFlushed() {
    }

    public void transactionPreCommit() {
        while (!this.objectsToPersist.isEmpty()) {
            HashSet<Object> insert = new HashSet<Object>(this.objectsToPersist);
            for (Object pc : insert) {
                LDAPUtils.getStateManagerForObject(pc, this.om, true);
            }
            this.objectsToPersist.removeAll(insert);
        }
        for (Object pc : this.objectsToDelete) {
            ObjectProvider sm = LDAPUtils.getStateManagerForObject(pc, this.om, false);
            this.om.deleteObject(sm.getObject());
        }
    }

    public void transactionPreRollBack() {
    }

    public void transactionRolledBack() {
    }

    public void transactionStarted() {
    }
}

