/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationByDnStrategy
extends AbstractMappingStrategy {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    protected int fieldNumber;
    protected ObjectManager om;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected RelationByDnMetaData mappingMetaData;

    protected RelationByDnStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.om = sm.getObjectManager();
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
        this.mappingMetaData = new RelationByDnMetaData(mmd, sm.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    return RelationByDnStrategy.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.sm);
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.mmd.hasCollection()) break;
                    Collection<Object> coll = RelationByDnStrategy.getDnMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, this.sm);
                    return this.sm.wrapSCOField(this.fieldNumber, coll, false, false, true);
                }
            }
            throw new NucleusException(LOCALISER.msg("LDAP.Retrieve.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getRelationType(this.clr)));
        }
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: 
            case 2: 
            case 6: {
                try {
                    Object value = this.attr != null ? LDAPUtils.getObjectByDN(this.om, this.mmd.getType(), (String)this.attr.get(0)) : null;
                    return value;
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            case 3: 
            case 4: 
            case 5: {
                if (!this.mmd.hasCollection()) break;
                Collection coll = null;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                try {
                    coll = (Collection)instanceType.newInstance();
                    Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                    RelationByDnStrategy.removeEmptyValue(emptyValue, this.attr);
                    for (int i = 0; this.attr != null && i < this.attr.size(); ++i) {
                        String value = (String)this.attr.get(i);
                        coll.add(LDAPUtils.getObjectByDN(this.om, elementType, value));
                    }
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                }
                return this.sm.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
            }
        }
        throw new NucleusException(LOCALISER.msg("LDAP.Retrieve.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getRelationType(this.clr)));
    }

    @Override
    public void insert(Object value) {
        block11: {
            String emptyValue;
            String ownerAttributeName;
            block12: {
                if (value == null) break block11;
                ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
                emptyValue = this.mappingMetaData.getEmptyValue();
                if (this.mappingMetaData.getNonOwnerMMD() != this.mmd) break block12;
                LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: 
                    case 6: {
                        RelationByDnStrategy.addDnReference(value, ownerAttributeName, myDN, emptyValue, this.om);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (this.mmd.hasCollection()) {
                            Collection c = (Collection)value;
                            for (Object pc : c) {
                                LDAPUtils.unmarkForDeletion(pc, this.om);
                                RelationByDnStrategy.addDnReference(pc, ownerAttributeName, myDN, emptyValue, this.om);
                            }
                        }
                        break block11;
                    }
                    default: {
                        throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                    }
                }
                break block11;
            }
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    StateManager pcSM = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                    BasicAttribute attr = new BasicAttribute(ownerAttributeName, pcDN.toString());
                    RelationByDnStrategy.addEmptyValue(emptyValue, attr);
                    this.attributes.put(attr);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.mmd.hasCollection()) break;
                    Collection c = (Collection)value;
                    BasicAttribute attr = new BasicAttribute(this.name);
                    for (Object pc : c) {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                        attr.add(pcDN.toString());
                    }
                    RelationByDnStrategy.addEmptyValue(emptyValue, attr);
                    if (attr.size() <= 0) break;
                    this.attributes.put(attr);
                    break;
                }
                default: {
                    throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (value != null) {
            LDAPUtils.unmarkForDeletion(this.sm.getObject(), this.om);
        }
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
            if (value != null) {
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: 
                    case 6: {
                        Object oldValue = RelationByDnStrategy.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.sm);
                        if (value.equals(oldValue)) return;
                        LDAPUtils.markForPersisting(value, this.om);
                        LDAPUtils.unmarkForDeletion(value, this.om);
                        RelationByDnStrategy.removeDnReference(oldValue, ownerAttributeName, myDN, emptyValue, this.om);
                        RelationByDnStrategy.addDnReference(value, ownerAttributeName, myDN, emptyValue, this.om);
                        return;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!this.mmd.hasCollection()) return;
                        Collection coll = (Collection)value;
                        Collection<Object> oldColl = RelationByDnStrategy.getDnMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, this.sm);
                        if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.sm);
                        AbstractCollection toAdd = null;
                        AbstractCollection toRemove = null;
                        Class instanceType = this.mmd.getType();
                        if (List.class.isAssignableFrom(instanceType)) {
                            toAdd = new ArrayList(coll);
                            toRemove = new ArrayList<Object>(oldColl);
                        } else {
                            toAdd = new HashSet(coll);
                            toRemove = new HashSet<Object>(oldColl);
                        }
                        toAdd.removeAll(oldColl);
                        for (Object pc : toAdd) {
                            RelationByDnStrategy.addDnReference(pc, ownerAttributeName, myDN, emptyValue, this.om);
                            LDAPUtils.unmarkForDeletion(pc, this.om);
                        }
                        toRemove.removeAll(coll);
                        for (Object pc : toRemove) {
                            RelationByDnStrategy.removeDnReference(pc, ownerAttributeName, myDN, emptyValue, this.om);
                            if (!this.mmd.getCollection().isDependentElement()) continue;
                            LDAPUtils.markForDeletion(pc, this.om);
                        }
                        return;
                    }
                    default: {
                        throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                    }
                }
            }
            Object oldValue = RelationByDnStrategy.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.sm);
            RelationByDnStrategy.removeDnReference(oldValue, ownerAttributeName, myDN, emptyValue, this.om);
            return;
        }
        if (value != null) {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    StateManager smpc = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    LDAPUtils.unmarkForDeletion(value, this.om);
                    this.attributes.put(new BasicAttribute(ownerAttributeName, LDAPUtils.getDistinguishedNameForObject(smpc).toString()));
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.mmd.hasCollection()) return;
                    Collection coll = (Collection)value;
                    if (this.mmd.getCollection().isDependentElement()) {
                        Collection oldColl = null;
                        Class instanceType = this.mmd.getType();
                        instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                        Collection<Object> attributeValues = LDAPUtils.getAttributeValuesFromLDAP(this.sm, ownerAttributeName);
                        try {
                            oldColl = (Collection)instanceType.newInstance();
                            Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                            for (Object object : attributeValues) {
                                String oldDn = (String)object;
                                oldColl.add(LDAPUtils.getObjectByDN(this.om, elementType, oldDn));
                            }
                        }
                        catch (Exception e) {
                            throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                        }
                        if (oldColl != null) {
                            AbstractCollection toRemove = null;
                            toRemove = List.class.isAssignableFrom(instanceType) ? new ArrayList(oldColl) : new HashSet(oldColl);
                            toRemove.removeAll(coll);
                            for (Object pc : toRemove) {
                                LDAPUtils.markForDeletion(pc, this.om);
                            }
                        }
                    }
                    BasicAttribute attr = new BasicAttribute(ownerAttributeName);
                    this.attributes.put(attr);
                    for (Object pc : coll) {
                        LDAPUtils.unmarkForDeletion(pc, this.om);
                        StateManager smpc = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        attr.add(LDAPUtils.getDistinguishedNameForObject(smpc).toString());
                    }
                    RelationByDnStrategy.addEmptyValue(emptyValue, attr);
                    return;
                }
                default: {
                    throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                }
            }
        }
        BasicAttribute attr = new BasicAttribute(ownerAttributeName);
        RelationByDnStrategy.addEmptyValue(emptyValue, attr);
        this.attributes.put(attr);
    }

    private static Object getDnMappedReference(AbstractClassMetaData cmd, String pcAttributeName, StateManager sm) {
        Collection<Object> coll = RelationByDnStrategy.getDnMappedReferences(cmd, null, pcAttributeName, sm);
        if (coll.iterator().hasNext()) {
            Object value = coll.iterator().next();
            return value;
        }
        return null;
    }

    private static Collection<Object> getDnMappedReferences(AbstractClassMetaData cmd, AbstractMemberMetaData mmd, String pcAttributeName, StateManager sm) {
        Collection coll;
        Class collectionClass;
        if (mmd == null) {
            collectionClass = ArrayList.class;
        } else {
            collectionClass = mmd.getType();
            collectionClass = SCOUtils.getContainerInstanceType((Class)collectionClass, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        }
        try {
            coll = (Collection)collectionClass.newInstance();
            ObjectManager om = sm.getObjectManager();
            LdapName myDN = LDAPUtils.getDistinguishedNameForObject(sm);
            String dnFilter = "(" + pcAttributeName + "=" + myDN.toString() + ")";
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getMetaDataManager());
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(om, cmd, base, dnFilter, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    private static void removeDnReference(Object oldObject, String pcAttributeName, LdapName dn, String emptyValue, ObjectManager om) {
        if (oldObject != null) {
            StateManager oldPcSM = LDAPUtils.getStateManagerForObject(oldObject, om, true);
            LdapName oldPcDN = LDAPUtils.getDistinguishedNameForObject(oldPcSM);
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes pcAttributes = ctx.getAttributes(oldPcDN, new String[]{pcAttributeName});
                Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                if (pcAttribute != null && (removed = pcAttribute.remove(dn.toString()))) {
                    RelationByDnStrategy.addEmptyValue(emptyValue, pcAttribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.DeleteDnReference", (Object)oldPcDN, (Object)dn));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)oldPcDN, (Object)"REPLACE", (Object)pcAttributes));
                    }
                    ctx.modifyAttributes(oldPcDN, 2, pcAttributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addDnReference(Object newObject, String pcAttributeName, LdapName dn, String emptyValue, ObjectManager om) {
        if (newObject != null) {
            StateManager newPcSM = LDAPUtils.getStateManagerForObject(newObject, om, true);
            LdapName newPcDN = LDAPUtils.getDistinguishedNameForObject(newPcSM);
            if (newPcSM.isInserting()) {
                return;
            }
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(newPcDN, new String[]{pcAttributeName});
                Attribute attribute = attributes.get(pcAttributeName);
                if (attribute == null) {
                    attribute = new BasicAttribute(pcAttributeName);
                    attributes.put(attribute);
                }
                if (!attribute.contains(dn.toString())) {
                    attribute.add(dn.toString());
                    RelationByDnStrategy.removeEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.AddDnReference", (Object)newPcDN, (Object)dn));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)newPcDN, (Object)"REPLACE", (Object)attributes));
                    }
                    ctx.modifyAttributes(newPcDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                System.out.println(newPcSM);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addEmptyValue(String emptyValue, Attribute attr) {
        if (attr != null && attr.size() == 0 && emptyValue != null) {
            attr.add(emptyValue);
        }
    }

    private static void removeEmptyValue(String emptyValue, Attribute attr) {
        try {
            if (emptyValue != null && attr != null) {
                LdapName emptyDn = new LdapName(emptyValue);
                for (int i = 0; i < attr.size(); ++i) {
                    String value = (String)attr.get(i);
                    LdapName dn = new LdapName(value);
                    if (!emptyDn.equals(dn)) continue;
                    attr.remove(i);
                    --i;
                }
            }
        }
        catch (NamingException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.mappingMetaData.getNonOwnerMMD() != this.mmd) {
            names.add(this.mappingMetaData.getOwnerAttributeName());
        }
        return names;
    }
}

