/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    public JPQLQuery(ObjectManager om) {
        this(om, (JPQLQuery)null);
    }

    public JPQLQuery(ObjectManager om, JPQLQuery q) {
        super(om, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    protected Object performExecute(Map parameters) {
        boolean inMemory = this.evaluateInMemory();
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
        }
        List<Object> candidates = null;
        candidates = this.candidateCollection == null ? LDAPUtils.getObjectsOfCandidateType(this.om, this.compilation, parameters, this.candidateClass, this.subclasses, this.ignoreCache, inMemory) : new ArrayList(this.candidateCollection);
        JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.om.getClassLoaderResolver());
        Collection results = resultMapper.execute(true, true, true, true, true);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
        }
        if (this.type == 2) {
            for (Object obj : results) {
                this.om.deleteObject(obj);
            }
            return new Long(results.size());
        }
        if (this.type == 1) {
            throw new NucleusException("Bulk Update is not yet supported");
        }
        return results;
    }
}

