/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.transaction.xa.XAResource;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.ldap.LDAPUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        super(omfContext, resourceType);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om, transactionOptions);
    }

    public static class ManagedConnectionImpl
    extends AbstractManagedConnection {
        ObjectManager om;
        OMFContext omf;
        Map options;
        LdapContext mainContext;
        List<LdapContext> subContexts;

        public ManagedConnectionImpl(ObjectManager om, Map options) {
            this.om = om;
            this.omf = om.getOMFContext();
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.mainContext == null) {
                return;
            }
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPreClose();
            }
            try {
                try {
                    for (LdapContext subContext : this.subContexts) {
                        subContext.close();
                    }
                    this.mainContext.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.subContexts = null;
                this.mainContext = null;
                for (ManagedConnectionResourceListener listener : this.listeners) {
                    listener.managedConnectionPostClose();
                }
            }
        }

        public Object getConnection() {
            if (this.mainContext == null) {
                try {
                    PersistenceConfiguration conf = this.omf.getPersistenceConfiguration();
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", conf.getStringProperty("datanucleus.ConnectionDriverName"));
                    env.put("java.naming.provider.url", conf.getStringProperty("datanucleus.ConnectionURL"));
                    env.put("java.naming.security.principal", conf.getStringProperty("datanucleus.ConnectionUserName"));
                    env.put("java.naming.security.credentials", conf.getStringProperty("datanucleus.ConnectionPassword"));
                    if ("JNDI".equals(conf.getStringProperty("datanucleus.connectionPoolingType"))) {
                        int size;
                        env.put("com.sun.jndi.ldap.connect.pool", "true");
                        if (conf.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.maxsize", "" + size);
                        }
                        if (conf.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                            System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", "" + size);
                        }
                    }
                    MetaDataManager mdm = this.omf.getMetaDataManager();
                    Collection classesWithMetaData = mdm.getClassesWithMetaData();
                    StringBuilder sb = new StringBuilder();
                    for (String className : classesWithMetaData) {
                        AbstractClassMetaData cmd = mdm.getMetaDataForClass(className, this.om.getClassLoaderResolver());
                        List<AbstractMemberMetaData> mmds = LDAPUtils.getAllMemberMetaData(cmd);
                        for (AbstractMemberMetaData mmd : mmds) {
                            if (mmd.getJoinMetaData() != null || !mmd.getType().isArray()) continue;
                            String attributeNameForField = LDAPUtils.getAttributeNameForField(mmd);
                            sb.append(attributeNameForField).append(' ');
                        }
                    }
                    if (sb.length() > 0) {
                        env.put("java.naming.ldap.attributes.binary", sb.toString());
                    }
                    this.mainContext = new InitialLdapContext(env, null);
                    this.subContexts = new ArrayList<LdapContext>();
                }
                catch (NamingException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                LdapContext subContext = this.mainContext.newInstance(null);
                this.subContexts.add(subContext);
                return subContext;
            }
            catch (NamingException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

