/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPManager;
import org.datanucleus.store.ldap.LDAPTransactionEventListener;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPManager.class.getClassLoader());
    public static final String[] NO_ATTRIBUTES = new String[0];

    public static StateManager getStateManagerForObject(Object object, ObjectManager om, boolean persist) {
        StateManager smpc = om.findStateManager(object);
        if (smpc == null && persist) {
            int objectType = 0;
            Object object2 = om.persistObjectInternal(object, null, null, -1, objectType);
            smpc = om.findStateManager(object2);
        }
        return smpc;
    }

    public static AbstractClassMetaData getEffectiveClassMetaData(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData collectionFieldTypeCmd;
        ClassLoaderResolver clr = mmgr.getOMFContext().getClassLoaderResolver(null);
        AbstractClassMetaData fieldTypeCmd = mmgr.getMetaDataForClass(mmd.getType(), clr);
        if (fieldTypeCmd != null) {
            return fieldTypeCmd;
        }
        AbstractClassMetaData abstractClassMetaData = collectionFieldTypeCmd = mmd.getCollection() != null ? mmd.getCollection().getElementClassMetaData(clr) : null;
        if (collectionFieldTypeCmd != null) {
            return collectionFieldTypeCmd;
        }
        return null;
    }

    public static AbstractMemberMetaData getMemberMetadataForAttributeName(AbstractClassMetaData cmd, String attributeName) {
        if (cmd != null && attributeName != null) {
            List<AbstractMemberMetaData> allMemberMetaData = LDAPUtils.getAllMemberMetaData(cmd);
            for (AbstractMemberMetaData mmd : allMemberMetaData) {
                String attributeNameForField = LDAPUtils.getAttributeNameForField(mmd);
                if (!attributeName.equals(attributeNameForField)) continue;
                return mmd;
            }
        }
        return null;
    }

    public static List<AbstractMemberMetaData> getAllMemberMetaData(AbstractClassMetaData cmd) {
        int[] fieldNumbers = cmd.getAllMemberPositions();
        return LDAPUtils.getMemberMetaData(fieldNumbers, cmd);
    }

    public static List<AbstractMemberMetaData> getMemberMetaData(int[] fieldNumbers, AbstractClassMetaData cmd) {
        ArrayList<AbstractMemberMetaData> mmds = new ArrayList<AbstractMemberMetaData>();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            for (int fieldNumber : fieldNumbers) {
                mmds.add(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
            }
        }
        return mmds;
    }

    public static boolean isEmbeddedField(AbstractMemberMetaData mmd) {
        return mmd.getEmbeddedMetaData() != null || mmd.getCollection() != null && mmd.getCollection().isEmbeddedElement();
    }

    public static boolean isHierarchicalMappedAtChild(StateManager sm) {
        return LDAPUtils.getLocationInfo((AbstractClassMetaData)sm.getClassMetaData()).parentFieldName != null;
    }

    public static boolean isHierarchicalMapped(AbstractClassMetaData childCmd, AbstractClassMetaData potentialParentCmd, MetaDataManager mmgr) {
        return LDAPUtils.isParentOfHierarchicalMapping(potentialParentCmd, childCmd, mmgr);
    }

    public static boolean isParentOfHierarchicalMapping(AbstractClassMetaData potentialParentCmd, AbstractClassMetaData childCmd, MetaDataManager mmgr) {
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(childCmd);
        if (locationInfo.parentFieldName != null) {
            AbstractMemberMetaData parentFieldMmd = childCmd.getMetaDataForMember(locationInfo.parentFieldName);
            AbstractClassMetaData parentFieldTypeCmd = LDAPUtils.getEffectiveClassMetaData(parentFieldMmd, mmgr);
            return parentFieldTypeCmd == potentialParentCmd;
        }
        return false;
    }

    public static LdapName getParentDistingueshedName(LdapName dn, LdapName suffix) {
        LdapName parent = (LdapName)dn.getPrefix(dn.size() - suffix.size() - 1);
        return parent;
    }

    private static Rdn getRdnForObject(StateManager sm) throws InvalidNameException {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        int fieldNumber = cmd.getPKMemberPositions()[0];
        Object value = sm.provideField(fieldNumber);
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        BasicAttributes rdnAttributes = new BasicAttributes();
        AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(sm, mmd, rdnAttributes);
        ms.insert(value);
        Rdn rdn = new Rdn(rdnAttributes);
        return rdn;
    }

    public static LdapName getDistinguishedNameForObject(StateManager sm) {
        LdapName dn;
        block17: {
            if (sm.getAssociatedValue((Object)"dn") != null) {
                return (LdapName)((LdapName)sm.getAssociatedValue((Object)"dn")).clone();
            }
            AbstractClassMetaData cmd = sm.getClassMetaData();
            LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            try {
                SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
                if (sm.getEmbeddedOwners() != null && sm.getEmbeddedOwners().length > 0) {
                    StateManager owner = sm.getEmbeddedOwners()[0];
                    dn = LDAPUtils.getDistinguishedNameForObject(owner);
                    dn.add(LDAPUtils.getRdnForObject(sm));
                    break block17;
                }
                if (searchControls.getSearchScope() == 0) {
                    dn = locationInfo.dn;
                    break block17;
                }
                if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
                    LdapName parentDn;
                    Rdn rdn;
                    block18: {
                        rdn = LDAPUtils.getRdnForObject(sm);
                        AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                        Object parentFieldValue = sm.provideField(parentFieldMmd.getAbsoluteFieldNumber());
                        if (parentFieldValue != null) {
                            boolean detached;
                            ObjectManager om = sm.getObjectManager();
                            StateManager parentSm = LDAPUtils.getStateManagerForObject(parentFieldValue, om, detached = om.getApiAdapter().isDetached(parentFieldValue));
                            if (parentSm == null) {
                                throw new NucleusObjectNotFoundException("No state manager found for object " + parentFieldValue);
                            }
                            parentDn = LDAPUtils.getDistinguishedNameForObject(parentSm);
                        } else {
                            AbstractClassMetaData parentFieldTypeCmd = sm.getMetaDataManager().getMetaDataForClass(parentFieldMmd.getType(), sm.getObjectManager().getClassLoaderResolver());
                            LdapName base = LDAPUtils.getSearchBase(parentFieldTypeCmd, sm.getMetaDataManager());
                            String ocFilter = LDAPUtils.getSearchFilter(cmd);
                            String rdnFilter = "(" + rdn.getType() + "=" + rdn.getValue() + ")";
                            String filter = ocFilter != null ? "(&" + ocFilter + rdnFilter + ")" : rdnFilter;
                            ObjectManager om = sm.getObjectManager();
                            ManagedConnection mconn = om.getStoreManager().getConnection(om);
                            try {
                                NamingEnumeration<SearchResult> enumeration;
                                DirContext ctx = (DirContext)mconn.getConnection();
                                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.JNDI.search", (Object)base, (Object)filter, (Object)searchControls.getSearchScope()));
                                }
                                if ((enumeration = ctx.search((Name)base, filter, searchControls)).hasMoreElements()) {
                                    SearchResult sr = (SearchResult)enumeration.nextElement();
                                    String srName = sr.getNameInNamespace();
                                    LdapName srDn = new LdapName(srName);
                                    parentDn = LDAPUtils.getParentDistingueshedName(srDn, locationInfo.suffix);
                                    enumeration.close();
                                    break block18;
                                }
                                throw new NucleusObjectNotFoundException("No distinguished name found for object " + sm.toString());
                            }
                            catch (NamingException e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                mconn.release();
                            }
                        }
                    }
                    dn = LDAPUtils.composeDistinguishedName(parentDn, rdn, locationInfo.suffix);
                    break block17;
                }
                dn = new LdapName(locationInfo.dn.toString());
                dn.add(LDAPUtils.getRdnForObject(sm));
            }
            catch (InvalidNameException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (sm.getEmbeddedOwners() == null || sm.getEmbeddedOwners().length == 0) {
            sm.setAssociatedValue((Object)"dn", (Object)dn);
        }
        return dn;
    }

    public static LdapName getSearchBase(AbstractClassMetaData cmd, MetaDataManager mmgr) {
        LdapName dn;
        try {
            LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            if (locationInfo.parentFieldName != null) {
                AbstractMemberMetaData parentMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                ClassLoaderResolver clr = mmgr.getOMFContext().getClassLoaderResolver(null);
                AbstractClassMetaData parentFieldCmd = mmgr.getMetaDataForClass(parentMmd.getType(), clr);
                LdapName parentDn = LDAPUtils.getSearchBase(parentFieldCmd, mmgr);
                dn = LDAPUtils.composeDistinguishedName(parentDn, null, locationInfo.suffix);
            } else {
                dn = locationInfo.dn;
            }
        }
        catch (InvalidNameException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return dn;
    }

    public static SearchControls getSearchControls(AbstractClassMetaData cmd) {
        SearchControls searchControls = new SearchControls();
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        if (locationInfo.parentFieldName != null) {
            searchControls.setSearchScope(2);
        }
        if (locationInfo.scope != -1) {
            searchControls.setSearchScope(locationInfo.scope);
        }
        return searchControls;
    }

    public static String getSearchFilter(AbstractClassMetaData cmd) {
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        String urlFilter = locationInfo.filter;
        Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(cmd);
        if (objectClasses.isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer();
        if (objectClasses.size() > 1 || urlFilter != null) {
            filter.append("(&");
            for (String oc : objectClasses) {
                filter.append("(objectClass=");
                filter.append(oc);
                filter.append(")");
            }
            if (urlFilter != null) {
                filter.append(urlFilter);
            }
            filter.append(")");
        } else {
            filter.append("(objectClass=");
            filter.append(objectClasses.iterator().next());
            filter.append(")");
        }
        return filter.toString();
    }

    public static LocationInfo getLocationInfo(AbstractClassMetaData cmd) {
        String raw = null;
        if (cmd != null && cmd.hasExtension("dn")) {
            raw = cmd.getValueForExtension("dn");
        } else if (cmd != null && cmd.getTable() != null) {
            raw = cmd.getTable();
        }
        LocationInfo li = new LocationInfo();
        if (raw != null) {
            String dnOrParentField = null;
            if (raw.startsWith("ldap:///")) {
                String filter;
                String scope;
                String[] split = (raw = raw.substring("ldap:///".length())).split("\\?", 5);
                if (split.length > 0) {
                    dnOrParentField = split[0];
                }
                if (split.length > 1) {
                    // empty if block
                }
                if (split.length > 2 && (scope = split[2]).length() > 0) {
                    if ("base".equals(scope)) {
                        li.scope = 0;
                    } else if ("one".equals(scope)) {
                        li.scope = 1;
                    } else if ("sub".equals(scope)) {
                        li.scope = 2;
                    } else {
                        throw new NucleusDataStoreException("Invalid scope in LDAP URL: " + scope);
                    }
                }
                if (split.length > 3 && (filter = split[3]).length() > 0) {
                    li.filter = filter;
                }
            } else {
                dnOrParentField = raw;
            }
            if (dnOrParentField != null) {
                int left = dnOrParentField.indexOf(123);
                int right = dnOrParentField.indexOf(125);
                if (left > -1 && right > left) {
                    li.parentFieldName = dnOrParentField.substring(left + 1, right);
                    try {
                        String suffix = dnOrParentField.substring(0, left);
                        LdapName suffixDn = new LdapName(suffix);
                        if (suffixDn.size() > 0 && suffixDn.getRdn(0).size() == 0) {
                            suffixDn.remove(0);
                        }
                        li.suffix = suffixDn;
                    }
                    catch (InvalidNameException e) {
                        throw new NucleusDataStoreException("Invalid LDAP DN: " + dnOrParentField);
                    }
                }
                try {
                    li.dn = new LdapName(dnOrParentField);
                }
                catch (InvalidNameException e) {
                    throw new NucleusDataStoreException("Invalid LDAP DN: " + dnOrParentField);
                }
            }
        }
        return li;
    }

    public static String getEmptyValue(AbstractMemberMetaData mmd) {
        return mmd.getValueForExtension("empty-value");
    }

    public static Object getAttributeValue(StateManager sm, String attributeName) {
        try {
            AbstractMemberMetaData pcMmd = LDAPUtils.getMemberMetadataForAttributeName(sm.getClassMetaData(), attributeName);
            Object pcFieldValue = sm.provideField(pcMmd.getAbsoluteFieldNumber());
            BasicAttributes pcAttributes = new BasicAttributes();
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(sm, pcMmd, pcAttributes);
            ms.insert(pcFieldValue);
            Attribute pcAttribute = pcAttributes.get(attributeName);
            Object pcAttributeValue = pcAttribute.get();
            return pcAttributeValue;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getAttributeNameForField(AbstractMemberMetaData mmd) {
        String name = mmd.getName();
        if (mmd.hasExtension("dn")) {
            name = mmd.getValueForExtension("dn");
        } else if (mmd.hasExtension("attribute")) {
            name = mmd.getValueForExtension("attribute");
        } else if (mmd.getColumn() != null) {
            name = mmd.getColumn();
        } else if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            name = mmd.getColumnMetaData()[0].getName();
        }
        return name;
    }

    public static Set<String> getObjectClassesForClass(AbstractClassMetaData cmd) {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        if (cmd.hasExtension("objectClass")) {
            ocs.addAll(Arrays.asList(cmd.getValuesForExtension("objectClass")));
        } else if (cmd.getSchema() != null) {
            ocs.addAll(Arrays.asList(MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(cmd.getSchema())));
        }
        return ocs;
    }

    public static LdapName composeDistinguishedName(LdapName parentDn, Rdn rdn, LdapName suffix) throws InvalidNameException {
        LdapName dn = new LdapName(parentDn.getRdns());
        dn.addAll(suffix.getRdns());
        if (rdn != null) {
            dn.add(rdn);
        }
        return dn;
    }

    public static Object getObjectByDN(ObjectManager om, Class type, String dnAsString) {
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(type, om.getClassLoaderResolver());
        LdapName base = LDAPUtils.getSearchBase(cmd, cmd.getMetaDataManager());
        try {
            LdapName dn = new LdapName(dnAsString);
            Rdn rdn = dn.getRdn(dn.size() - 1);
            String filter = "(" + rdn.getType() + "=" + rdn.getValue() + ")";
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(om, cmd, base, filter, true, false);
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() == 0) {
                throw new NucleusObjectNotFoundException("No object found with type " + type + " and filter " + filter);
            }
            throw new NucleusDataStoreException("Unambiguous match with type " + type + " and filter " + filter);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getObjectByAttribute(ObjectManager om, Class type, String attributeName, String attributeValue, MetaDataManager mmgr) {
        LdapName base;
        String attributeFilter = "(" + attributeName + "=" + attributeValue + ")";
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(type, om.getClassLoaderResolver());
        List<Object> objects = LDAPUtils.getObjectsOfCandidateType(om, cmd, base = LDAPUtils.getSearchBase(cmd, mmgr), attributeFilter, true, false);
        if (objects.size() == 1) {
            return objects.get(0);
        }
        if (objects.size() == 0) {
            throw new NucleusObjectNotFoundException("No object found with type " + type + " and filter " + attributeFilter);
        }
        throw new NucleusDataStoreException("Unambiguous match with type " + type + " and filter " + attributeFilter);
    }

    public static void markForPersisting(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToPersist(pc);
    }

    public static void markForRename(Object pc, ObjectManager om, LdapName oldDn, LdapName newDn) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToRename(pc, oldDn, newDn);
    }

    public static void markForDeletion(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.addObjectToDelete(pc);
    }

    public static void unmarkForDeletion(Object pc, ObjectManager om) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(om);
        listener.removeObjectToDelete(pc);
    }

    private static LDAPTransactionEventListener getTransactionEventListener(ObjectManager om) {
        Transaction transaction = om.getTransaction();
        LDAPTransactionEventListener listener = (LDAPTransactionEventListener)transaction.getOptions().get("LDAPTransactionEventListener");
        if (listener == null) {
            listener = new LDAPTransactionEventListener(om);
            transaction.getOptions().put("LDAPTransactionEventListener", listener);
            transaction.addTransactionEventListener((TransactionEventListener)listener);
        }
        return listener;
    }

    public static List<Object> getObjectsOfCandidateType(ObjectManager om, QueryCompilation compilation, Map parameters, Class candidateClass, boolean subclasses, boolean ignoreCache, boolean inMemory) {
        String[] subclassNames;
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List<Object> results = LDAPUtils.getObjectsOfCandidateType(om, compilation, parameters, cmd, ignoreCache, inMemory);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData subCmd = om.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(om, compilation, parameters, subCmd, ignoreCache, inMemory));
            }
        }
        return results;
    }

    private static List<Object> getObjectsOfCandidateType(ObjectManager om, QueryCompilation compilation, Map parameters, AbstractClassMetaData acmd, boolean ignoreCache, boolean inMemory) {
        List<Object> results = new ArrayList<Object>();
        String classFilter = LDAPUtils.getSearchFilter(acmd);
        if (classFilter != null) {
            if (!inMemory) {
                try {
                    String className = "org.datanucleus.store.ldap.query.QueryToLDAPFilterMapper";
                    Class cls = om.getClassLoaderResolver().classForName(className);
                    Method method = ClassUtils.getMethodForClass((Class)cls, (String)"compile", null);
                    Constructor constr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[]{QueryCompilation.class, Map.class, AbstractClassMetaData.class});
                    String filter = (String)method.invoke(constr.newInstance(compilation, parameters, acmd), (Object[])null);
                    results = LDAPUtils.getObjectsOfCandidateType(om, acmd, null, filter, ignoreCache);
                }
                catch (Throwable e) {
                    NucleusLogger.QUERY.warn((Object)LOCALISER.msg("LDAP.Query.NativeQueryFailed"));
                    inMemory = true;
                }
            }
            if (inMemory) {
                results = LDAPUtils.getObjectsOfCandidateType(om, acmd, null, classFilter, ignoreCache);
            }
        }
        return results;
    }

    public static List<Object> getObjectsOfCandidateType(ObjectManager om, AbstractClassMetaData candidateCmd, LdapName base, String additionalFilter, boolean subclasses, boolean ignoreCache) {
        String[] subclassNames;
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        List<Object> results = LDAPUtils.getObjectsOfCandidateType(om, candidateCmd, base, additionalFilter, ignoreCache);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateCmd.getFullClassName(), true)) != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData subCmd = om.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(om, subCmd, base, additionalFilter, ignoreCache));
            }
        }
        return results;
    }

    private static List<Object> getObjectsOfCandidateType(ObjectManager om, final AbstractClassMetaData cmd, LdapName base, String additionalFilter, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        final ClassLoaderResolver clr = om.getClassLoaderResolver();
        Map<LdapName, Attributes> entries = LDAPUtils.getEntries(om, cmd, base, additionalFilter, false, ignoreCache);
        for (final Attributes attrs : entries.values()) {
            results.add(om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

                public void fetchFields(StateManager sm) {
                    sm.replaceFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                    sm.replaceFields(cmd.getBasicMemberPositions(clr), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    sm.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            }, ignoreCache, true));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<LdapName, Attributes> getEntries(ObjectManager om, AbstractClassMetaData candidateCmd, LdapName base, String additionalFilter, boolean subclasses, boolean ignoreCache) {
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        try {
            String[] subclassNames;
            DirContext ctx = (DirContext)mconn.getConnection();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            Map<LdapName, Attributes> results = LDAPUtils.getEntries(om, candidateCmd, ctx, base, additionalFilter, ignoreCache);
            if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateCmd.getFullClassName(), true)) != null) {
                for (String subclassName : subclassNames) {
                    AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                    results.putAll(LDAPUtils.getEntries(om, cmd, ctx, base, additionalFilter, ignoreCache));
                }
            }
            Map<LdapName, Attributes> map = results;
            return map;
        }
        finally {
            mconn.release();
        }
    }

    private static Map<LdapName, Attributes> getEntries(ObjectManager om, AbstractClassMetaData acmd, DirContext ctx, LdapName base, String additionalFilter, boolean ignoreCache) {
        LinkedHashMap<LdapName, Attributes> results = new LinkedHashMap<LdapName, Attributes>();
        Class c = om.getClassLoaderResolver().classForName(acmd.getFullClassName());
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            return results;
        }
        try {
            if (base == null) {
                base = LDAPUtils.getSearchBase(acmd, om.getMetaDataManager());
            }
            String filter = LDAPUtils.getSearchFilter(acmd);
            if (additionalFilter != null) {
                filter = "(&" + filter + additionalFilter + ")";
            }
            SearchControls searchControls = LDAPUtils.getSearchControls(acmd);
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.JNDI.search", (Object)base, (Object)filter, (Object)searchControls.getSearchScope()));
            }
            NamingEnumeration<SearchResult> enumeration = ctx.search(base.toString(), filter, searchControls);
            while (enumeration.hasMoreElements()) {
                SearchResult sr = (SearchResult)enumeration.nextElement();
                Attributes attrs = sr.getAttributes();
                String name = sr.getNameInNamespace();
                LdapName dn = new LdapName(name);
                if (searchControls.getSearchScope() == 2 && dn.equals(base)) continue;
                results.put(dn, attrs);
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
        }
        return results;
    }

    public static class LocationInfo {
        public LdapName dn = null;
        public String parentFieldName = null;
        public LdapName suffix = null;
        public String filter = null;
        public int scope = -1;
    }
}

