/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;

public class SimpleArrayMappingStrategy
extends AbstractMappingStrategy {
    public SimpleArrayMappingStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.type = this.type.getComponentType();
    }

    public Object fetch() {
        if (this.attr == null) {
            return null;
        }
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            return this.fetchBooleanArrayField();
        }
        if (Byte.TYPE.isAssignableFrom(this.type)) {
            return this.fetchByteArrayField();
        }
        if (Character.TYPE.isAssignableFrom(this.type)) {
            return this.fetchCharArrayField();
        }
        if (Double.TYPE.isAssignableFrom(this.type)) {
            return this.fetchDoubleArrayField();
        }
        if (Float.TYPE.isAssignableFrom(this.type)) {
            return this.fetchFloatArrayField();
        }
        if (Integer.TYPE.isAssignableFrom(this.type)) {
            return this.fetchIntArrayField();
        }
        if (Long.TYPE.isAssignableFrom(this.type)) {
            return this.fetchLongArrayField();
        }
        if (Short.TYPE.isAssignableFrom(this.type)) {
            return this.fetchShortArrayField();
        }
        if (String.class.isAssignableFrom(this.type)) {
            return this.fetchStringArrayField();
        }
        if (Boolean.class.isAssignableFrom(this.type)) {
            return this.fetchBooleanObjectArrayField();
        }
        if (Byte.class.isAssignableFrom(this.type)) {
            return this.fetchByteObjectArrayField();
        }
        if (Character.class.isAssignableFrom(this.type)) {
            return this.fetchCharacterObjectArrayField();
        }
        if (Double.class.isAssignableFrom(this.type)) {
            return this.fetchDoubleObjectArrayField();
        }
        if (Float.class.isAssignableFrom(this.type)) {
            return this.fetchFloatObjectArrayField();
        }
        if (Integer.class.isAssignableFrom(this.type)) {
            return this.fetchIntegerObjectArrayField();
        }
        if (Long.class.isAssignableFrom(this.type)) {
            return this.fetchLongObjectArrayField();
        }
        if (Short.class.isAssignableFrom(this.type)) {
            return this.fetchShortObjectArrayField();
        }
        CalendarToGeneralizedTimeStringConverter converter = null;
        converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(this.type));
        if (converter != null) {
            String[] stringValues = this.fetchStringArrayField();
            Object[] values = (Object[])Array.newInstance(this.type, stringValues.length);
            for (int i = 0; i < stringValues.length; ++i) {
                values[i] = converter.toObject(stringValues[i]);
            }
            return values;
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    protected boolean[] fetchBooleanArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        boolean[] values = new boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Boolean(stringValues[i]);
        }
        return values;
    }

    protected Boolean[] fetchBooleanObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Boolean[] values = new Boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Boolean(stringValues[i]);
        }
        return values;
    }

    protected byte[] fetchByteArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        byte[] values = new byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Byte(stringValues[i]);
        }
        return values;
    }

    protected Byte[] fetchByteObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Byte[] values = new Byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Byte(stringValues[i]);
        }
        return values;
    }

    protected char[] fetchCharArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        char[] values = new char[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = stringValues[i].charAt(0);
        }
        return values;
    }

    protected Character[] fetchCharacterObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Character[] values = new Character[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Character(stringValues[i].charAt(0));
        }
        return values;
    }

    protected double[] fetchDoubleArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        double[] values = new double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Double(stringValues[i]);
        }
        return values;
    }

    protected Double[] fetchDoubleObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Double[] values = new Double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Double(stringValues[i]);
        }
        return values;
    }

    protected float[] fetchFloatArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        float[] values = new float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Float(stringValues[i]).floatValue();
        }
        return values;
    }

    protected Float[] fetchFloatObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Float[] values = new Float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Float(stringValues[i]);
        }
        return values;
    }

    protected int[] fetchIntArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        int[] values = new int[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Integer(stringValues[i]);
        }
        return values;
    }

    protected Integer[] fetchIntegerObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Integer[] values = new Integer[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Integer(stringValues[i]);
        }
        return values;
    }

    protected long[] fetchLongArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        long[] values = new long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Long(stringValues[i]);
        }
        return values;
    }

    protected Long[] fetchLongObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Long[] values = new Long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Long(stringValues[i]);
        }
        return values;
    }

    protected short[] fetchShortArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        short[] values = new short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Short(stringValues[i]);
        }
        return values;
    }

    protected Short[] fetchShortObjectArrayField() {
        String[] stringValues = this.fetchStringArrayField();
        Short[] values = new Short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Short(stringValues[i]);
        }
        return values;
    }

    protected String[] fetchStringArrayField() {
        try {
            String[] values = new String[this.attr.size()];
            for (int i = 0; i < this.attr.size(); ++i) {
                values[i] = this.attr.get(i) instanceof byte[] ? new String((byte[])this.attr.get(i), "UTF-8") : (String)this.attr.get(i);
            }
            return values;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void insert(Object value) {
        if (value == null) {
            return;
        }
        this.store(value);
    }

    public void update(Object value) {
        if (value == null) {
            this.attributes.put(new BasicAttribute(this.name));
            return;
        }
        this.store(value);
    }

    protected void store(Object value) {
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            this.storeBooleanArrayField((boolean[])value);
        } else if (Byte.TYPE.isAssignableFrom(this.type)) {
            this.storeByteArrayField((byte[])value);
        } else if (Character.TYPE.isAssignableFrom(this.type)) {
            this.storeCharArrayField((char[])value);
        } else if (Double.TYPE.isAssignableFrom(this.type)) {
            this.storeDoubleArrayField((double[])value);
        } else if (Float.TYPE.isAssignableFrom(this.type)) {
            this.storeFloatArrayField((float[])value);
        } else if (Integer.TYPE.isAssignableFrom(this.type)) {
            this.storeIntArrayField((int[])value);
        } else if (Long.TYPE.isAssignableFrom(this.type)) {
            this.storeLongArrayField((long[])value);
        } else if (Short.TYPE.isAssignableFrom(this.type)) {
            this.storeShortArrayField((short[])value);
        } else if (String.class.isAssignableFrom(this.type)) {
            this.storeArrayField((String[])value);
        } else if (Boolean.class.isAssignableFrom(this.type)) {
            this.storeBooleanArrayField((Boolean[])value);
        } else if (Byte.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Byte[])value);
        } else if (Character.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Character[])value);
        } else if (Double.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Double[])value);
        } else if (Float.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Float[])value);
        } else if (Integer.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Integer[])value);
        } else if (Long.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Long[])value);
        } else if (Short.class.isAssignableFrom(this.type)) {
            this.storeArrayField((Short[])value);
        } else {
            CalendarToGeneralizedTimeStringConverter converter = null;
            converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(this.type));
            if (converter != null) {
                Object[] values = (Object[])value;
                Object[] stringValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = converter.toString(values[i]);
                }
                this.storeArrayField(stringValues);
            } else {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
            }
        }
    }

    protected void storeBooleanArrayField(boolean[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (boolean v : values) {
            attribute.add(("" + v).toUpperCase());
        }
        this.attributes.put(attribute);
    }

    protected void storeByteArrayField(byte[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (byte v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeCharArrayField(char[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (char v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeDoubleArrayField(double[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (double v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeFloatArrayField(float[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (float v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeIntArrayField(int[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (int v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeLongArrayField(long[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (long v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeShortArrayField(short[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (short v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }

    protected void storeBooleanArrayField(Boolean[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        Boolean[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean v = arr$[i$];
            attribute.add(("" + v).toUpperCase());
        }
        this.attributes.put(attribute);
    }

    protected void storeArrayField(Object[] values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (Object v : values) {
            attribute.add("" + v);
        }
        this.attributes.put(attribute);
    }
}

