/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.ldap.LDAPUtils;

public class QueryToLDAPFilterMapper
extends AbstractExpressionEvaluator {
    Expression filterExpr;
    AbstractClassMetaData acmd;
    SymbolTable symtbl;
    Stack stack = new Stack();
    Map ldapAttributeTypeMap;

    public QueryToLDAPFilterMapper(QueryCompilation compilation, AbstractClassMetaData acmd) {
        this.filterExpr = compilation.getExprFilter();
        this.symtbl = compilation.getSymbolTable();
        this.acmd = acmd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String compile() {
        AndNode filter = new AndNode();
        String[] objectClasses = LDAPUtils.getObjectClassesForObject(this.acmd);
        for (int i = 0; i < objectClasses.length; ++i) {
            EqualityNode ocNode = new EqualityNode("objectClass", (Value)new ClientStringValue(objectClasses[i]));
            filter.addNode((ExprNode)ocNode);
        }
        if (this.filterExpr == null) return filter.toString();
        this.filterExpr.evaluate((ExpressionEvaluator)this);
        if (this.stack.empty()) throw new NucleusException("Unexpected empty stack");
        Object object = this.stack.pop();
        if (!(object instanceof ExprNode)) throw new NucleusException("Unexpected element on stack: object=" + object);
        ExprNode additionalFilter = (ExprNode)object;
        filter.addNode(additionalFilter);
        return filter.toString();
    }

    protected Object processOrExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(left instanceof ExprNode) || !(right instanceof ExprNode)) {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        OrNode filter = new OrNode();
        filter.addNode((ExprNode)left);
        filter.addNode((ExprNode)right);
        this.stack.push(filter);
        return filter;
    }

    protected Object processAndExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(left instanceof ExprNode) || !(right instanceof ExprNode)) {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        AndNode filter = new AndNode();
        filter.addNode((ExprNode)left);
        filter.addNode((ExprNode)right);
        this.stack.push(filter);
        return filter;
    }

    protected Object processEqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_EQ);
    }

    protected Object processNoteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_NOTEQ);
    }

    protected Object processLtExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_LT);
    }

    protected Object processLteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_LTEQ);
    }

    protected Object processGtExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_GT);
    }

    protected Object processGteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_GTEQ);
    }

    private Object processExpressionWithOperator(Expression expr, Expression.Operator operator) {
        ExprNode filter;
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof PrimaryExpression && right instanceof Literal) {
            String param = QueryUtils.getStringValueForExpression((Expression)((Literal)right), (SymbolTable)this.symtbl);
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof String) {
            String param = (String)right;
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof Character) {
            String param = ((Character)right).toString();
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof Number) {
            String param = ((Number)right).toString();
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        return filter;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        this.stack.push(expr);
        return expr;
    }

    protected Object processLiteral(Literal expr) {
        this.stack.push(expr);
        return expr;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object value = QueryUtils.getValueForParameterExpression((SymbolTable)this.symtbl, (ParameterExpression)expr);
        this.stack.push(value);
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object processInvokeExpression(InvokeExpression expr) {
        SubstringNode filter;
        Expression invokedExpr = expr.getLeft();
        String method = expr.getOperation();
        if (!(invokedExpr instanceof PrimaryExpression)) throw new NucleusException("Case not handled yet: expr=" + expr);
        PrimaryExpression primaryExpression = (PrimaryExpression)invokedExpr;
        String attribute = this.getLdapAttributeType(primaryExpression);
        if (method.equals("startsWith")) {
            Expression param = (Expression)expr.getParameters().get(0);
            String value = QueryUtils.getStringValueForExpression((Expression)param, (SymbolTable)this.symtbl);
            filter = new SubstringNode(attribute);
            filter.setInitial(this.getEscapedValue(value));
            this.stack.push(filter);
            return filter;
        } else {
            if (!method.equals("endsWith")) throw new NucleusException("Case not handled yet: expr=" + expr);
            Expression param = (Expression)expr.getParameters().get(0);
            String value = QueryUtils.getStringValueForExpression((Expression)param, (SymbolTable)this.symtbl);
            filter = new SubstringNode(attribute);
            filter.setFinal(this.getEscapedValue(value));
            this.stack.push(filter);
        }
        return filter;
    }

    private String getEscapedValue(String value) {
        if (value != null) {
            value.replaceAll("\\", "\\5c");
            value = value.replaceAll("\u0000", "\\00");
            value = value.replaceAll("*", "\\2a");
            value = value.replaceAll("(", "\\28");
            value = value.replaceAll(")", "\\29");
        }
        return value;
    }

    private ExprNode getFilterForPrimaryLiteralValue(Expression.Operator operator, PrimaryExpression expr, String param) {
        String attribute = this.getLdapAttributeType(expr);
        ClientStringValue value = new ClientStringValue(this.getEscapedValue(param));
        EqualityNode filter = null;
        if (operator == Expression.OP_EQ) {
            if (!value.isNull()) {
                filter = new EqualityNode(attribute, (Value)value);
            } else {
                NotNode notNode = new NotNode();
                notNode.addNode((ExprNode)new PresenceNode(attribute));
                filter = notNode;
            }
        } else if (operator == Expression.OP_NOTEQ) {
            if (!value.isNull()) {
                NotNode notNode = new NotNode();
                notNode.addNode((ExprNode)new EqualityNode(attribute, (Value)value));
                filter = notNode;
            } else {
                filter = new PresenceNode(attribute);
            }
        } else if (operator == Expression.OP_LT) {
            LessEqNode lessEqualNode = new LessEqNode(attribute, (Value)value);
            NotNode notEqualNode = new NotNode();
            notEqualNode.addNode((ExprNode)new EqualityNode(attribute, (Value)value));
            AndNode andNode = new AndNode();
            andNode.addNode((ExprNode)lessEqualNode);
            andNode.addNode((ExprNode)notEqualNode);
            filter = andNode;
        } else if (operator == Expression.OP_LTEQ) {
            filter = new LessEqNode(attribute, (Value)value);
        } else if (operator == Expression.OP_GT) {
            GreaterEqNode greaterEqualNode = new GreaterEqNode(attribute, (Value)value);
            NotNode notEqualNode = new NotNode();
            notEqualNode.addNode((ExprNode)new EqualityNode(attribute, (Value)value));
            AndNode andNode = new AndNode();
            andNode.addNode((ExprNode)greaterEqualNode);
            andNode.addNode((ExprNode)notEqualNode);
            filter = andNode;
        } else if (operator == Expression.OP_GTEQ) {
            filter = new GreaterEqNode(attribute, (Value)value);
        } else {
            throw new NucleusException("Case not handled yet: operator=" + operator);
        }
        return filter;
    }

    private String getLdapAttributeType(PrimaryExpression expr) {
        String id = expr.getId();
        if (this.ldapAttributeTypeMap == null) {
            this.ldapAttributeTypeMap = new HashMap();
            AbstractMemberMetaData[] managedMembers = this.acmd.getManagedMembers();
            for (int i = 0; i < managedMembers.length; ++i) {
                AbstractMemberMetaData mmd = managedMembers[i];
                String ldapAttributeType = LDAPUtils.getAttributeNameForField(mmd);
                this.ldapAttributeTypeMap.put(mmd.getName(), ldapAttributeType);
            }
        }
        String ldapAttributeType = id;
        if (this.ldapAttributeTypeMap.containsKey(id)) {
            ldapAttributeType = (String)this.ldapAttributeTypeMap.get(id);
        }
        return ldapAttributeType;
    }
}

