/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.datanucleus.FetchPlan;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
implements FieldManager {
    StateManager sm;
    Attributes result;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;

    public FetchFieldManager(StateManager sm, Attributes result) {
        this.sm = sm;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return null;
        }
        try {
            if (attr.get(0) instanceof byte[]) {
                return new String((byte[])attr.get(0));
            }
            return (String)attr.get(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return null;
        }
        if (mmd.isFieldTypePersistable()) {
            return this.getObjectByAttributes(mmd.getType(), mmd, attr, 0);
        }
        if (mmd.getCollection() != null) {
            Collection coll = null;
            Class instanceType = mmd.getType();
            if (instanceType.isInterface()) {
                instanceType = (class$java$util$List == null ? (class$java$util$List = FetchFieldManager.class$("java.util.List")) : class$java$util$List).isAssignableFrom(instanceType) ? (class$java$util$ArrayList == null ? (class$java$util$ArrayList = FetchFieldManager.class$("java.util.ArrayList")) : class$java$util$ArrayList) : (class$java$util$HashSet == null ? (class$java$util$HashSet = FetchFieldManager.class$("java.util.HashSet")) : class$java$util$HashSet);
            }
            try {
                coll = (Collection)instanceType.newInstance();
                Class elementType = this.sm.getObjectManager().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
                for (int i = 0; i < attr.size(); ++i) {
                    coll.add(this.getObjectByAttributes(elementType, mmd, attr, i));
                }
            }
            catch (Exception e) {
                throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
            }
            return coll;
        }
        ObjectStringConverter converter = this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(mmd.getType());
        if (converter != null) {
            try {
                return converter.toObject(attr.get(0).toString());
            }
            catch (NamingException ne) {
                throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
            }
        }
        NucleusLogger.PERSISTENCE.warn((Object)("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore"));
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return false;
        }
        try {
            return new Boolean(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public byte fetchByteField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0;
        }
        try {
            return new Byte(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public char fetchCharField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return ' ';
        }
        try {
            return attr.get(0).toString().charAt(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0.0;
        }
        try {
            return new Double(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public float fetchFloatField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0.0f;
        }
        try {
            return new Float(attr.get(0).toString()).floatValue();
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public int fetchIntField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0;
        }
        try {
            return new Integer(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public long fetchLongField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0L;
        }
        try {
            return new Long(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public short fetchShortField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getDistinguishedNameForField(mmd);
        Attribute attr = this.result.get(name);
        if (attr == null) {
            return 0;
        }
        try {
            return new Short(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private Object getObjectByAttributes(Class cls, AbstractMemberMetaData ammd, Attribute attr, int pos) {
        try {
            final AbstractClassMetaData fieldTypeCmd = this.sm.getMetaDataManager().getMetaDataForClass(cls, this.sm.getObjectManager().getClassLoaderResolver());
            String id = attr.get(pos).toString();
            final BasicAttributes attrs = new BasicAttributes();
            StringTokenizer token = new StringTokenizer(id, ",");
            while (token.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(token.nextToken(), "=");
                attrs.put(new BasicAttribute(t2.nextToken(), t2.nextToken()));
            }
            return this.sm.getObjectManager().findObjectUsingAID(cls, new FieldValues(){

                public void fetchFields(StateManager sm) {
                    sm.replaceFields(fieldTypeCmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public void fetchNonLoadedFields(StateManager sm) {
                    sm.replaceNonLoadedFields(fieldTypeCmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            }, false, true);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    public void storeObjectField(int fieldNumber, Object value) {
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

