/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;

public class LDAPUtils {
    public static final String[] NO_ATTRIBUTES = new String[0];

    public static String getDistinguishedNameForObject(StateManager sm) {
        Object value = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[0]);
        String dnKey = sm.getClassMetaData().getMetaDataForManagedMemberAtPosition(sm.getClassMetaData().getPKMemberPositions()[0]).getValueForExtension("dn");
        return dnKey + "=" + value + "," + sm.getClassMetaData().getValueForExtension("dn");
    }

    public static String getDistinguishedNameForField(AbstractMemberMetaData mmd) {
        String name = mmd.getName();
        if (mmd.hasExtension("dn")) {
            name = mmd.getValueForExtension("dn");
        }
        return name;
    }

    public static List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        String[] subclassNames;
        DirContext ctx = (DirContext)mconn.getConnection();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List results = LDAPUtils.getObjectsOfCandidateType(om, ctx, acmd, ignoreCache);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(om, ctx, cmd, ignoreCache));
            }
        }
        return results;
    }

    private static List getObjectsOfCandidateType(ObjectManager om, DirContext ctx, final AbstractClassMetaData acmd, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            BasicAttributes matchAttrs = new BasicAttributes(true);
            String[] objectClasses = acmd.getValuesForExtension("objectClass");
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            for (int i = 0; i < objectClasses.length; ++i) {
                objectClass.add(objectClasses[i]);
            }
            matchAttrs.put(objectClass);
            NamingEnumeration<SearchResult> enumeration = ctx.search(acmd.getValueForExtension("dn"), (Attributes)matchAttrs);
            while (enumeration.hasMoreElements()) {
                SearchResult sr = (SearchResult)enumeration.nextElement();
                final Attributes attrs = sr.getAttributes();
                results.add(om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), new FieldValues(){

                    public void fetchFields(StateManager sm) {
                        sm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                    }

                    public void fetchNonLoadedFields(StateManager sm) {
                        sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(sm, attrs));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        return results;
    }
}

