/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.CloudStorageUtils;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.orgjson.JSONException;
import org.datanucleus.store.json.orgjson.JSONObject;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.NucleusLogger;

public class FetchEmbeddedFieldManager
extends FetchFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public FetchEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, cmd, jsonobj, table);
        this.mmds = mmds;
    }

    public FetchEmbeddedFieldManager(DNStateManager sm, JSONObject jsonobj, List<AbstractMemberMetaData> mmds, Table table) {
        super(sm, jsonobj, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            return this.ec.getOwnerForEmbeddedStateManager(this.sm);
        }
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            try {
                return this.fetchObjectFieldEmbedded(mmd, clr, relationType);
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            return this.fetchObjectFieldInternal(mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Object fetchObjectFieldEmbedded(AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            boolean nested = CloudStorageUtils.isMemberNested(mmd);
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
            embMmds.add(mmd);
            if (nested) {
                String name;
                MemberColumnMapping mapping = this.getColumnMapping(mmd.getAbsoluteFieldNumber());
                String string = name = mapping != null ? mapping.getColumn(0).getName() : mmd.getName();
                if (this.jsonobj.isNull(name)) {
                    return null;
                }
                JSONObject embobj = this.jsonobj.getJSONObject(name);
                NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " marked as embedded NESTED; This is experimental : " + embobj));
                DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embCmd, this.sm, mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_PC);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embSM, embobj, embMmds, this.table);
                embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embSM.getObject();
            }
            DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embCmd, this.sm, mmd.getAbsoluteFieldNumber(), PersistableObjectType.EMBEDDED_PC);
            FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embSM, this.jsonobj, embMmds, this.table);
            embSM.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
            return embSM.getObject();
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            NucleusLogger.PERSISTENCE.debug((Object)("Field=" + mmd.getFullFieldName() + " not currently supported (embedded container)"));
            return null;
        }
        return null;
    }
}

