/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected final Table table;
    protected final JSONObject jsonobj;
    protected final StoreManager storeMgr;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, Table table) {
        super(ec, cmd);
        this.jsonobj = jsonobj;
        this.storeMgr = ec.getStoreManager();
        this.table = table;
    }

    public FetchFieldManager(ObjectProvider op, JSONObject jsonobj, Table table) {
        super(op);
        this.jsonobj = jsonobj;
        this.storeMgr = this.ec.getStoreManager();
        this.table = table;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return false;
        }
        try {
            return this.jsonobj.getBoolean(memberName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            String str = this.jsonobj.getString(memberName);
            return Byte.valueOf(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return '\u0000';
        }
        try {
            return this.jsonobj.getString(memberName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0.0;
        }
        try {
            return this.jsonobj.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0.0f;
        }
        try {
            return (float)this.jsonobj.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            return this.jsonobj.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public long fetchLongField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0L;
        }
        try {
            return this.jsonobj.getLong(memberName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            return (short)this.jsonobj.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public String fetchStringField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier();
        if (this.jsonobj.isNull(memberName)) {
            return null;
        }
        try {
            return this.jsonobj.getString(memberName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        ClassLoaderResolver clr;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr = this.ec.getClassLoaderResolver());
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            try {
                return this.fetchObjectFieldEmbedded(fieldNumber, mmd, clr, relationType);
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            return this.fetchObjectFieldInternal(fieldNumber, mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected Object fetchObjectFieldEmbedded(int fieldNumber, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            boolean nested = false;
            String nestedStr = mmd.getValueForExtension("nested");
            if (nestedStr != null && nestedStr.equalsIgnoreCase("true")) {
                nested = true;
            }
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
            embMmds.add(mmd);
            if (nested) {
                String name;
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                String string = name = mapping != null ? mapping.getColumn(0).getIdentifier() : mmd.getName();
                if (this.jsonobj.isNull(name)) {
                    return null;
                }
                JSONObject embobj = this.jsonobj.getJSONObject(name);
                NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " marked as embedded NESTED; This is experimental : " + embobj));
                ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, embobj, embMmds, this.table);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
            FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, this.jsonobj, embMmds, this.table);
            embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
            return embOP.getObject();
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            throw new NucleusUserException("Dont support embedded multi-valued field at " + mmd.getFullFieldName() + " with Excel");
        }
        return null;
    }

    protected Object fetchObjectFieldInternal(int fieldNumber, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (relationType == RelationType.NONE) {
            Object returnValue = null;
            if (mapping.getTypeConverter() != null) {
                TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
                if (mapping.getNumberOfColumns() > 1) {
                    boolean isNull = true;
                    Object[] valuesArr = null;
                    Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                    valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        String colName = mapping.getColumn(i).getIdentifier();
                        if (colTypes[i] == String.class) {
                            Array.set(valuesArr, i, this.jsonobj.getString(colName));
                            continue;
                        }
                        if (colTypes[i] == Boolean.class) {
                            Array.set(valuesArr, i, this.jsonobj.getBoolean(colName));
                            continue;
                        }
                        if (colTypes[i] == Double.class) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Float.class) {
                            Array.set(valuesArr, i, Float.valueOf((float)this.jsonobj.getDouble(colName)));
                            continue;
                        }
                        if (colTypes[i] == Integer.class) {
                            Array.set(valuesArr, i, this.jsonobj.getInt(colName));
                            continue;
                        }
                        if (colTypes[i] == Long.class) {
                            Array.set(valuesArr, i, this.jsonobj.getLong(colName));
                            continue;
                        }
                        if (colTypes[i] == Double.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Float.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Integer.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getInt(colName));
                            continue;
                        }
                        if (colTypes[i] != Long.TYPE) continue;
                        Array.set(valuesArr, i, this.jsonobj.getLong(colName));
                    }
                    if (isNull) {
                        return null;
                    }
                    Object memberValue = conv.toMemberType((Object)valuesArr);
                    if (this.op != null && memberValue != null) {
                        memberValue = this.op.wrapSCOField(fieldNumber, memberValue, false, false, true);
                    }
                    return memberValue;
                }
                String colName = mapping.getColumn(0).getIdentifier();
                if (this.jsonobj.isNull(colName)) {
                    return null;
                }
                Class datastoreType = TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType());
                if (datastoreType == String.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getString(colName));
                } else if (datastoreType == Boolean.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getBoolean(colName));
                } else if (datastoreType == Double.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getDouble(colName));
                } else if (datastoreType == Float.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getDouble(colName));
                } else if (datastoreType == Integer.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getInt(colName));
                } else if (datastoreType == Long.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getLong(colName));
                }
                if (this.op != null) {
                    returnValue = this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
                }
                return returnValue;
            }
            String colName = mapping.getColumn(0).getIdentifier();
            if (this.jsonobj.isNull(colName)) {
                return null;
            }
            if (Boolean.class.isAssignableFrom(mmd.getType())) {
                return this.jsonobj.getBoolean(colName);
            }
            if (Integer.class.isAssignableFrom(mmd.getType())) {
                return this.jsonobj.getInt(colName);
            }
            if (Long.class.isAssignableFrom(mmd.getType())) {
                return this.jsonobj.getLong(colName);
            }
            if (Double.class.isAssignableFrom(mmd.getType())) {
                return this.jsonobj.getDouble(colName);
            }
            if (Enum.class.isAssignableFrom(mmd.getType())) {
                if (MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType())) {
                    return mmd.getType().getEnumConstants()[this.jsonobj.getInt(colName)];
                }
                return Enum.valueOf(mmd.getType(), (String)this.jsonobj.get(colName));
            }
            if (BigDecimal.class.isAssignableFrom(mmd.getType()) || BigInteger.class.isAssignableFrom(mmd.getType())) {
                return TypeConversionHelper.convertTo((Object)this.jsonobj.get(colName), (Class)mmd.getType());
            }
            if (Collection.class.isAssignableFrom(mmd.getType())) {
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                JSONArray array = this.jsonobj.getJSONArray(colName);
                Class elementCls = null;
                if (mmd.getCollection() != null && mmd.getCollection().getElementType() != null) {
                    elementCls = clr.classForName(mmd.getCollection().getElementType());
                }
                for (int i = 0; i < array.length(); ++i) {
                    if (array.isNull(i)) {
                        coll.add(null);
                        continue;
                    }
                    Object value = array.get(i);
                    if (value instanceof JSONObject) {
                        Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                        coll.add(this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr));
                        continue;
                    }
                    if (elementCls != null) {
                        coll.add(TypeConversionHelper.convertTo((Object)value, (Class)elementCls));
                        continue;
                    }
                    coll.add(value);
                }
                if (this.op != null) {
                    this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                }
                return coll;
            }
            if (Map.class.isAssignableFrom(mmd.getType())) {
                Map map;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                JSONObject mapValue = this.jsonobj.getJSONObject(colName);
                Iterator keyIter = mapValue.keys();
                Class keyCls = null;
                if (mmd.getMap() != null && mmd.getMap().getKeyType() != null) {
                    keyCls = clr.classForName(mmd.getMap().getKeyType());
                }
                Class valCls = null;
                if (mmd.getMap() != null && mmd.getMap().getValueType() != null) {
                    valCls = clr.classForName(mmd.getMap().getValueType());
                }
                while (keyIter.hasNext()) {
                    Object jsonVal;
                    Object jsonKey;
                    Object key = jsonKey = keyIter.next();
                    if (keyCls != null) {
                        key = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                    }
                    Object val = jsonVal = mapValue.get((String)key);
                    if (jsonVal instanceof JSONObject) {
                        Class cls = clr.classForName(((JSONObject)jsonVal).getString("class"), true);
                        val = this.getNonpersistableObjectFromJSON((JSONObject)jsonVal, cls, clr);
                    } else if (valCls != null) {
                        val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                    }
                    map.put(key, val);
                }
                if (this.op != null) {
                    this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
                }
                return map;
            }
            if (mmd.getType().isArray()) {
                JSONArray arrayJson = this.jsonobj.getJSONArray(colName);
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrayJson.length());
                for (int i = 0; i < arrayJson.length(); ++i) {
                    if (arrayJson.isNull(i)) {
                        Array.set(array, i, null);
                        continue;
                    }
                    Object value = arrayJson.get(i);
                    if (value instanceof JSONObject) {
                        JSONObject valueJson = (JSONObject)value;
                        Class valueCls = clr.classForName(valueJson.getString("class"));
                        Array.set(array, i, this.getNonpersistableObjectFromJSON((JSONObject)value, valueCls, clr));
                        continue;
                    }
                    Array.set(array, i, TypeConversionHelper.convertTo((Object)value, mmd.getType().getComponentType()));
                }
                return array;
            }
            boolean useLong = MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType());
            TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            TypeConverter longConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
            if (useLong && longConv != null) {
                returnValue = longConv.toMemberType((Object)this.jsonobj.getLong(colName));
            } else if (!useLong && strConv != null) {
                returnValue = strConv.toMemberType((Object)((String)this.jsonobj.get(colName)));
            } else if (!useLong && longConv != null) {
                returnValue = longConv.toMemberType((Object)this.jsonobj.getLong(colName));
            } else {
                Object value = this.jsonobj.get(colName);
                if (value instanceof JSONObject) {
                    Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                    returnValue = this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr);
                } else {
                    returnValue = TypeConversionHelper.convertTo((Object)this.jsonobj.get(colName), (Class)mmd.getType());
                }
            }
            if (this.op != null) {
                this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
            }
            return returnValue;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            String colName = mapping.getColumn(0).getIdentifier();
            if (this.jsonobj.isNull(colName)) {
                return null;
            }
            String idStr = (String)this.jsonobj.get(colName);
            if (idStr == null) {
                return null;
            }
            Object obj = null;
            AbstractClassMetaData memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            obj = memberCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
            return obj;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            String colName = mapping.getColumn(0).getIdentifier();
            if (this.jsonobj.isNull(colName)) {
                return null;
            }
            if (mmd.hasCollection()) {
                Collection coll;
                JSONArray array = (JSONArray)this.jsonobj.get(colName);
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
                for (int i = 0; i < array.length(); ++i) {
                    String idStr = (String)array.get(i);
                    Object element = null;
                    element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                    coll.add(element);
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                }
                return coll;
            }
            if (mmd.hasArray()) {
                JSONArray array = (JSONArray)this.jsonobj.get(colName);
                Object arrayField = Array.newInstance(mmd.getType().getComponentType(), array.length());
                AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
                for (int i = 0; i < array.length(); ++i) {
                    String idStr = (String)array.get(i);
                    Object element = null;
                    element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                    Array.set(arrayField, i, element);
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), arrayField, false, false, true);
                }
                return arrayField;
            }
            if (mmd.hasMap()) {
                Map map;
                JSONObject mapVal = (JSONObject)this.jsonobj.get(colName);
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                Iterator keyIter = mapVal.keys();
                while (keyIter.hasNext()) {
                    Object jsonKey = keyIter.next();
                    Object key = null;
                    if (keyCmd != null) {
                        String idStr = (String)jsonKey;
                        key = keyCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        Class keyCls = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
                        key = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                    }
                    Object jsonVal = mapVal.get((String)key);
                    Object val = null;
                    if (valCmd != null) {
                        String idStr = (String)jsonVal;
                        val = valCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        Class valCls = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
                        val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                    }
                    map.put(key, val);
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
                }
                return map;
            }
        }
        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
    }

    private Object getNonpersistableObjectFromJSON(final JSONObject jsonobj, final Class cls, ClassLoaderResolver clr) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            return this.getComGoogleAppengineApiUsersUserFromJSON(jsonobj, cls, clr);
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            return this.getComGoogleAppengineApiDatastoreKeyFromJSON(jsonobj, cls, clr);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Object getComGoogleAppengineApiUsersUserFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        String email = null;
        String authDomain = null;
        try {
            email = jsonobj.getString("email");
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            authDomain = jsonobj.getString("authDomain");
        }
        catch (JSONException e) {
            // empty catch block
        }
        return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
    }

    protected Object getComGoogleAppengineApiDatastoreKeyFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        try {
            Object parent = null;
            if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                JSONObject parentobj = jsonobj.getJSONObject("parent");
                parent = this.getNonpersistableObjectFromJSON(parentobj, clr.classForName(jsonobj.getString("class")), clr);
            }
            if (jsonobj.has("appId")) {
                String appId = jsonobj.getString("appId");
                String kind = jsonobj.getString("kind");
                Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
                if (parent != null) {
                    return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                }
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
            }
            long id = jsonobj.getLong("id");
            String kind = jsonobj.getString("kind");
            Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
            if (parent != null) {
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
            }
            return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

