/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected JSONObject jsonobj;

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.jsonobj = jsonobj;
        this.table = table;
    }

    public StoreFieldManager(ObjectProvider op, JSONObject jsonobj, boolean insert, Table table) {
        super(op, insert);
        this.table = table;
        this.jsonobj = jsonobj;
        try {
            jsonobj.put("class", this.cmd.getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), new Character(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        try {
            if (value == null) {
                this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), JSONObject.NULL);
            } else {
                this.jsonobj.put(this.getColumnMapping(fieldNumber).getColumn(0).getIdentifier(), value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(ec, embCmd, this.jsonobj, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                            }
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    return;
                }
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embOP, this.jsonobj, this.insert, embMmds, this.table);
                embOP.provideFields(embMmdPosns, (FieldManager)storeEmbFM);
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                throw new NucleusUserException("Dont support embedded multi-valued field at " + mmd.getFullFieldName() + " with Excel");
            }
        }
        try {
            this.storeObjectFieldInternal(fieldNumber, value, mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void storeObjectFieldInternal(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        String name = mapping.getColumn(0).getIdentifier();
        if (value == null) {
            this.jsonobj.put(name, JSONObject.NULL);
            return;
        }
        if (relationType == RelationType.NONE) {
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        Object colValue = Array.get(datastoreValue, i);
                        this.jsonobj.put(mapping.getColumn(i).getIdentifier(), colValue);
                    }
                } else {
                    this.jsonobj.put(mapping.getColumn(0).getIdentifier(), datastoreValue);
                }
            } else if (value instanceof Boolean) {
                this.jsonobj.put(name, (Boolean)value);
            } else if (value instanceof Integer) {
                this.jsonobj.put(name, (Integer)value);
            } else if (value instanceof Long) {
                this.jsonobj.put(name, (Long)value);
            } else if (value instanceof Double) {
                this.jsonobj.put(name, (Double)value);
            } else if (value instanceof Enum) {
                if (MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType())) {
                    this.jsonobj.put(name, ((Enum)value).ordinal());
                } else {
                    this.jsonobj.put(name, ((Enum)value).name());
                }
            } else if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
            } else if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Collection) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Map) {
                this.jsonobj.put(name, value);
            } else {
                boolean useLong = MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType());
                TypeConverter longConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
                if (useLong) {
                    if (longConv != null) {
                        this.jsonobj.put(name, longConv.toDatastoreType(value));
                        return;
                    }
                } else {
                    TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
                    if (strConv != null) {
                        this.jsonobj.put(name, strConv.toDatastoreType(value));
                        return;
                    }
                    if (longConv != null) {
                        this.jsonobj.put(name, longConv.toDatastoreType(value));
                        return;
                    }
                }
                JSONObject jsonobjfield = new JSONObject(value);
                jsonobjfield.put("class", value.getClass().getName());
                this.jsonobj.put(name, jsonobjfield);
            }
            return;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            Object valuePC = this.ec.persistObjectInternal(value, this.op, fieldNumber, -1);
            Object valueId = this.ec.getApiAdapter().getIdForObject(valuePC);
            this.jsonobj.put(name, IdentityUtils.getPersistableIdentityForId((ApiAdapter)this.ec.getApiAdapter(), (Object)valueId));
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (mmd.hasCollection()) {
                ArrayList<String> idColl = new ArrayList<String>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                    idColl.add(IdentityUtils.getPersistableIdentityForId((ApiAdapter)this.ec.getApiAdapter(), (Object)elementID));
                }
                this.jsonobj.put(name, idColl);
                return;
            }
            if (mmd.hasArray()) {
                ArrayList<String> ids = new ArrayList<String>(Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                    ids.add(IdentityUtils.getPersistableIdentityForId((ApiAdapter)this.ec.getApiAdapter(), (Object)elementID));
                }
                this.jsonobj.put(name, ids);
                return;
            }
            if (mmd.hasMap()) {
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                HashMap<Object, Object> idMap = new HashMap<Object, Object>();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = null;
                    Object val = null;
                    if (keyCmd != null) {
                        Object keyPC = this.ec.persistObjectInternal(entry.getKey(), this.op, fieldNumber, -1);
                        key = this.ec.getApiAdapter().getIdForObject(keyPC);
                        key = IdentityUtils.getPersistableIdentityForId((ApiAdapter)this.ec.getApiAdapter(), (Object)key);
                    } else {
                        key = entry.getKey();
                    }
                    if (valCmd != null) {
                        Object valPC = this.ec.persistObjectInternal(entry.getValue(), this.op, fieldNumber, -1);
                        val = this.ec.getApiAdapter().getIdForObject(valPC);
                        val = IdentityUtils.getPersistableIdentityForId((ApiAdapter)this.ec.getApiAdapter(), (Object)val);
                    } else {
                        val = entry.getValue();
                    }
                    idMap.put(key, val);
                }
                this.jsonobj.put(name, idMap);
                return;
            }
        }
        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
    }
}

