/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.json.JSONUtils;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    JSONObject jsonobj;
    protected boolean insert;

    public StoreFieldManager(ObjectProvider op, JSONObject jsonobj, boolean insert) {
        this.op = op;
        this.jsonobj = jsonobj;
        this.insert = insert;
        try {
            jsonobj.put("class", op.getClassMetaData().getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isStorable(int fieldNumber) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        return this.isStorable(mmd);
    }

    protected boolean isStorable(AbstractMemberMetaData mmd) {
        return this.insert && mmd.isInsertable() || !this.insert && mmd.isUpdateable();
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, new Character(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else {
                this.jsonobj.put(name, value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        if (Relation.isRelationSingleValued((int)relationType) && mmd.isEmbedded()) {
            throw new NucleusException("Embedded fields are not supported");
        }
        try {
            this.storeObjectFieldInternal(fieldNumber, value, mmd, clr);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected void storeObjectFieldInternal(int fieldNumber, Object value, AbstractMemberMetaData mmd, ClassLoaderResolver clr) throws JSONException {
        int relationType = mmd.getRelationType(clr);
        String name = JSONUtils.getMemberNameForMember(mmd);
        if (value == null) {
            this.jsonobj.put(name, JSONObject.NULL);
            return;
        }
        if (relationType == 0) {
            if (value instanceof Boolean) {
                this.jsonobj.put(name, (Boolean)value);
            } else if (value instanceof Integer) {
                this.jsonobj.put(name, (Integer)value);
            } else if (value instanceof Long) {
                this.jsonobj.put(name, (Long)value);
            } else if (value instanceof Double) {
                this.jsonobj.put(name, (Double)value);
            } else if (value instanceof Enum) {
                String jdbcType;
                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                boolean persistAsString = true;
                if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null && ((jdbcType = colmds[0].getJdbcType()).equalsIgnoreCase("INTEGER") || jdbcType.equalsIgnoreCase("NUMERIC"))) {
                    persistAsString = false;
                }
                if (persistAsString) {
                    this.jsonobj.put(name, ((Enum)value).name());
                } else {
                    this.jsonobj.put(name, ((Enum)value).ordinal());
                }
            } else if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
            } else if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Collection) {
                this.jsonobj.put(name, value);
            } else if (value instanceof Map) {
                this.jsonobj.put(name, value);
            } else {
                String jdbc;
                boolean useLong = false;
                ColumnMetaData[] colmds = mmd.getColumnMetaData();
                if (colmds != null && colmds.length == 1 && (jdbc = colmds[0].getJdbcType()) != null && (jdbc.equalsIgnoreCase("INTEGER") || jdbc.equalsIgnoreCase("NUMERIC"))) {
                    useLong = true;
                }
                ObjectStringConverter strConv = this.op.getExecutionContext().getNucleusContext().getTypeManager().getStringConverter(value.getClass());
                ObjectLongConverter longConv = this.op.getExecutionContext().getNucleusContext().getTypeManager().getLongConverter(value.getClass());
                if (useLong) {
                    if (longConv != null) {
                        this.jsonobj.put(name, longConv.toLong(value));
                    }
                } else if (strConv != null) {
                    this.jsonobj.put(name, strConv.toString(value));
                } else if (longConv != null) {
                    this.jsonobj.put(name, longConv.toLong(value));
                }
                JSONObject jsonobjfield = new JSONObject(value);
                jsonobjfield.put("class", value.getClass().getName());
                this.jsonobj.put(name, jsonobjfield);
            }
            return;
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, this.op, fieldNumber, -1);
            Object valueId = this.op.getExecutionContext().getApiAdapter().getIdForObject(valuePC);
            this.jsonobj.put(name, valueId);
            return;
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                ArrayList<String> idColl = new ArrayList<String>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.op.getExecutionContext().persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.op.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    idColl.add(elementID.toString());
                }
                this.jsonobj.put(name, idColl);
                return;
            }
            if (mmd.hasArray()) {
                ArrayList<String> ids = new ArrayList<String>(Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = this.op.getExecutionContext().persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.op.getExecutionContext().getApiAdapter().getIdForObject(elementPC);
                    ids.add(elementID.toString());
                }
                this.jsonobj.put(name, ids);
                return;
            }
            if (mmd.hasMap()) {
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.op.getExecutionContext().getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.op.getExecutionContext().getMetaDataManager());
                HashMap<Object, Object> idMap = new HashMap<Object, Object>();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = null;
                    Object val = null;
                    if (keyCmd != null) {
                        Object keyPC = this.op.getExecutionContext().persistObjectInternal(entry.getKey(), this.op, fieldNumber, -1);
                        key = this.op.getExecutionContext().getApiAdapter().getIdForObject(keyPC);
                    } else {
                        key = entry.getKey();
                    }
                    if (valCmd != null) {
                        Object valPC = this.op.getExecutionContext().persistObjectInternal(entry.getValue(), this.op, fieldNumber, -1);
                        val = this.op.getExecutionContext().getApiAdapter().getIdForObject(valPC);
                    } else {
                        val = entry.getValue();
                    }
                    idMap.put(key, val);
                }
                this.jsonobj.put(name, idMap);
                return;
            }
        }
        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
    }
}

