/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.json.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    JSONObject jsonobj;

    public StoreFieldManager(ObjectProvider sm, JSONObject jsonobj) {
        this.sm = sm;
        this.jsonobj = jsonobj;
        try {
            jsonobj.put("class", sm.getClassMetaData().getFullClassName());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, new Character(value));
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            this.jsonobj.put(name, value);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else {
                this.jsonobj.put(name, value);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = JSONUtils.getMemberNameForMember(mmd);
        try {
            if (value == null) {
                this.jsonobj.put(name, JSONObject.NULL);
            } else if (value instanceof Date) {
                this.jsonobj.put(name, ((Date)value).getTime());
            } else if (value instanceof Calendar) {
                this.jsonobj.put(name, ((Calendar)value).getTimeInMillis());
            } else if (value instanceof BigDecimal) {
                this.jsonobj.put(name, value);
            } else if (value instanceof BigInteger) {
                this.jsonobj.put(name, value);
            } else {
                JSONObject jsonobjfield = new JSONObject(value);
                jsonobjfield.put("class", value.getClass().getName());
                this.jsonobj.put(name, jsonobjfield);
            }
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }
}

