/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.JSONUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
extends AbstractFieldManager {
    AbstractClassMetaData acmd;
    ExecutionContext ec;
    JSONObject result;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData acmd, JSONObject result) {
        this.acmd = acmd;
        this.ec = ec;
        this.result = result;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return false;
        }
        try {
            return this.result.getBoolean(memberName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            String str = this.result.getString(memberName);
            return new Byte(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return '\u0000';
        }
        try {
            return this.result.getString(memberName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0.0;
        }
        try {
            return this.result.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0.0f;
        }
        try {
            return (float)this.result.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            return this.result.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public long fetchLongField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0L;
        }
        try {
            return this.result.getLong(memberName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return 0;
        }
        try {
            return (short)this.result.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public String fetchStringField(int fieldNumber) {
        String memberName = JSONUtils.getMemberNameForMember(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        if (this.result.isNull(memberName)) {
            return null;
        }
        try {
            return this.result.getString(memberName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String memberName = JSONUtils.getMemberNameForMember(mmd);
        if (this.result.isNull(memberName)) {
            return null;
        }
        try {
            Object value = this.result.get(memberName);
            if (value instanceof JSONObject) {
                return this.getObjectFromJSONObject((JSONObject)value, mmd.getType().getName(), this.ec);
            }
            if (value instanceof JSONArray) {
                return this.fetchJSONArray((JSONArray)value, fieldNumber, this.ec, this.acmd);
            }
            return TypeConversionHelper.convertTo((Object)this.result.get(memberName), (Class)mmd.getType());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    private List fetchJSONArray(JSONArray array, int position, ExecutionContext oecm, AbstractClassMetaData cmd) throws JSONException {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) {
                elements.add(null);
                continue;
            }
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                elements.add(this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), oecm));
                continue;
            }
            if (value instanceof JSONArray) {
                elements.add(this.fetchJSONArray((JSONArray)value, position, oecm, cmd));
                continue;
            }
            elements.add(TypeConversionHelper.convertTo((Object)value, (Class)cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType()));
        }
        return elements;
    }

    protected Object getObjectFromJSONObject(final JSONObject jsonobj, String className, final ExecutionContext ec) {
        NucleusContext ctx = ec.getNucleusContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class cls = clr.classForName(className, true);
        final AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd == null) {
            return this.getObject(clr, jsonobj, cls);
        }
        ObjectProvider op = ObjectProviderFactory.newForHollowPopulatedAppId((ExecutionContext)ec, (Class)cls, (FieldValues)new FieldValues(){

            public FetchPlan getFetchPlanForLoading() {
                return ec.getFetchPlan();
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, null, cmd, ec));
            }

            public void fetchFields(ObjectProvider op) {
                op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, null, cmd, ec));
            }
        });
        Object obj = op.getObject();
        try {
            Object id = ec.getApiAdapter().getNewApplicationIdentityObjectId(op.getObject(), cmd);
            obj = ec.findObject(id, false, true, null);
            ObjectProvider sm = ec.findObjectProvider(obj);
            sm.replaceFields(cmd.getNonPKMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, sm, cmd, ec));
            return obj;
        }
        catch (NucleusException ex) {
            return obj;
        }
    }

    private Object getObject(ClassLoaderResolver clr, final JSONObject jsonobj, final Class cls) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            String email = null;
            String authDomain = null;
            try {
                email = jsonobj.getString("email");
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                authDomain = jsonobj.getString("authDomain");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            try {
                Object parent = null;
                if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                    JSONObject parentobj = jsonobj.getJSONObject("parent");
                    parent = this.getObject(clr, parentobj, clr.classForName(jsonobj.getString("class")));
                }
                if (jsonobj.has("appId")) {
                    String appId = jsonobj.getString("appId");
                    String kind = jsonobj.getString("kind");
                    Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                    if (parent != null) {
                        return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                    }
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
                }
                long id = jsonobj.getLong("id");
                String kind = jsonobj.getString("kind");
                Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                if (parent != null) {
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
                }
                return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    class LocalFieldManager
    extends AbstractFieldManager {
        JSONObject jsonobj;
        AbstractClassMetaData cmd;
        ObjectProvider sm;
        ExecutionContext ec;

        LocalFieldManager(JSONObject jsonobj, ObjectProvider sm, AbstractClassMetaData cmd, ExecutionContext ec) {
            this.jsonobj = jsonobj;
            this.cmd = cmd;
            this.sm = sm;
            this.ec = ec;
        }

        public String fetchStringField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return null;
            }
            try {
                String value = this.jsonobj.getString(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return null;
            }
        }

        public short fetchShortField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0;
            }
            try {
                short value = (short)this.jsonobj.getInt(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public Object fetchObjectField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return null;
            }
            try {
                if (this.jsonobj.isNull(memberName)) {
                    return null;
                }
                Object value = this.jsonobj.get(memberName);
                if (value instanceof JSONObject) {
                    value = FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.ec);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (value instanceof JSONArray) {
                    value = this.fetchJSONArray((JSONArray)value, position);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType());
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List fetchJSONArray(JSONArray array, int position) throws JSONException {
            ArrayList<Object> elements = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) {
                    elements.add(null);
                    continue;
                }
                Object value = array.get(i);
                if (value instanceof JSONObject) {
                    elements.add(FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.ec));
                    continue;
                }
                if (value instanceof JSONArray) {
                    elements.add(this.fetchJSONArray((JSONArray)value, position));
                    continue;
                }
                elements.add(TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType()));
            }
            return elements;
        }

        public long fetchLongField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0L;
            }
            try {
                long value = this.jsonobj.getLong(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0L;
            }
        }

        public int fetchIntField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0;
            }
            try {
                int value = this.jsonobj.getInt(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public float fetchFloatField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0.0f;
            }
            try {
                float value = (float)this.jsonobj.getDouble(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0f;
            }
        }

        public double fetchDoubleField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0.0;
            }
            try {
                double value = this.jsonobj.getDouble(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0;
            }
        }

        public char fetchCharField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return '\u0000';
            }
            try {
                String str = this.jsonobj.getString(memberName);
                char value = '\u0000';
                if (str != null && str.length() > 0) {
                    value = str.charAt(0);
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return '\u0000';
            }
        }

        public byte fetchByteField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return 0;
            }
            try {
                String str = this.jsonobj.getString(memberName);
                byte value = 0;
                if (str != null && str.length() > 0) {
                    value = str.getBytes()[0];
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public boolean fetchBooleanField(int position) {
            String memberName = JSONUtils.getMemberNameForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position));
            if (!this.jsonobj.has(memberName)) {
                return false;
            }
            try {
                boolean value = this.jsonobj.getBoolean(memberName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return false;
            }
        }
    }
}

