/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.TypeConversionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
extends AbstractFieldManager {
    AbstractClassMetaData acmd;
    ExecutionContext ec;
    JSONObject result;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData acmd, JSONObject result) {
        this.acmd = acmd;
        this.ec = ec;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            return this.result.getString(fieldName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return (short)this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            Object value = this.result.get(fieldName);
            if (value instanceof JSONObject) {
                return this.getObjectFromJSONObject((JSONObject)value, mmd.getType().getName(), this.ec);
            }
            if (value instanceof JSONArray) {
                return this.fetchJSONArray((JSONArray)value, fieldNumber, this.ec, this.acmd);
            }
            return TypeConversionHelper.convertTo((Object)this.result.get(fieldName), (Class)mmd.getType());
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    private List fetchJSONArray(JSONArray array, int position, ExecutionContext om, AbstractClassMetaData cmd) throws JSONException {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) {
                elements.add(null);
                continue;
            }
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                elements.add(this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), om));
                continue;
            }
            if (value instanceof JSONArray) {
                elements.add(this.fetchJSONArray((JSONArray)value, position, om, cmd));
                continue;
            }
            elements.add(TypeConversionHelper.convertTo((Object)value, (Class)cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType()));
        }
        return elements;
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0L;
        }
        try {
            return this.result.getLong(fieldName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0f;
        }
        try {
            return (float)this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0;
        }
        try {
            return this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return '\u0000';
        }
        try {
            return this.result.getString(fieldName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            String str = this.result.getString(fieldName);
            return new Byte(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return false;
        }
        try {
            return this.result.getBoolean(fieldName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    protected Object getObjectFromJSONObject(final JSONObject jsonobj, String className, final ExecutionContext om) {
        NucleusContext ctx = om.getNucleusContext();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class cls = clr.classForName(className, true);
        final AbstractClassMetaData cmd = ctx.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd == null) {
            return this.getObject(clr, jsonobj, cls);
        }
        ObjectProvider op = ObjectProviderFactory.newForHollowPopulatedAppId((ExecutionContext)om, (Class)cls, (FieldValues2)new FieldValues2(){

            public FetchPlan getFetchPlanForLoading() {
                return om.getFetchPlan();
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, null, cmd, om));
            }

            public void fetchFields(ObjectProvider op) {
                op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, null, cmd, om));
            }
        });
        Object obj = op.getObject();
        try {
            Object id = om.getApiAdapter().getNewApplicationIdentityObjectId(op.getObject(), cmd);
            obj = om.findObject(id, false, true, null);
            ObjectProvider sm = om.findObjectProvider(obj);
            sm.replaceFields(cmd.getNonPKMemberPositions(), (FieldManager)new LocalFieldManager(jsonobj, sm, cmd, om));
            return obj;
        }
        catch (NucleusException ex) {
            return obj;
        }
    }

    private Object getObject(ClassLoaderResolver clr, final JSONObject jsonobj, final Class cls) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            String email = null;
            String authDomain = null;
            try {
                email = jsonobj.getString("email");
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                authDomain = jsonobj.getString("authDomain");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            try {
                Object parent = null;
                if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                    JSONObject parentobj = jsonobj.getJSONObject("parent");
                    parent = this.getObject(clr, parentobj, clr.classForName(jsonobj.getString("class")));
                }
                if (jsonobj.has("appId")) {
                    String appId = jsonobj.getString("appId");
                    String kind = jsonobj.getString("kind");
                    Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                    if (parent != null) {
                        return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                    }
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
                }
                long id = jsonobj.getLong("id");
                String kind = jsonobj.getString("kind");
                Class<?> keyFactory = Class.forName("com.google.appengine.api.datastore.KeyFactory", false, cls.getClassLoader());
                if (parent != null) {
                    return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
                }
                return ClassUtils.getMethodForClass(keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    class LocalFieldManager
    implements FieldManager {
        JSONObject jsonobj;
        AbstractClassMetaData cmd;
        ObjectProvider sm;
        ExecutionContext pm;

        LocalFieldManager(JSONObject jsonobj, ObjectProvider sm, AbstractClassMetaData cmd, ExecutionContext pm) {
            this.jsonobj = jsonobj;
            this.cmd = cmd;
            this.sm = sm;
            this.pm = pm;
        }

        public String fetchStringField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                String value = this.jsonobj.getString(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return null;
            }
        }

        public short fetchShortField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                short value = (short)this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public Object fetchObjectField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return null;
            }
            try {
                if (this.jsonobj.isNull(fieldName)) {
                    return null;
                }
                Object value = this.jsonobj.get(fieldName);
                if (value instanceof JSONObject) {
                    value = FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (value instanceof JSONArray) {
                    value = this.fetchJSONArray((JSONArray)value, position);
                    if (this.sm != null) {
                        this.sm.makeDirty(position);
                    }
                    return value;
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType());
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }

        private List fetchJSONArray(JSONArray array, int position) throws JSONException {
            ArrayList<Object> elements = new ArrayList<Object>();
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) {
                    elements.add(null);
                    continue;
                }
                Object value = array.get(i);
                if (value instanceof JSONObject) {
                    elements.add(FetchFieldManager.this.getObjectFromJSONObject((JSONObject)value, ((JSONObject)value).getString("class"), this.pm));
                    continue;
                }
                if (value instanceof JSONArray) {
                    elements.add(this.fetchJSONArray((JSONArray)value, position));
                    continue;
                }
                elements.add(TypeConversionHelper.convertTo((Object)value, (Class)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getType()));
            }
            return elements;
        }

        public long fetchLongField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0L;
            }
            try {
                long value = this.jsonobj.getLong(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0L;
            }
        }

        public int fetchIntField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                int value = this.jsonobj.getInt(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public float fetchFloatField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0f;
            }
            try {
                float value = (float)this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0f;
            }
        }

        public double fetchDoubleField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0.0;
            }
            try {
                double value = this.jsonobj.getDouble(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0.0;
            }
        }

        public char fetchCharField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return '\u0000';
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                char value = '\u0000';
                if (str != null && str.length() > 0) {
                    value = str.charAt(0);
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return '\u0000';
            }
        }

        public byte fetchByteField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return 0;
            }
            try {
                String str = this.jsonobj.getString(fieldName);
                byte value = 0;
                if (str != null && str.length() > 0) {
                    value = str.getBytes()[0];
                }
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return 0;
            }
        }

        public boolean fetchBooleanField(int position) {
            String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName();
            if (!this.jsonobj.has(fieldName)) {
                return false;
            }
            try {
                boolean value = this.jsonobj.getBoolean(fieldName);
                if (this.sm != null) {
                    this.sm.makeDirty(position);
                }
                return value;
            }
            catch (JSONException jSONException) {
                return false;
            }
        }

        public void storeStringField(int arg0, String arg1) {
        }

        public void storeShortField(int arg0, short arg1) {
        }

        public void storeObjectField(int arg0, Object arg1) {
        }

        public void storeLongField(int arg0, long arg1) {
        }

        public void storeIntField(int arg0, int arg1) {
        }

        public void storeFloatField(int arg0, float arg1) {
        }

        public void storeDoubleField(int arg0, double arg1) {
        }

        public void storeCharField(int arg0, char arg1) {
        }

        public void storeByteField(int arg0, byte arg1) {
        }

        public void storeBooleanField(int arg0, boolean arg1) {
        }
    }
}

