/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.json.JSONException;
import org.json.JSONObject;

public class FetchFieldManager
implements FieldManager {
    StateManager sm;
    JSONObject result;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public FetchFieldManager(StateManager sm, JSONObject result) {
        this.sm = sm;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            return this.result.getString(fieldName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return (short)this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber);
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return null;
        }
        try {
            if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = FetchFieldManager.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(mmd.getType())) {
                return new BigDecimal(this.result.getString(fieldName));
            }
            if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = FetchFieldManager.class$("java.math.BigInteger")) : class$java$math$BigInteger).isAssignableFrom(mmd.getType())) {
                return new BigInteger("" + this.result.getString(fieldName));
            }
        }
        catch (JSONException e) {
            return null;
        }
        throw new NucleusException("Cant fetch field " + mmd).setFatal();
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0L;
        }
        try {
            return this.result.getLong(fieldName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            return this.result.getInt(fieldName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0f;
        }
        try {
            return (float)this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0.0;
        }
        try {
            return this.result.getDouble(fieldName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return '\u0000';
        }
        try {
            return this.result.getString(fieldName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return 0;
        }
        try {
            String str = this.result.getString(fieldName);
            return new Byte(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.sm.getClassMetaData().getMetaDataForMemberAtRelativePosition(fieldNumber).getName();
        if (this.result.isNull(fieldName)) {
            return false;
        }
        try {
            return this.result.getBoolean(fieldName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeObjectField(int fieldNumber, Object value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

