/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.JsonStoreManager;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.fieldmanager.InsertFieldManager;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPersistenceHandler
implements StorePersistenceHandler {
    private JsonStoreManager storeMgr;

    JsonPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (JsonStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
        String url = sm.getClassMetaData().getValueForExtension("url");
        Properties options = new Properties();
        if (url != null) {
            ((Hashtable)options).put("org.datanucleus.store.json.url", url);
        }
        ManagedConnection mconn = this.getConnection(sm.getObjectManager(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        HashMap attrs = new HashMap();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        this.write("POST", conn.getURL().toExternalForm(), conn, attrs);
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        String url = sm.getClassMetaData().getValueForExtension("url");
        Properties options = new Properties();
        if (url != null) {
            ((Hashtable)options).put("org.datanucleus.store.json.url", url);
        }
        ManagedConnection mconn = this.getConnection(sm.getObjectManager(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        HashMap attrs = new HashMap();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        this.write("PUT", conn.getURL().toExternalForm(), conn, attrs);
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        HashMap attrs = new HashMap();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        String url = sm.getClassMetaData().getValueForExtension("url");
        url = (String)attrs.values().iterator().next();
        Properties options = new Properties();
        if (url != null) {
            ((Hashtable)options).put("org.datanucleus.store.json.url", url);
        }
        ManagedConnection mconn = this.getConnection(sm.getObjectManager(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        try {
            JSONObject json = new JSONObject(attrs);
            int length = json.toString().length();
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setRequestProperty("Content-Length", "" + length);
            http.setRequestMethod("DELETE");
            http.setReadTimeout(10000);
            http.connect();
            http.getResponseCode();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        HashMap attrs = new HashMap();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        String url = sm.getClassMetaData().getValueForExtension("url");
        url = (String)attrs.values().iterator().next();
        Properties options = new Properties();
        if (url != null) {
            ((Hashtable)options).put("org.datanucleus.store.json.url", url);
        }
        ManagedConnection mconn = this.getConnection(sm.getObjectManager(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        attrs = new HashMap();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        JSONObject result = this.read("GET", conn.getURL().toExternalForm(), conn, attrs);
        sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result));
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        String url = sm.getClassMetaData().getValueForExtension("url");
        Properties options = new Properties();
        if (url != null) {
            ((Hashtable)options).put("org.datanucleus.store.json.url", url);
        }
        ManagedConnection mconn = this.getConnection(sm.getObjectManager(), options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        HashMap attrs = new HashMap();
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, attrs));
        try {
            JSONObject json = new JSONObject(attrs);
            json.toString().length();
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setDoOutput(true);
            http.setRequestMethod("HEAD");
            http.setReadTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
        }
        catch (IOException e) {
            throw new NucleusObjectNotFoundException(e.getMessage(), (Object)e);
        }
    }

    private ManagedConnection getConnection(ObjectManager om, Properties options) {
        ConnectionFactory factory = this.storeMgr.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory("json/tx");
        return factory.createManagedConnection(om, (Map)options);
    }

    private void write(String method, String requestUri, URLConnection conn, Map attrs) {
        try {
            JSONObject json = new JSONObject(attrs);
            int length = json.toString().length();
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setRequestProperty("Content-Length", "" + length);
            http.setDoOutput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.connect();
            OutputStream os = conn.getOutputStream();
            os.write(json.toString().getBytes());
            os.flush();
            os.close();
            http.getResponseCode();
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private JSONObject read(String method, String requestUri, URLConnection conn, Map attrs) {
        try {
            JSONObject json = new JSONObject(attrs);
            int length = json.toString().length();
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setRequestProperty("Content-Length", "" + length);
            http.setDoInput(true);
            http.setRequestMethod(method);
            http.setReadTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code == 404) {
                throw new NucleusObjectNotFoundException();
            }
            http.getResponseMessage();
            StringBuffer sb = new StringBuffer();
            if (http.getContentLength() > 0) {
                for (int i = 0; i < http.getContentLength(); ++i) {
                    sb.append((char)http.getInputStream().read());
                }
            } else {
                int r;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((r = http.getInputStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
            }
            http.getInputStream().close();
            return new JSONObject(sb.toString());
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }
}

