/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.state;

import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.LifeCycleState;

class PersistentDeleted
extends LifeCycleState {
    protected PersistentDeleted() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = false;
        this.isDeleted = true;
        this.isTransactional = true;
        this.stateType = 8;
    }

    public LifeCycleState transitionMakeNontransactional(StateManager sm) {
        throw new NucleusUserException(LOCALISER.msg("027007"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionMakeTransient(StateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        throw new NucleusUserException(LOCALISER.msg("027008"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionMakePersistent(StateManager sm) {
        return this.changeState(sm, 2);
    }

    public LifeCycleState transitionCommit(StateManager sm, Transaction tx) {
        if (!tx.getRetainValues()) {
            sm.clearFields();
        }
        return this.changeState(sm, 0);
    }

    public LifeCycleState transitionRollback(StateManager sm, Transaction tx) {
        if (tx.getRetainValues()) {
            if (tx.getRestoreValues()) {
                sm.restoreFields();
            }
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionWriteField(StateManager sm) {
        throw new NucleusUserException(LOCALISER.msg("027010"), sm.getInternalObjectId());
    }

    public String toString() {
        return "P_DELETED";
    }
}

