/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.jpa.EntityManagerImpl;
import org.datanucleus.jpa.JPAClassTransformer;
import org.datanucleus.jpa.JPADataStoreCache;
import org.datanucleus.jpa.JPAQueryCache;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.jpa.PersistenceProviderImpl;
import org.datanucleus.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.jpa.exceptions.NotProviderException;
import org.datanucleus.jpa.metamodel.MetamodelImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.query.cache.QueryCompilationCache;
import org.datanucleus.store.query.cache.QueryDatastoreCompilationCache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements EntityManagerFactory,
PersistenceUnitUtil {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.JPA");
    protected JDOPersistenceManagerFactory pmf;
    private static Map<String, PersistenceUnitMetaData> unitMetaDataCache = null;
    private PersistenceUnitMetaData unitMetaData = null;
    private boolean closed = false;
    private boolean containerManaged = false;
    private Cache datastoreCache = null;
    private JPAQueryCache queryCache = null;
    private MetamodelImpl metamodel = null;

    public EntityManagerFactoryImpl() {
    }

    public EntityManagerFactoryImpl(PersistenceUnitInfo unitInfo, Map overridingProps) {
        boolean allowMetadataLoad;
        Object addCTVal;
        this.containerManaged = true;
        boolean validProvider = false;
        if (unitInfo.getPersistenceProviderClassName() == null || unitInfo.getPersistenceProviderClassName().equals(PersistenceProviderImpl.class.getName()) || overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)unitInfo.getPersistenceUnitName()));
        }
        URI rootURI = null;
        try {
            rootURI = unitInfo.getPersistenceUnitRootUrl().toURI();
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.JTA.toString(), rootURI);
        } else if (unitInfo.getTransactionType() == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            this.unitMetaData = new PersistenceUnitMetaData(unitInfo.getPersistenceUnitName(), TransactionType.RESOURCE_LOCAL.toString(), rootURI);
        }
        List classNames = unitInfo.getManagedClassNames();
        Iterator classIter = classNames.iterator();
        while (classIter.hasNext()) {
            this.unitMetaData.addClassName((String)classIter.next());
        }
        List mappingFileNames = unitInfo.getMappingFileNames();
        Iterator mappingFileIter = mappingFileNames.iterator();
        while (mappingFileIter.hasNext()) {
            this.unitMetaData.addMappingFile((String)mappingFileIter.next());
        }
        List jarUrls = unitInfo.getJarFileUrls();
        Iterator jarUrlIter = jarUrls.iterator();
        while (jarUrlIter.hasNext()) {
            this.unitMetaData.addJarFile((URL)jarUrlIter.next());
        }
        Properties props = unitInfo.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                this.unitMetaData.addProperty(prop, props.getProperty(prop));
            }
        }
        if (unitInfo.excludeUnlistedClasses()) {
            this.unitMetaData.setExcludeUnlistedClasses();
        }
        this.unitMetaData.setProvider(unitInfo.getPersistenceProviderClassName());
        overridingProps = overridingProps == null ? new HashMap<String, Object>() : new HashMap(overridingProps);
        PersistenceUnitTransactionType type = unitInfo.getTransactionType();
        if (type == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getNonJtaDataSource());
            }
        } else if (type == PersistenceUnitTransactionType.JTA) {
            if (unitInfo.getJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getJtaDataSource());
            }
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory2", unitInfo.getNonJtaDataSource());
            }
        } else {
            if (unitInfo.getJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory", unitInfo.getJtaDataSource());
            }
            if (unitInfo.getNonJtaDataSource() != null) {
                overridingProps.put("datanucleus.ConnectionFactory2", unitInfo.getNonJtaDataSource());
            }
        }
        if (unitInfo.getClassLoader() != null) {
            overridingProps.put("datanucleus.primaryClassLoader", unitInfo.getClassLoader());
        }
        boolean addClassTransformer = true;
        if (this.unitMetaData.getProperties() != null && (addCTVal = this.unitMetaData.getProperties().get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("false")) {
            addClassTransformer = false;
        }
        if (overridingProps != null && (addCTVal = overridingProps.get("datanucleus.jpa.addClassTransformer")) != null && ((String)addCTVal).equalsIgnoreCase("false")) {
            addClassTransformer = false;
        }
        if (addClassTransformer) {
            try {
                unitInfo.addTransformer((ClassTransformer)new JPAClassTransformer());
            }
            catch (IllegalStateException ise) {
                LOGGER.warn((Object)"Exception was caught when adding the class transformer. Ignoring it.", (Throwable)ise);
            }
        }
        this.pmf = this.initialisePMF(this.unitMetaData, overridingProps);
        OMFContext omfCtx = this.pmf.getOMFContext();
        if (this.pmf.hasLevel2Cache()) {
            this.datastoreCache = new JPADataStoreCache(omfCtx, this.pmf.getLevel2Cache());
        }
        if (!(allowMetadataLoad = omfCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime"))) {
            omfCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public EntityManagerFactoryImpl(String unitName, Map overridingProps) {
        boolean allowMetadataLoad;
        if (unitMetaDataCache == null) {
            unitMetaDataCache = new HashMap<String, PersistenceUnitMetaData>();
        }
        this.unitMetaData = unitMetaDataCache.get(unitName);
        if (this.unitMetaData == null) {
            OMFContext omfCtx = new OMFContext(new PersistenceConfiguration(){});
            omfCtx.setApi("JPA");
            MetaDataManager metadataMgr = omfCtx.getMetaDataManager();
            PersistenceFileMetaData[] files = metadataMgr.parsePersistenceFiles();
            if (files == null) {
                LOGGER.warn((Object)LOCALISER.msg("EMF.NoPersistenceXML"));
            } else {
                for (int i = 0; i < files.length; ++i) {
                    PersistenceUnitMetaData[] unitmds = files[i].getPersistenceUnits();
                    for (int j = 0; j < unitmds.length; ++j) {
                        unitMetaDataCache.put(unitmds[j].getName(), unitmds[j]);
                        if (!unitmds[j].getName().equals(unitName)) continue;
                        this.unitMetaData = unitmds[j];
                        this.unitMetaData.clearJarFiles();
                    }
                }
            }
            if (this.unitMetaData == null) {
                LOGGER.warn((Object)LOCALISER.msg("EMF.PersistenceUnitNotFound", (Object)unitName));
            } else {
                unitMetaDataCache.put(this.unitMetaData.getName(), this.unitMetaData);
            }
        }
        boolean validProvider = false;
        if (this.unitMetaData != null && (this.unitMetaData.getProvider() == null || this.unitMetaData.getProvider().equals(PersistenceProviderImpl.class.getName()))) {
            validProvider = true;
        }
        if (overridingProps != null && PersistenceProviderImpl.class.getName().equals(overridingProps.get("javax.persistence.provider"))) {
            validProvider = true;
        }
        if (!validProvider) {
            throw new NotProviderException(LOCALISER.msg("EMF.NotProviderForPersistenceUnit", (Object)unitName));
        }
        this.pmf = this.initialisePMF(this.unitMetaData, overridingProps);
        OMFContext omfCtx = this.pmf.getOMFContext();
        if (this.pmf.hasLevel2Cache()) {
            this.datastoreCache = new JPADataStoreCache(omfCtx, this.pmf.getLevel2Cache());
        }
        if (!(allowMetadataLoad = omfCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.allowLoadAtRuntime"))) {
            omfCtx.getMetaDataManager().setAllowMetaDataLoad(false);
        }
    }

    public boolean isContainerManaged() {
        return this.containerManaged;
    }

    public void close() {
        this.assertIsClosed();
        this.pmf.close();
        this.closed = true;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public JPAQueryCache getQueryCache() {
        this.assertIsClosed();
        if (this.queryCache != null) {
            return this.queryCache;
        }
        this.queryCache = new JPAQueryCache(this.pmf.getOMFContext().getQueryManager().getQueryResultsCache());
        return this.queryCache;
    }

    public QueryCompilationCache getQueryGenericCompilationCache() {
        return this.pmf.getOMFContext().getQueryManager().getQueryCompilationCache();
    }

    public QueryDatastoreCompilationCache getQueryDatastoreCompilationCache() {
        return this.pmf.getOMFContext().getQueryManager().getQueryDatastoreCompilationCache();
    }

    public EntityManager createEntityManager() {
        this.assertIsClosed();
        PersistenceContextType persistenceContext = PersistenceContextType.EXTENDED;
        if (this.containerManaged) {
            persistenceContext = PersistenceContextType.TRANSACTION;
        }
        return this.newEntityManager(persistenceContext, (PersistenceManagerFactory)this.pmf);
    }

    public EntityManager createEntityManager(Map overridingProps) {
        this.assertIsClosed();
        JDOPersistenceManagerFactory thePMF = this.initialisePMF(this.unitMetaData, overridingProps);
        PersistenceContextType persistenceContext = PersistenceContextType.EXTENDED;
        if (this.containerManaged) {
            persistenceContext = PersistenceContextType.TRANSACTION;
        }
        return this.newEntityManager(persistenceContext, (PersistenceManagerFactory)thePMF);
    }

    protected EntityManager newEntityManager(PersistenceContextType contextType, PersistenceManagerFactory pmf) {
        return new EntityManagerImpl(this, pmf, contextType);
    }

    protected JDOPersistenceManagerFactory initialisePMF(PersistenceUnitMetaData unitMetaData, Map overridingProps) {
        boolean loadClasses;
        Properties unitProps;
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.jdo.JDOPersistenceManagerFactory");
        props.put("datanucleus.persistenceApiName", "JPA");
        if (unitMetaData.getJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactoryName", unitMetaData.getJtaDataSource());
        }
        if (unitMetaData.getNonJtaDataSource() != null) {
            props.put("datanucleus.ConnectionFactory2Name", unitMetaData.getNonJtaDataSource());
        }
        if (unitMetaData.getTransactionType() != null) {
            props.put("datanucleus.TransactionType", unitMetaData.getTransactionType().toString());
        }
        if ((unitProps = unitMetaData.getProperties()) != null) {
            props.putAll(unitProps);
        }
        String persistenceContextTypeProp = null;
        if (props.containsKey("datanucleus.jpa.persistenceContextType")) {
            persistenceContextTypeProp = (String)props.get("datanucleus.jpa.persistenceContextType");
        }
        if (overridingProps != null && overridingProps.containsKey("datanucleus.jpa.persistenceContextType")) {
            persistenceContextTypeProp = (String)overridingProps.get("datanucleus.jpa.persistenceContextType");
        }
        if (persistenceContextTypeProp != null && persistenceContextTypeProp.equalsIgnoreCase("transaction")) {
            props.put("datanucleus.DetachAllOnCommit", "true");
            props.put("datanucleus.DetachOnClose", "false");
        } else if (persistenceContextTypeProp != null && persistenceContextTypeProp.equalsIgnoreCase("extended")) {
            props.put("datanucleus.DetachAllOnCommit", "false");
            props.put("datanucleus.DetachOnClose", "true");
        } else if (this.containerManaged) {
            props.put("datanucleus.DetachAllOnCommit", "true");
            props.put("datanucleus.DetachOnClose", "false");
        } else {
            props.put("datanucleus.DetachAllOnCommit", "false");
            props.put("datanucleus.DetachOnClose", "true");
        }
        if (overridingProps != null) {
            props.putAll(overridingProps);
        }
        props.put("datanucleus.autoStartMechanism", "None");
        props.remove("datanucleus.PersistenceUnitName");
        props.remove("datanucleus.jpa.persistenceContextType");
        JDOPersistenceManagerFactory thePMF = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory(props);
        OMFContext omfCtx = thePMF.getOMFContext();
        if (unitMetaData != null) {
            omfCtx.getMetaDataManager().loadPersistenceUnit(unitMetaData, null);
        }
        if (loadClasses = omfCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.persistenceUnitLoadClasses")) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("EMF.RegisterClassesWithStore"));
            }
            Collection loadedClasses = omfCtx.getMetaDataManager().getClassesWithMetaData();
            omfCtx.getStoreManager().addClasses(loadedClasses.toArray(new String[loadedClasses.size()]), omfCtx.getClassLoaderResolver(null));
        }
        return thePMF;
    }

    public Map<String, Object> getProperties() {
        return this.pmf.getOMFContext().getPersistenceConfiguration().getPersistenceProperties();
    }

    public Set<String> getSupportedProperties() {
        return this.pmf.getOMFContext().getPersistenceConfiguration().getSupportedProperties();
    }

    protected void assertIsClosed() {
        if (this.closed) {
            throw new IllegalStateException("EntityManagerFactory is already closed");
        }
    }

    public Cache getCache() {
        this.assertIsClosed();
        return this.datastoreCache;
    }

    public Metamodel getMetamodel() {
        this.assertIsClosed();
        if (this.metamodel != null) {
            return this.metamodel;
        }
        this.metamodel = new MetamodelImpl(this.pmf.getOMFContext().getMetaDataManager());
        return this.metamodel;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.assertIsClosed();
        return new CriteriaBuilderImpl((MetamodelImpl)this.getMetamodel());
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this;
    }

    public Object getIdentifier(Object entity) {
        return this.pmf.getOMFContext().getApiAdapter().getIdForObject(entity);
    }

    public boolean isLoaded(Object entity, String attrName) {
        OMFContext omfCtx = this.pmf.getOMFContext();
        JDOPersistenceManager pm = (JDOPersistenceManager)omfCtx.getApiAdapter().getPersistenceManager(entity);
        if (pm == null) {
            return false;
        }
        ObjectManager om = pm.getObjectManager();
        StateManager sm = om.findStateManager(entity);
        if (sm == null) {
            return false;
        }
        AbstractClassMetaData cmd = omfCtx.getMetaDataManager().getMetaDataForClass(entity.getClass(), omfCtx.getClassLoaderResolver(entity.getClass().getClassLoader()));
        if (cmd == null) {
            return false;
        }
        return omfCtx.getApiAdapter().isLoaded(sm.getObjectProvider(), cmd.getAbsolutePositionOfMember(attrName));
    }

    public boolean isLoaded(Object entity) {
        OMFContext omfCtx = this.pmf.getOMFContext();
        return !omfCtx.getApiAdapter().getObjectState(entity).equals("hollow");
    }
}

