/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.query.HBaseQueryCompilation;
import org.datanucleus.store.hbase.query.HBaseQueryUtils;
import org.datanucleus.store.hbase.query.QueryToHBaseMapper;
import org.datanucleus.store.hbase.query.expression.HBaseBooleanExpression;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.inmemory.JPQLInMemoryEvaluator;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    private static final long serialVersionUID = -747445217646824746L;
    protected transient HBaseQueryCompilation datastoreCompilation;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        return this.compilation != null && this.datastoreCompilation != null;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateinmemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (HBaseQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        this.datastoreCompilation = new HBaseQueryCompilation();
        AbstractClassMetaData cmd = this.getCandidateClassMetaData();
        HBaseQueryCompilation hBaseQueryCompilation = this.datastoreCompilation;
        synchronized (hBaseQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (this.datastoreCompilation.isPrecompilable() && cacheKey != null) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    protected AbstractClassMetaData getCandidateClassMetaData() {
        String[] impls;
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        if (this.candidateClass.isInterface() && ((impls = this.ec.getMetaDataManager().getClassesImplementingInterface(this.candidateClass.getName(), this.clr)).length != 1 || !cmd.isImplementationOfPersistentDefinition()) && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.candidateClass, this.clr)) == null) {
            throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        HBaseManagedConnection mconn = (HBaseManagedConnection)this.getStoreManager().getConnectionManager().getConnection(this.ec);
        try {
            Object object;
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JPQL", this.getSingleStringQuery(), null}));
            }
            boolean filterInMemory = true;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else {
                Table table;
                Filter filter = null;
                HBaseBooleanExpression filterExpr = null;
                AbstractClassMetaData cmd = this.getCandidateClassMetaData();
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    this.storeMgr.manageClasses(this.clr, new String[]{cmd.getFullClassName()});
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                Table table2 = table = sd != null ? sd.getTable() : null;
                if (table != null) {
                    Column softDeleteCol;
                    Column multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY);
                    if (multitenancyCol != null) {
                        String familyName = HBaseUtils.getFamilyNameForColumn(multitenancyCol);
                        String qualifName = HBaseUtils.getQualifierNameForColumn(multitenancyCol);
                        String value = this.ec.getTenantId();
                        filterExpr = new HBaseBooleanExpression(familyName, qualifName, value, (Expression.Operator)Expression.OP_EQ);
                    }
                    if ((softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE)) != null) {
                        String familyName = HBaseUtils.getFamilyNameForColumn(softDeleteCol);
                        String qualifName = HBaseUtils.getQualifierNameForColumn(softDeleteCol);
                        HBaseBooleanExpression softDeleteFilterExpr = new HBaseBooleanExpression(familyName, qualifName, Boolean.FALSE, (Expression.Operator)Expression.OP_EQ);
                        filterExpr = filterExpr != null ? new HBaseBooleanExpression(filterExpr, softDeleteFilterExpr, (Expression.Operator)Expression.OP_AND) : softDeleteFilterExpr;
                    }
                }
                if (this.datastoreCompilation != null && this.datastoreCompilation.isFilterComplete()) {
                    HBaseBooleanExpression userFilterExpr = this.datastoreCompilation.getFilterExpression();
                    if (filterExpr == null) {
                        filterExpr = userFilterExpr;
                    } else if (userFilterExpr != null) {
                        filterExpr = new HBaseBooleanExpression(filterExpr, userFilterExpr, (Expression.Operator)Expression.OP_AND);
                    }
                }
                if (filterExpr != null) {
                    filter = filterExpr.getFilter();
                }
                candidates = HBaseQueryUtils.getObjectsOfCandidateType(this.ec, mconn, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan(), filter, this.storeMgr);
                if (filter != null && this.datastoreCompilation != null && this.datastoreCompilation.isFilterComplete()) {
                    filterInMemory = false;
                }
            }
            JPQLInMemoryEvaluator resultMapper = new JPQLInMemoryEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(filterInMemory, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JPQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == Query.QueryType.BULK_DELETE) {
                this.ec.deleteObjects(results.toArray());
                object = (long)results.size();
                return object;
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            object = results;
            return object;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021083", (Object[])new Object[]{this.getLanguage(), this.toString()}));
        }
        QueryToHBaseMapper mapper = new QueryToHBaseMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilterExpression(mapper.getFilterExpression());
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021084", (Object[])new Object[]{this.getLanguage(), System.currentTimeMillis() - startTime}));
        }
    }
}

