/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query.expression;

import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.hbase.query.expression.HBaseExpression;
import org.datanucleus.store.schema.table.MemberColumnMapping;

public class HBaseFieldExpression
extends HBaseExpression {
    final Class type;
    final String familyName;
    final String columnName;
    MemberColumnMapping mapping;
    AbstractMemberMetaData mmd;

    public HBaseFieldExpression(Class type, String familyName, String columnName, AbstractMemberMetaData mmd, MemberColumnMapping mapping) {
        this.type = type;
        this.familyName = familyName;
        this.columnName = columnName;
        this.mmd = mmd;
        this.mapping = mapping;
    }

    public MemberColumnMapping getMemberColumnMapping() {
        return this.mapping;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        return this.mmd;
    }

    public Class getType() {
        if (this.type.isEnum()) {
            ColumnMetaData colmd = null;
            if (this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0) {
                colmd = this.mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return Integer.TYPE;
            }
            return String.class;
        }
        return this.type;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

