/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.ClassUtils;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Put put, Delete delete, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, cmd, put, delete, insert, table);
        this.mmds = mmds;
    }

    public StoreEmbeddedFieldManager(DNStateManager sm, Put put, Delete delete, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(sm, put, delete, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            DNStateManager ownerSM;
            if (this.sm == null || (ownerSM = this.ec.getOwnerForEmbeddedStateManager(this.sm)) == null || value == ownerSM.getObject()) return;
            this.sm.replaceField(fieldNumber, ownerSM.getObject());
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, lastMmd)) {
            if (!RelationType.isRelationSingleValued((RelationType)relationType)) throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but field of this type not suppported");
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
            embMmds.add(mmd);
            if (value == null) {
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.put, this.delete, this.insert, embMmds, this.table);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                for (int i = 0; i < embMmdPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                    if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                        ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                        colEmbMmds.add(embMmd);
                        MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                        Column col = mapping.getColumn(0);
                        String colFamName = HBaseUtils.getFamilyNameForColumn(col);
                        String colQualName = HBaseUtils.getQualifierNameForColumn(col);
                        this.delete.addColumn(colFamName.getBytes(), colQualName.getBytes());
                        continue;
                    }
                    if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                    storeEmbFM.storeObjectField(embMmdPosns[i], null);
                }
            } else {
                DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(embSM, this.put, this.delete, this.insert, embMmds, this.table);
                embSM.provideFields(embCmd.getAllMemberPositions(), (FieldManager)storeEmbFM);
                return;
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

