/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.query;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseManagedConnection;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.NucleusLogger;

class HBaseQueryUtils {
    private HBaseQueryUtils() {
    }

    static List getObjectsOfCandidateType(ExecutionContext ec, HBaseManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fetchPlan, Filter filter, StoreManager storeMgr) {
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec);
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects for candidate=" + candidateClass.getName() + (subclasses ? " and subclasses" : "") + (String)(filter != null ? " with filter=" + filter : "")));
        }
        ArrayList results = new ArrayList();
        for (AbstractClassMetaData cmd : cmds) {
            if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            results.addAll(HBaseQueryUtils.getObjectsOfType(ec, mconn, cmd, ignoreCache, fetchPlan, filter, storeMgr));
        }
        return results;
    }

    private static List getObjectsOfType(final ExecutionContext ec, final HBaseManagedConnection mconn, final AbstractClassMetaData cmd, boolean ignoreCache, FetchPlan fp, final Filter filter, StoreManager storeMgr) {
        ArrayList<Object> results = new ArrayList<Object>();
        StoreData sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            storeMgr.manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        }
        final org.datanucleus.store.schema.table.Table table = sd.getTable();
        final String tableName = table.getName();
        final int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
        try {
            final ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    byte[] qualifName;
                    byte[] familyName;
                    Scan scan = new Scan();
                    if (filter != null) {
                        scan.setFilter(filter);
                    }
                    for (int i = 0; i < fpMembers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                        RelationType relationType = mmd.getRelationType(clr);
                        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, null)) {
                            if (!RelationType.isRelationSingleValued((RelationType)relationType)) continue;
                            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                            embMmds.add(mmd);
                            HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, embMmds, table, ec);
                            continue;
                        }
                        MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                        int numCols = mapping.getNumberOfColumns();
                        for (int colNo = 0; colNo < numCols; ++colNo) {
                            Column col = mapping.getColumn(colNo);
                            byte[] familyName2 = HBaseUtils.getFamilyNameForColumn(col).getBytes();
                            byte[] qualifName2 = HBaseUtils.getQualifierNameForColumn(col).getBytes();
                            scan.addColumn(familyName2, qualifName2);
                        }
                    }
                    VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                    if (cmd.isVersioned() && vermd.getFieldName() == null) {
                        familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.VERSION)).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.VERSION)).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    if (cmd.hasDiscriminatorStrategy()) {
                        familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR)).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR)).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                        familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID)).getBytes();
                        qualifName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID)).getBytes();
                        scan.addColumn(familyName, qualifName);
                    }
                    Table htable = mconn.getHTable(tableName);
                    ResultScanner scanner = htable.getScanner(scan);
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumReads();
                    }
                    Iterator it = scanner.iterator();
                    return it;
                }
            });
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingApplicationIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr, table);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingDatastoreIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr, table);
                    if (obj == null) continue;
                    results.add(obj);
                }
            } else {
                while (it.hasNext()) {
                    Result result = (Result)it.next();
                    Object obj = HBaseQueryUtils.getObjectUsingNondurableIdForResult(result, cmd, ec, ignoreCache, fpMembers, tableName, storeMgr, table);
                    if (obj == null) continue;
                    results.add(obj);
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw new NucleusDataStoreException(e.getMessage(), e.getCause());
        }
        return results;
    }

    protected static Object getObjectUsingApplicationIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr, org.datanucleus.store.schema.table.Table table) {
        if (cmd.hasDiscriminatorStrategy()) {
            String familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String columnName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            Object cmdDiscValue = cmd.getDiscriminatorValue();
            if (cmd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && !cmdDiscValue.equals(discValue)) {
                return null;
            }
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, table);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        Persistable pc = ec.findObject(id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        if (cmd.isVersioned()) {
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            op.setVersion(version);
        }
        op.replaceAllLoadedSCOFieldsWithWrappers();
        if (result.getRow() != null) {
            ObjectProvider sm = ec.findObjectProvider((Object)pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    protected static Object getObjectUsingDatastoreIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr, org.datanucleus.store.schema.table.Table table) {
        if (cmd.hasDiscriminatorStrategy()) {
            String familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String columnName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            Object cmdDiscValue = cmd.getDiscriminatorValue();
            if (cmd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && !cmdDiscValue.equals(discValue)) {
                return null;
            }
        }
        String dsidFamilyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID));
        String dsidColumnName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID));
        DatastoreId id = null;
        try {
            byte[] bytes = result.getValue(dsidFamilyName.getBytes(), dsidColumnName.getBytes());
            if (bytes == null) {
                throw new NucleusException("Retrieved identity for family=" + dsidFamilyName + " column=" + dsidColumnName + " IS NULL");
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object key = ois.readObject();
            id = ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), key);
            ois.close();
            bis.close();
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, table);
        Persistable pc = ec.findObject((Object)id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, null, ignoreCache, false);
        ObjectProvider op = ec.findObjectProvider((Object)pc);
        if (cmd.isVersioned()) {
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            op.setVersion(version);
        }
        op.replaceAllLoadedSCOFieldsWithWrappers();
        if (result.getRow() != null) {
            ObjectProvider sm = ec.findObjectProvider((Object)pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    protected static Object getObjectUsingNondurableIdForResult(Result result, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers, String tableName, StoreManager storeMgr, org.datanucleus.store.schema.table.Table table) {
        if (cmd.hasDiscriminatorStrategy()) {
            String familyName = HBaseUtils.getFamilyNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String columnName = HBaseUtils.getQualifierNameForColumn(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR));
            String discValue = new String(result.getValue(familyName.getBytes(), columnName.getBytes()));
            Object cmdDiscValue = cmd.getDiscriminatorValue();
            if (cmd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && !cmdDiscValue.equals(discValue)) {
                return null;
            }
        }
        FetchFieldManager fm = new FetchFieldManager(ec, cmd, result, table);
        SCOID id = new SCOID(cmd.getFullClassName());
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Persistable pc = ec.findObject((Object)id, new FieldValues((FieldManager)fm){
            final /* synthetic */ FieldManager val$fm;
            {
                this.val$fm = fieldManager;
            }

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, this.val$fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, this.val$fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider op = ec.findObjectProvider((Object)pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = op.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = HBaseUtils.getSurrogateVersionForObject(cmd, result, tableName, storeMgr);
            }
            op.setVersion(version);
        }
        if (result.getRow() != null) {
            ObjectProvider sm = ec.findObjectProvider((Object)pc);
            sm.setAssociatedValue((Object)"HBASE_ROW_KEY", (Object)result.getRow());
        }
        return pc;
    }

    private static void addColumnsToScanForEmbeddedMember(Scan scan, List<AbstractMemberMetaData> embMmds, org.datanucleus.store.schema.table.Table table, ExecutionContext ec) {
        AbstractMemberMetaData penultimateMmd = embMmds.size() > 1 ? embMmds.get(embMmds.size() - 2) : null;
        AbstractMemberMetaData lastMmd = embMmds.get(embMmds.size() - 1);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(lastMmd.getTypeName(), clr);
        int[] embMmdPosns = embCmd.getAllMemberPositions();
        for (int i = 0; i < embMmdPosns.length; ++i) {
            AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
            ArrayList<AbstractMemberMetaData> subEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
            subEmbMmds.add(embMmd);
            RelationType relationType = embMmd.getRelationType(clr);
            MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(subEmbMmds);
            if (mapping != null) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    if (penultimateMmd != null && embMmd.getFullFieldName().equals(penultimateMmd.getFullFieldName())) continue;
                    HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, subEmbMmds, table, ec);
                    continue;
                }
                String familyName = HBaseUtils.getFamilyNameForColumn(mapping.getColumn(0));
                String qualifName = HBaseUtils.getQualifierNameForColumn(mapping.getColumn(0));
                scan.addColumn(familyName.getBytes(), qualifName.getBytes());
                continue;
            }
            if (!RelationType.isRelationSingleValued((RelationType)relationType) || penultimateMmd != null && embMmd.getFullFieldName().equals(penultimateMmd.getFullFieldName())) continue;
            HBaseQueryUtils.addColumnsToScanForEmbeddedMember(scan, subEmbMmds, table, ec);
        }
    }
}

