/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.hbase.fieldmanager;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.hbase.HBaseUtils;
import org.datanucleus.store.hbase.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    Table table;
    Put put;
    Delete delete;

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, Put put, Delete delete, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.put = put;
        this.delete = delete;
        this.table = table;
    }

    public StoreFieldManager(ObjectProvider op, Put put, Delete delete, boolean insert, Table table) {
        super(op, insert);
        this.put = put;
        this.delete = delete;
        this.table = table;
    }

    protected AbstractMemberMetaData getMemberMetaData(int fieldNumber) {
        return this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeBooleanInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeByteInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeCharInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeDoubleInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeFloatInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeIntInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeLongInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        this.storeShortInternal(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value, mmd.isSerialized());
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        Column col = this.getColumnMapping(fieldNumber).getColumn(0);
        AbstractMemberMetaData mmd = this.getMemberMetaData(fieldNumber);
        if (value == null) {
            this.delete.deleteColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes());
        } else if (mmd.isSerialized()) {
            this.writeObjectField(HBaseUtils.getFamilyNameForColumn(col), HBaseUtils.getQualifierNameForColumn(col), value);
        } else {
            this.put.add(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), value.getBytes());
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.put, this.delete, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            Column col = mapping.getColumn(0);
                            String colFamName = HBaseUtils.getFamilyNameForColumn(col);
                            String colQualName = HBaseUtils.getQualifierNameForColumn(col);
                            this.delete.deleteColumn(colFamName.getBytes(), colQualName.getBytes());
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    return;
                }
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.put, this.delete, this.insert, embMmds, this.table);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but field of this type not suppported. Mark as not persistent? or not embedded?");
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (value == null) {
                this.delete.deleteColumn(familyName.getBytes(), qualifName.getBytes());
                return;
            }
            Object valuePC = this.ec.persistObjectInternal(value, this.op, fieldNumber, -1);
            if (mmd.isSerialized()) {
                this.writeObjectField(familyName, qualifName, value);
            } else {
                Object valueId = this.ec.getApiAdapter().getIdForObject(valuePC);
                this.writeObjectField(familyName, qualifName, valueId);
            }
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (value == null) {
                this.delete.deleteColumn(familyName.getBytes(), qualifName.getBytes());
                return;
            }
            if (mmd.hasCollection()) {
                ArrayList<Object> collIds = new ArrayList<Object>();
                Collection coll = (Collection)value;
                for (Object element : coll) {
                    Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    this.writeObjectField(familyName, qualifName, value);
                } else {
                    this.writeObjectField(familyName, qualifName, collIds);
                }
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
            } else if (mmd.hasMap()) {
                HashMap mapIds = new HashMap();
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object mapKey = entry.getKey();
                    Object mapValue = entry.getValue();
                    if (this.ec.getApiAdapter().isPersistable(mapKey)) {
                        Object pKey = this.ec.persistObjectInternal(mapKey, this.op, fieldNumber, -1);
                        mapKey = this.ec.getApiAdapter().getIdForObject(pKey);
                    }
                    if (this.ec.getApiAdapter().isPersistable(mapValue)) {
                        Object pVal = this.ec.persistObjectInternal(mapValue, this.op, fieldNumber, -1);
                        mapValue = this.ec.getApiAdapter().getIdForObject(pVal);
                    }
                    mapIds.put(mapKey, mapValue);
                }
                if (mmd.isSerialized()) {
                    this.writeObjectField(familyName, qualifName, value);
                } else {
                    this.writeObjectField(familyName, qualifName, mapIds);
                }
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
            } else if (mmd.hasArray()) {
                ArrayList<Object> arrIds = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    Object elementPC = this.ec.persistObjectInternal(element, this.op, fieldNumber, -1);
                    Object elementID = this.ec.getApiAdapter().getIdForObject(elementPC);
                    arrIds.add(elementID);
                }
                if (mmd.isSerialized()) {
                    this.writeObjectField(familyName, qualifName, value);
                } else {
                    this.writeObjectField(familyName, qualifName, arrIds);
                }
            }
        } else {
            if (value == null) {
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    Column col = mapping.getColumn(i);
                    this.delete.deleteColumn(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes());
                }
                return;
            }
            if (mmd.isSerialized()) {
                Column col = mapping.getColumn(0);
                String familyName = HBaseUtils.getFamilyNameForColumn(col);
                String qualifName = HBaseUtils.getQualifierNameForColumn(col);
                this.writeObjectField(familyName, qualifName, value);
                this.op.wrapSCOField(fieldNumber, value, false, false, true);
                return;
            }
            if (mapping.getTypeConverter() != null) {
                Object datastoreValue = mapping.getTypeConverter().toDatastoreType(value);
                if (mapping.getNumberOfColumns() > 1) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        Column col = mapping.getColumn(i);
                        Object colValue = Array.get(datastoreValue, i);
                        byte[] valueColBytes = this.getPersistableBytesForObject(col, colValue);
                        this.put.add(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), valueColBytes);
                    }
                } else {
                    Column col = mapping.getColumn(0);
                    byte[] valueColBytes = this.getPersistableBytesForObject(col, value);
                    this.put.add(HBaseUtils.getFamilyNameForColumn(col).getBytes(), HBaseUtils.getQualifierNameForColumn(col).getBytes(), valueColBytes);
                }
                return;
            }
            Column col = mapping.getColumn(0);
            String familyName = HBaseUtils.getFamilyNameForColumn(col);
            String qualifName = HBaseUtils.getQualifierNameForColumn(col);
            if (Boolean.class.isAssignableFrom(value.getClass())) {
                this.storeBooleanInternal(familyName, qualifName, (Boolean)value, mmd.isSerialized());
                return;
            }
            if (Byte.class.isAssignableFrom(value.getClass())) {
                this.storeByteInternal(familyName, qualifName, (Byte)value, mmd.isSerialized());
                return;
            }
            if (Character.class.isAssignableFrom(value.getClass())) {
                this.storeCharInternal(familyName, qualifName, ((Character)value).charValue(), mmd.isSerialized());
                return;
            }
            if (Double.class.isAssignableFrom(value.getClass())) {
                this.storeDoubleInternal(familyName, qualifName, (Double)value, mmd.isSerialized());
                return;
            }
            if (Float.class.isAssignableFrom(value.getClass())) {
                this.storeFloatInternal(familyName, qualifName, ((Float)value).floatValue(), mmd.isSerialized());
                return;
            }
            if (Integer.class.isAssignableFrom(value.getClass())) {
                this.storeIntInternal(familyName, qualifName, (Integer)value, mmd.isSerialized());
                return;
            }
            if (Long.class.isAssignableFrom(value.getClass())) {
                this.storeLongInternal(familyName, qualifName, (Long)value, mmd.isSerialized());
                return;
            }
            if (Short.class.isAssignableFrom(value.getClass())) {
                this.storeShortInternal(familyName, qualifName, (Short)value, mmd.isSerialized());
                return;
            }
            if (Enum.class.isAssignableFrom(value.getClass())) {
                ColumnMetaData colmd = null;
                if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                    colmd = mmd.getColumnMetaData()[0];
                }
                if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                    this.put.add(familyName.getBytes(), qualifName.getBytes(), Bytes.toBytes((int)((Enum)value).ordinal()));
                } else {
                    this.put.add(familyName.getBytes(), qualifName.getBytes(), ((Enum)value).name().getBytes());
                }
                return;
            }
            TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            if (strConv != null) {
                String strValue = (String)strConv.toDatastoreType(value);
                this.put.add(familyName.getBytes(), qualifName.getBytes(), strValue.getBytes());
                return;
            }
            this.writeObjectField(familyName, qualifName, value);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        }
    }

    protected void writeObjectField(String familyName, String columnName, Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    private void storeBooleanInternal(String familyName, String columnName, boolean value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeBoolean(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((boolean)value));
        }
    }

    private void storeByteInternal(String familyName, String columnName, byte value, boolean serialised) {
        this.put.add(familyName.getBytes(), columnName.getBytes(), new byte[]{value});
    }

    private void storeCharInternal(String familyName, String columnName, char value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeChar(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), ("" + value).getBytes());
        }
    }

    private void storeDoubleInternal(String familyName, String columnName, double value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeDouble(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((double)value));
        }
    }

    private void storeFloatInternal(String familyName, String columnName, float value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeFloat(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((float)value));
        }
    }

    private void storeIntInternal(String familyName, String columnName, int value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeInt(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((int)value));
        }
    }

    private void storeLongInternal(String familyName, String columnName, long value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeLong(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((long)value));
        }
    }

    private void storeShortInternal(String familyName, String columnName, short value, boolean serialised) {
        if (serialised) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeShort(value);
                oos.flush();
                this.put.add(familyName.getBytes(), columnName.getBytes(), bos.toByteArray());
                oos.close();
                bos.close();
            }
            catch (IOException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.put.add(familyName.getBytes(), columnName.getBytes(), Bytes.toBytes((short)value));
        }
    }

    protected byte[] getPersistableBytesForObject(Column col, Object value) {
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((boolean)((Boolean)value));
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return new byte[]{(Byte)value};
        }
        if (Character.class.isAssignableFrom(value.getClass())) {
            return ("" + value).getBytes();
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((double)((Double)value));
        }
        if (Float.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((float)((Float)value).floatValue());
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((int)((Integer)value));
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((long)((Long)value));
        }
        if (Short.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((short)((Short)value));
        }
        if (BigDecimal.class.isAssignableFrom(value.getClass())) {
            return Bytes.toBytes((BigDecimal)((BigDecimal)value));
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return ((String)value).getBytes();
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            ColumnMetaData colmd = col.getColumnMetaData();
            if (MetaDataUtils.persistColumnAsNumeric((ColumnMetaData)colmd)) {
                return Bytes.toBytes((int)((Enum)value).ordinal());
            }
            return ((Enum)value).name().getBytes();
        }
        NucleusLogger.PERSISTENCE.warn((Object)("Persistence of column " + col + " has value of type " + value.getClass().getName() + " but no conversion to bytes defined. Report this"));
        return null;
    }
}

